/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import java.io.IOException;
import progress.message.broker.AgentRegistrar;
import progress.message.util.EAssertFailure;
import progress.message.util.QueueUtil;
import progress.message.zclient.QOP;

public class QoPConfigChangeHelper {
    public static void handleConfigurationChange(IComponentContext context, IElementChange elementChange, String configID, ConfigurationChangeBindHelper bindHelper) {
        if (elementChange.getChangeType() == 0) {
            QoPConfigChangeHelper.handleNewQoP(context, elementChange, bindHelper);
        }
    }

    public static void handleNewQoP(IComponentContext context, IElementChange elementChange, ConfigurationChangeBindHelper bindHelper) {
        IElement newElement = (IElement)elementChange.getElement();
        IAttributeSet das = newElement.getAttributes();
        if (das != null) {
            String resourceName = (String)das.getAttribute("RESOURCE_NAME");
            String resourceType = (String)das.getAttribute("RESOURCE_TYPE");
            if (resourceType.equalsIgnoreCase("queue")) {
                if (resourceName.startsWith("$Q.")) {
                    throw new EAssertFailure("RESOURCE_NAME " + resourceName + " cannot have prefix " + "$Q.");
                }
                resourceName = QueueUtil.queueNameToSecSubject(resourceName);
            }
            String qopName = (String)das.getAttribute("QOP");
            int qopType = 0;
            if (qopName.equalsIgnoreCase("NONE")) {
                qopType = 0;
            } else if (qopName.equalsIgnoreCase("INTEGRITY")) {
                qopType = 1;
            } else if (qopName.equalsIgnoreCase("PRIVACY")) {
                qopType = 2;
            }
            QOP qop = new QOP(qopType);
            if (qopName != null && resourceName != null) {
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().setQOP(resourceName, qop);
                    bindHelper.bindRemoveQoPChangeHandler(resourceName, das);
                    bindHelper.bindQoPTypeChangeHandler(resourceName, das);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

