/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.AttributesHolder;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IMessageGroupHandle;
import progress.message.broker.ISavableAgentQueue;

public class QueueConfigChangeHandler
implements IAttributeChangeHandler {
    private String m_queueName = null;
    private static volatile AttributesHolder s_attributesHolder = null;
    private static final Object ATTRIBUTEHOLDER_LOCK_OBJ = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueConfigChangeHandler(String queueName, AttributesHolder attributesHolder) {
        if (s_attributesHolder == null) {
            Object object = ATTRIBUTEHOLDER_LOCK_OBJ;
            synchronized (object) {
                if (s_attributesHolder == null) {
                    s_attributesHolder = attributesHolder;
                }
            }
        }
        this.m_queueName = queueName;
    }

    public void itemDeleted() {
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        IAgentQueue iaq = aqp.getAgentQueue(this.m_queueName);
        if (iaq == null || iaq.getQueueType() != 0) {
            return;
        }
        aqp.removeAdministrativelyCreatedQueue(this.m_queueName);
        s_attributesHolder.removeQueueAttributeSet(this.m_queueName);
        this.m_queueName = null;
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        String attributeName = null;
        attributeName = this.populateAttribute(delta, len, newAttributes);
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        len = modifiedAttributes.length;
        attributeName = null;
        attributeName = this.populateModifiedAttributes(delta, len, modifiedAttributes);
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        len = deletedAttributes.length;
        attributeName = null;
        for (int i = 0; i < len; ++i) {
            IAgentQueue iaq;
            attributeName = deletedAttributes[i];
            if (attributeName.equals("QUEUE_MAX_SIZE")) {
                iaq = aqp.getAgentQueue(this.m_queueName);
                iaq.setMaxQueueSizeInKiloBytes(1000);
                continue;
            }
            if (attributeName.equals("QUEUE_SAVE_THRESHOLD")) {
                iaq = aqp.getAgentQueue(this.m_queueName);
                ((ISavableAgentQueue)((Object)iaq)).setSaveThresholdInKiloBytes(1536);
                continue;
            }
            if (attributeName.equals("GLOBAL")) {
                iaq = aqp.getAgentQueue(this.m_queueName);
                iaq.setGlobal(false);
                continue;
            }
            if (attributeName.equals("READ_EXCLUSIVE")) {
                iaq = aqp.getAgentQueue(this.m_queueName);
                iaq.setReadExclusiveMode(false);
                continue;
            }
            if (attributeName.equals("CLUSTERED")) {
                iaq = aqp.getAgentQueue(this.m_queueName);
                iaq.setClustered(false);
                continue;
            }
            if (attributeName.equals("MAX_WAIT_TIME")) {
                this.populateMessageGroupMaxWaitTimeInSeconds(aqp);
                continue;
            }
            if (attributeName.equals("MIN_CONSUMERS")) {
                this.populateMessageGroupMinReceivers(aqp);
                continue;
            }
            if (!attributeName.equals("GROUP_IDLE_TIMEOUT")) continue;
            this.populateMessageGroupIdleTimeoutInSeconds(aqp);
        }
    }

    private String populateAttribute(IDeltaAttributeSet delta, int len, String[] newAttributes) {
        String attributeName = this.populateModifiedAttributes(delta, len, newAttributes);
        return attributeName;
    }

    private String populateModifiedAttributes(IDeltaAttributeSet delta, int len, String[] modifiedAttributes) {
        String attributeName = null;
        for (int i = 0; i < len; ++i) {
            attributeName = modifiedAttributes[i];
            this.setAttribute(attributeName, delta);
        }
        return attributeName;
    }

    private void populateMessageGroupMaxWaitTimeInSeconds(AgentQueueProcessor aqp) {
        IAgentQueue iaq = aqp.getAgentQueue(this.m_queueName);
        IMessageGroupHandle mh = iaq.getMessageGroupHandle();
        if (mh != null && mh.isMessageGroupEnabled()) {
            mh.setMessageGroupMaxWaitTimeInSeconds(10);
        }
    }

    private void populateMessageGroupMinReceivers(AgentQueueProcessor aqp) {
        IAgentQueue iaq = aqp.getAgentQueue(this.m_queueName);
        IMessageGroupHandle mh = iaq.getMessageGroupHandle();
        if (mh != null && mh.isMessageGroupEnabled()) {
            mh.setMessageGroupMinReceivers(2);
        }
    }

    private void populateMessageGroupIdleTimeoutInSeconds(AgentQueueProcessor aqp) {
        IAgentQueue iaq = aqp.getAgentQueue(this.m_queueName);
        IMessageGroupHandle mh = iaq.getMessageGroupHandle();
        if (mh != null && mh.isMessageGroupEnabled()) {
            mh.setMessageGroupIdleTimeoutInSeconds(-1);
        }
    }

    private void setAttribute(String attributeName, IDeltaAttributeSet delta) {
        block41: {
            IAgentQueue iaq;
            IMessageGroupHandle mh;
            if (attributeName.equals("QUEUE_MAX_SIZE")) {
                try {
                    Integer maxSize = (Integer)delta.getNewValue("QUEUE_MAX_SIZE");
                    if (maxSize != null) {
                        IAgentQueue iaq2 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                        iaq2.setMaxQueueSizeInKiloBytes(maxSize);
                    }
                }
                catch (NotModifiedAttException maxSize) {}
            } else if (attributeName.equals("QUEUE_SAVE_THRESHOLD")) {
                try {
                    Integer saveSize = (Integer)delta.getNewValue("QUEUE_SAVE_THRESHOLD");
                    if (saveSize != null) {
                        IAgentQueue iaq3 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                        ((ISavableAgentQueue)((Object)iaq3)).setSaveThresholdInKiloBytes(saveSize);
                    }
                }
                catch (NotModifiedAttException saveSize) {}
            } else if (attributeName.equals("GLOBAL")) {
                try {
                    Boolean global = (Boolean)delta.getNewValue("GLOBAL");
                    if (global == null) break block41;
                    IAgentQueue iaq4 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                    boolean existingGlobalFlag = iaq4.isGlobal();
                    boolean newGlobalFlag = global;
                    if (newGlobalFlag == existingGlobalFlag) break block41;
                    iaq4.setGlobal(newGlobalFlag);
                    if (this.m_queueName.equalsIgnoreCase("SonicMQ.deadMessage") || this.m_queueName.equalsIgnoreCase("SonicMQ.routingQueue") || this.m_queueName.equalsIgnoreCase("SonicMQ.delayedDeliveryQueue")) break block41;
                    if (newGlobalFlag) {
                        AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().onNewGlobal(this.m_queueName);
                        break block41;
                    }
                    AgentRegistrar.getAgentRegistrar().getRouterManager().getRouteForwarder().onRemoveGlobal(Config.ROUTING_NODE_NAME, this.m_queueName);
                }
                catch (NotModifiedAttException global) {}
            } else if (attributeName.equals("READ_EXCLUSIVE")) {
                try {
                    Boolean readExclusive = (Boolean)delta.getNewValue("READ_EXCLUSIVE");
                    if (readExclusive != null) {
                        IAgentQueue iaq5 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                        iaq5.setReadExclusiveMode(readExclusive);
                    }
                }
                catch (NotModifiedAttException readExclusive) {}
            } else if (attributeName.equals("CLUSTERED")) {
                try {
                    Boolean clustered = (Boolean)delta.getNewValue("CLUSTERED");
                    if (clustered != null) {
                        IAgentQueue iaq6 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                        iaq6.setClustered(clustered);
                    }
                }
                catch (NotModifiedAttException clustered) {}
            } else if (attributeName.equals("MAX_WAIT_TIME")) {
                IAgentQueue iaq7 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                IMessageGroupHandle mh2 = iaq7.getMessageGroupHandle();
                if (mh2 != null && mh2.isMessageGroupEnabled()) {
                    Integer maxWaitTime = null;
                    try {
                        maxWaitTime = (Integer)delta.getNewValue("MAX_WAIT_TIME");
                    }
                    catch (NotModifiedAttException notModifiedAttException) {
                        // empty catch block
                    }
                    if (maxWaitTime != null && maxWaitTime >= 0) {
                        mh2.setMessageGroupMaxWaitTimeInSeconds(maxWaitTime);
                    }
                }
            } else if (attributeName.equals("MIN_CONSUMERS")) {
                IAgentQueue iaq8 = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName);
                IMessageGroupHandle mh3 = iaq8.getMessageGroupHandle();
                if (mh3 != null && mh3.isMessageGroupEnabled()) {
                    Integer minConsumers = null;
                    try {
                        minConsumers = (Integer)delta.getNewValue("MIN_CONSUMERS");
                    }
                    catch (NotModifiedAttException notModifiedAttException) {
                        // empty catch block
                    }
                    if (minConsumers != null && minConsumers > 0) {
                        mh3.setMessageGroupMinReceivers(minConsumers);
                    }
                }
            } else if (attributeName.equals("GROUP_IDLE_TIMEOUT") && (mh = (iaq = AgentRegistrar.getAgentRegistrar().getQueueProc().getAgentQueue(this.m_queueName)).getMessageGroupHandle()) != null && mh.isMessageGroupEnabled()) {
                Integer idleTimeout = null;
                try {
                    idleTimeout = (Integer)delta.getNewValue("GROUP_IDLE_TIMEOUT");
                }
                catch (NotModifiedAttException notModifiedAttException) {
                    // empty catch block
                }
                if (idleTimeout != null) {
                    mh.setMessageGroupIdleTimeoutInSeconds(idleTimeout * 60);
                }
            }
        }
    }
}

