/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.protocol;

import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.IElement;
import java.util.Calendar;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Duration;

public class Expires
implements IElement {
    private Constants RMConstants;
    private long expires = Long.MAX_VALUE;
    private MessageElement expiresElement;

    public Expires(Constants constants) {
        this.RMConstants = constants;
        this.expiresElement = new MessageElement(this.RMConstants.getNSURI(), "Expires");
    }

    public Expires(long nr) {
        this.expiresElement = new MessageElement(this.RMConstants.getNSURI(), "Expires");
        this.setExpires(nr);
    }

    public Expires(MessageElement element) {
        this.expiresElement = element;
        Duration dur = new Duration(element.getValue());
        if (dur.getYears() == 0 && dur.getMonths() == 0 && dur.getDays() == 0 && dur.getHours() == 0 && dur.getMinutes() == 0 && dur.getSeconds() == 0.0) {
            this.expires = Long.MAX_VALUE;
            return;
        }
        if (dur.isNegative()) {
            this.expires = 0L;
            return;
        }
        Calendar rightNow = Calendar.getInstance();
        long rightNowInMillis = rightNow.getTime().getTime();
        rightNow.add(1, dur.getYears());
        rightNow.add(2, dur.getMonths());
        rightNow.add(5, dur.getDays());
        rightNow.add(10, dur.getHours());
        rightNow.add(12, dur.getMinutes());
        rightNow.add(13, new Double(dur.getSeconds()).intValue());
        this.expires = rightNow.getTime().getTime() - rightNowInMillis;
    }

    public long getExpires() {
        if (this.expires == 0L) {
            return Long.MAX_VALUE;
        }
        return this.expires;
    }

    @Override
    public MessageElement getSoapElement() throws SOAPException {
        String val = "PT0S";
        if (this.expires == Long.MAX_VALUE || this.expires == 0L) {
            this.expiresElement.addTextNode(val);
            return this.expiresElement;
        }
        boolean negative = false;
        long Iexpires = this.expires;
        if (this.expires < 0L) {
            negative = true;
            Iexpires = -this.expires;
        }
        if (Iexpires > 0L) {
            Duration dur = new Duration();
            long secs = (Iexpires + 999L) / 1000L;
            dur.setDays((int)(secs / 86400L));
            long secsrem = secs % 86400L;
            dur.setHours((int)(secsrem / 3600L));
            dur.setMinutes((int)((secsrem %= 3600L) / 60L));
            dur.setSeconds((double)(secsrem %= 60L));
            dur.setNegative(negative);
            val = dur.toString();
        }
        this.expiresElement.addTextNode(val);
        return this.expiresElement;
    }

    public MessageElement toSOAPEnvelope(MessageElement msgElement) throws SOAPException {
        msgElement.addChild(this.getSoapElement());
        return msgElement;
    }

    public final void setExpires(long expiry) {
        this.expires = expiry;
    }

    @Override
    public void addChildElement(MessageElement element) {
    }
}

