/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy;

import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.ws.security.policy.model.SonicPolicyEngineData;
import com.sonicsw.ws.security.policy.parser.processors.AsymmetricBindingProcessor;
import com.sonicsw.ws.security.policy.parser.processors.RequiredElementsProcessor;
import com.sonicsw.ws.security.policy.parser.processors.SecureConversationTokenProcessor;
import com.sonicsw.ws.security.policy.parser.processors.SymmetricBindingProcessor;
import com.sonicsw.ws.security.policy.parser.processors.TransportBindingProcessor;
import com.sonicsw.ws.security.policy.parser.processors.Trust10Processor;
import com.sonicsw.wsp.WSPUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.EncryptedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.EndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedEndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedPartsElementsProcessor;
import org.apache.ws.security.policy.parser.processors.SignedSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.UsernameTokenProcessor;
import org.apache.ws.security.policy.parser.processors.Wss10Processor;
import org.apache.ws.security.policy.parser.processors.Wss11Processor;
import progress.message.util.DebugState;

public class SecurityPolicyProcessor {
    private static final String KEYSTORE_ENTRY = "KeyStoreEntry";
    private static final String ISSUER_SERIAL = "X509IssuerSerial";
    SecurityPolicyToken topLevel = new SecurityPolicyToken("_TopLevel_", 1, null);
    SecurityProcessorContext secProcessorContext = null;

    public boolean setup() throws NoSuchMethodException {
        SecurityPolicyToken spt = null;
        SignedPartsElementsProcessor spep = new SignedPartsElementsProcessor();
        spt = SecurityPolicy.signedParts.copy();
        spt.setProcessTokenMethod((Object)spep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedElements.copy();
        spt.setProcessTokenMethod((Object)spep);
        this.topLevel.setChildToken(spt);
        EncryptedPartsElementsProcessor epep = new EncryptedPartsElementsProcessor();
        spt = SecurityPolicy.encryptedParts.copy();
        spt.setProcessTokenMethod((Object)epep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.encryptedElements.copy();
        spt.setProcessTokenMethod((Object)epep);
        this.topLevel.setChildToken(spt);
        RequiredElementsProcessor rep = new RequiredElementsProcessor();
        spt = SecurityPolicy.requiredElements.copy();
        spt.setProcessTokenMethod((Object)rep);
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.asymmetricBinding.copy();
        spt.setProcessTokenMethod((Object)new AsymmetricBindingProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.symmetricBinding.copy();
        spt.setProcessTokenMethod((Object)new SymmetricBindingProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.wss10.copy();
        spt.setProcessTokenMethod((Object)new Wss10Processor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.wss11.copy();
        spt.setProcessTokenMethod((Object)new Wss11Processor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.supportingTokens.copy();
        spt.setProcessTokenMethod((Object)new SupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedSupportingTokens.copy();
        spt.setProcessTokenMethod((Object)new SignedSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.endorsingSupportingTokens.copy();
        spt.setProcessTokenMethod((Object)new EndorsingSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.signedEndorsingSupportingTokens.copy();
        spt.setProcessTokenMethod((Object)new SignedEndorsingSupportingTokensProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.transportBinding.copy();
        spt.setProcessTokenMethod((Object)new TransportBindingProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.usernameToken.copy();
        spt.setProcessTokenMethod((Object)new UsernameTokenProcessor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.trust10.copy();
        spt.setProcessTokenMethod((Object)new Trust10Processor());
        this.topLevel.setChildToken(spt);
        spt = SecurityPolicy.secureConversationToken.copy();
        spt.setProcessTokenMethod((Object)new SecureConversationTokenProcessor());
        this.topLevel.setChildToken(spt);
        SonicPolicyEngineData ped = new SonicPolicyEngineData();
        ped.initializeWithDefaults();
        this.secProcessorContext = new SecurityProcessorContext();
        this.secProcessorContext.pushSecurityToken(this.topLevel);
        this.secProcessorContext.pushPolicyEngineData((PolicyEngineData)ped);
        return true;
    }

    public boolean processPolicy(Policy policy) {
        if (!policy.isNormalized()) {
            throw new RuntimeException("Policy is not in normalized format");
        }
        XorCompositeAssertion xor = (XorCompositeAssertion)policy.getTerms().get(0);
        List listOfPolicyAlternatives = xor.getTerms();
        boolean success = false;
        int numberOfAlternatives = listOfPolicyAlternatives.size();
        for (int i = 0; !success && i < numberOfAlternatives; ++i) {
            AndCompositeAssertion aPolicyAlternative = (AndCompositeAssertion)listOfPolicyAlternatives.get(i);
            List listOfAssertions = aPolicyAlternative.getTerms();
            Iterator iterator = listOfAssertions.iterator();
            boolean all = true;
            while (all && iterator.hasNext()) {
                Assertion assertion = (Assertion)iterator.next();
                if (!(assertion instanceof PrimitiveAssertion)) {
                    DebugObjects.getPolicyDebug().debug("SecurityPolicyProcessor got a unexpected assertion type: " + assertion.getClass().getName());
                    continue;
                }
                PrimitiveAssertion pa = (PrimitiveAssertion)assertion;
                if (!("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(pa.getName().getNamespaceURI()) || KEYSTORE_ENTRY.equals(pa.getName().getLocalPart()) || ISSUER_SERIAL.equals(pa.getName().getLocalPart()))) {
                    DebugObjects.getPolicyDebug().debug("SecurityPolicyProcessor skipping non SP 2005 assertion: " + pa.getName().getLocalPart());
                    continue;
                }
                all = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
            success = all;
        }
        return success;
    }

    boolean processPrimitiveAssertion(PrimitiveAssertion pa) {
        boolean commit = true;
        commit = this.startPolicyTransaction(pa);
        List terms = pa.getTerms();
        if (commit && !terms.isEmpty()) {
            for (int i = 0; commit && i < terms.size(); ++i) {
                Assertion assertion = (Assertion)pa.getTerms().get(i);
                if (assertion instanceof Policy) {
                    commit = this.processPolicy((Policy)assertion);
                    continue;
                }
                if (!(assertion instanceof PrimitiveAssertion)) continue;
                commit = this.processPrimitiveAssertion((PrimitiveAssertion)assertion);
            }
        }
        if (commit) {
            this.commitPolicyTransaction(pa);
        } else {
            this.abortPolicyTransaction(pa);
        }
        return commit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startPolicyTransaction(PrimitiveAssertion pa) {
        String tokenName = pa.getName().getLocalPart();
        SecurityPolicyToken spt = null;
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            DebugObjects.getPolicyDebug().debug("Internal error on token stack - No current token");
            throw new RuntimeException("Internal error on token stack - No current token");
        }
        spt = currentToken.getChildToken(tokenName);
        this.secProcessorContext.pushSecurityToken(spt);
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(1);
        boolean ret = false;
        if (spt == null) {
            DebugObjects.getPolicyDebug().debug("Security token: '" + tokenName + "' unknown in context of '" + currentToken.getTokenName());
            return false;
        }
        try {
            if (spt.getTokenType() == 1 && this.secProcessorContext.getAction() == 1) {
                this.secProcessorContext.pushPolicyEngineData(SonicPolicyEngineData.copy(pa.getName()));
            }
            ret = spt.invokeProcessTokenMethod(this.secProcessorContext);
        }
        catch (Exception ex) {
            DebugObjects.getPolicyDebug().debug("Exception occured when invoking processTokenMethod: " + ex, ex);
        }
        finally {
            this.secProcessorContext.setAction(0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortPolicyTransaction(PrimitiveAssertion pa) {
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            this.secProcessorContext.popSecurityToken();
            DebugObjects.getPolicyDebug().debug("Abort transaction because of unknown token: '" + pa.getName().getLocalPart() + "'");
            return;
        }
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(3);
        try {
            currentToken.invokeProcessTokenMethod(this.secProcessorContext);
        }
        catch (Exception ex) {
            DebugObjects.getPolicyDebug().debug("Exception occured when invoking processTokenMethod: " + ex, ex);
        }
        finally {
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
            if (currentToken.getTokenType() == 1) {
                this.secProcessorContext.popPolicyEngineData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPolicyTransaction(PrimitiveAssertion pa) {
        SecurityPolicyToken currentToken = this.secProcessorContext.readCurrentSecurityToken();
        if (currentToken == null) {
            String err = "Internal error on token stack - Commiting an unknown token: " + pa.getName().getLocalPart() + "'";
            DebugObjects.getPolicyDebug().debug(err);
            throw new RuntimeException(err);
        }
        this.secProcessorContext.setAssertion(pa);
        this.secProcessorContext.setAction(2);
        try {
            currentToken.invokeProcessTokenMethod(this.secProcessorContext);
        }
        catch (Exception ex) {
            DebugObjects.getPolicyDebug().debug("Exception occured when invoking processTokenMethod: " + ex, ex);
        }
        finally {
            this.secProcessorContext.setAction(0);
            this.secProcessorContext.popSecurityToken();
            if (currentToken.getTokenType() == 1) {
                this.secProcessorContext.commitPolicyEngineData();
            }
        }
    }

    public static void main(String[] args) {
        Policy merged = null;
        FileInputStream fis = null;
        DebugState.parse("WebServicesPolicy;WebServicesSecureConversation");
        SecurityPolicyProcessor spp = new SecurityPolicyProcessor();
        try {
            spp.setup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 0; i < args.length; ++i) {
            try {
                fis = new FileInputStream(args[i]);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int chr = 0;
                while ((chr = fis.read()) != -1) {
                    bos.write(chr);
                }
                byte[] data = bos.toByteArray();
                String datastr = new String(data);
                System.out.println("Original XML File:\n" + datastr);
                Policy newPolicy = WSPUtils.getPolicy(datastr);
                newPolicy = (Policy)newPolicy.normalize();
                fis.close();
                if (merged == null) {
                    merged = newPolicy;
                    continue;
                }
                merged = (Policy)merged.merge((Assertion)newPolicy);
                continue;
            }
            catch (Exception e) {
                System.out.println("Unable to process policy " + args[i]);
                e.printStackTrace();
            }
        }
        if (spp.processPolicy(merged)) {
            System.out.println("Security Policy sucessfully parsed");
        } else {
            System.out.println("Security Policy not sucessfully parsed");
        }
        try {
            SecurityPolicyAlternative[] i = WSSPUtils.getPolicyAlternatives(merged);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

