/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.security.Principal;
import java.util.Iterator;
import progress.message.broker.BrokerSearchResults;
import progress.message.broker.SubjectAclEntry;
import progress.message.security.EUnknownPermission;
import progress.message.util.EAssertFailure;
import progress.message.zclient.FastVector;
import progress.message.zclient.Group;
import progress.message.zclient.ISubject;
import progress.message.zclient.SubjectSpace;
import progress.message.zclient.SubjectUtil;

public final class Authorize {
    private static final String NEG = ", neg: ";
    private static volatile SubjectSpace m_table;

    static final void setSubjectSpace(SubjectSpace table) {
        m_table = table;
    }

    public static boolean checkPermission(Principal user, ISubject subject, int operation) {
        if (Authorize.checkInputParameters(user, subject)) {
            return true;
        }
        Authorize.logInputParameters(user, subject, operation);
        if (subject.isTemporary() && (operation == 1 || operation == 2)) {
            return true;
        }
        return !Authorize.checkSubjects(user, subject, operation);
    }

    private static boolean checkSubjects(Principal user, ISubject subject, int operation) {
        BrokerSearchResults results = new BrokerSearchResults();
        Iterator<ISubject> subjects = subject.getSingleSubjects();
        while (subjects.hasNext()) {
            m_table.get(subjects.next(), results);
            boolean groupPermsFound = false;
            int userIndex = -1;
            SubjectAclEntry merge = null;
            for (int i = Authorize.getAclCount(results) - 1; i >= 0; --i) {
                SubjectAclEntry entry = Authorize.getAclEntry(results.m_userAcls, i);
                if (!user.equals(entry.getPrincipal())) continue;
                Authorize.logAclUserEntry(entry);
                if (entry.includesGroupPerms()) {
                    groupPermsFound = true;
                    if (Authorize.checkEntryPermission(operation, entry)) break;
                    return true;
                }
                userIndex = i;
                merge = entry.copyForPrincipal(user);
            }
            if (groupPermsFound) continue;
            if ((merge = Authorize.updateMergeSubjectAclEntry(user, results, merge)) == null) {
                return true;
            }
            merge.setIncludesGroupPerms(true);
            Authorize.updateResults(results, merge, userIndex);
            if (Authorize.checkPermission(operation, merge)) continue;
            return true;
        }
        return false;
    }

    private static SubjectAclEntry updateMergeSubjectAclEntry(Principal user, BrokerSearchResults results, SubjectAclEntry mergeParameter) {
        int count = Authorize.getGroupAclCount(results);
        SubjectAclEntry merge = mergeParameter;
        for (int i = count - 1; i >= 0; --i) {
            SubjectAclEntry entry = Authorize.getAclEntry(results.m_groupAcls, i);
            if (!((Group)((Object)entry.getPrincipal())).isMember(user)) continue;
            if (merge == null) {
                merge = entry.copyPosPermissions(user);
                continue;
            }
            try {
                merge.addPosPermissions(entry.getPosPermissions());
                continue;
            }
            catch (EUnknownPermission e) {
                throw new EAssertFailure("Invalid positive permissions: " + entry.getPosPermissions(), e);
            }
        }
        return merge;
    }

    private static boolean checkEntryPermission(int operation, SubjectAclEntry entry) {
        boolean result;
        try {
            result = entry.checkPermission((byte)operation);
        }
        catch (EUnknownPermission e) {
            throw new EAssertFailure("Unknown permission: " + operation, e);
        }
        return result;
    }

    private static void logAclUserEntry(SubjectAclEntry entry) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubjectAclEntry getAclEntry(FastVector acls, int index) {
        FastVector fastVector = acls;
        synchronized (fastVector) {
            return (SubjectAclEntry)acls.m_data[index];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getGroupAclCount(BrokerSearchResults results) {
        FastVector fastVector = results.m_groupAcls;
        synchronized (fastVector) {
            return results.m_groupAcls.m_count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAclCount(BrokerSearchResults results) {
        int count;
        FastVector fastVector = results.m_userAcls;
        synchronized (fastVector) {
            count = results.m_userAcls.m_count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateResults(BrokerSearchResults results, SubjectAclEntry merge, int userIndex) {
        FastVector fastVector = results.m_userAcls;
        synchronized (fastVector) {
            if (userIndex >= 0) {
                results.m_userAcls.m_data[userIndex] = merge;
            } else {
                results.m_userAcls.addElement(merge);
            }
        }
    }

    private static void logInputParameters(Principal user, ISubject subject, int operation) {
    }

    private static boolean checkInputParameters(Principal user, ISubject subject) {
        if (subject == null || !subject.isSubjectSet()) {
            return true;
        }
        if (SubjectUtil.getSubjectGroup(user.getName()) != null) {
            return true;
        }
        return subject.isReply();
    }

    private static boolean checkPermission(int operation, SubjectAclEntry merge) {
        boolean authorized = Authorize.checkEntryPermission(operation, merge);
        return authorized;
    }
}

