/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.IClientContext;
import progress.message.broker.LogEvent;
import progress.message.broker.QueueMsgEvt;

public class LogTrace {
    private static short[] _types = new short[]{180, 1, 2, 112, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 115, 19, 20, 117, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 113, 43, 44, 48, 49, 50, 51, 52, 53, 54, 55, 56, 114, 58, 59, 60, 61, 62, 181, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 118, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 121, 119, 120, 124, 122, 123};
    private static String[] _type_strings = new String[]{"GUAR_MSG_TYPE", "GUAR_MSG_TYPE_V4_0", "MSG_DELIVERED_TYPE", "SUBSCRIBE_TYPE", "UNSUBSCRIBE_ALL_TYPE", "SYNC_BEGIN_TYPE", "SYNC_END_TYPE", "SYNC_GUAR_MSG_TYPE", "QUEUE_MSG_TYPE", "QUEUE_MSG_SAVED_TYPE", "QUEUE_MSG_ACKED_TYPE", "SYNC_QUEUE_MSG_TYPE", "TXN_PRECOMMIT_TYPE", "TXN_COMMIT_TYPE", "TXN_PREPARE_TYPE", "TXN_BEGIN_TYPE", "TXN_ABORT_TYPE", "SYNC_TXN_TYPE", "UNSUBSCRIBE_TYPE", "CONNECT_TYPE", "UNREGISTER_TYPE", "CLIENT_ACK_EVT_TYPE", "IB_GUAR_ACK_DONE_TYPE", "IB_GUAR_ACK_XCHG_TYPE", "QUEUE_MSG_SEND_TYPE", "QUEUE_MSG_MOVE_TYPE", "GR_GUAR_QUEUEACK_DONE_TYPE", "GR_GUAR_QUEUEACK_XCHG_TYPE", "GR_INDOUBT_QREENQUEUE_TYPE", "NO_DUP_COMMIT_BEG_TYPE", "SYNC_TXN_TYPE_V3C1", "GLB_TXN_BEGIN_TYPE", "GLB_TXN_END_TYPE", "GLB_TXN_PREPARE_TYPE", "GLB_TXN_PRECOMMIT_TYPE", "GLB_TXN_COMMIT_TYPE", "GLB_TXN_ABORT_TYPE", "GLB_TXN_SYNC_TYPE", "NO_DUP_COMMIT_BEG_TYPE_V4_0", "CHANNEL_TXN_SYNC_TYPE", "SUBSCRIBE_FOR_SELECTOR_TYPE", "UNFILTERED_TYPE", "UNUSED_TYPE", "GUAR_MSG_TYPE_V5_0", "SYNC_QUEUE_MSG_TYPE_V5_0", "SYNC_TXN_TYPE_V500", "GLB_TXN_SYNC_TYPE_V500", "CHANNEL_TXN_SYNC_TYPE_V500", "TXN_PREPARE_TYPE_V500", "GLB_TXN_PREPARE_TYPE_V500", "TXN_PRECOMMIT_TYPE_V500", "GLB_TXN_PRECOMMIT_TYPE_V500", "GS_SUBSCRIBE_TYPE", "QUEUE_MSG_TYPE_V5_0", "SUBSCRIBE_TYPE_V5_0", "SUBSCRIBE_FOR_SELECTOR_TYPE_V5_0", "DURABLE_DISCONNECT_TYPE", "PROXY_DOUBT_RESOLVED_TYPE", "DELIVERY_LIST_TYPE", "DELIVERY_LIST_TYPEV6_1", "TXN_ABORT_BEGIN_TYPE", "DURABLE_STATS_TYPE", "DELETE_END_TYPE", "SYNC_SUBSCRIPTION_DELETE_TYPE", "CLIENT_ACK_EVT_TYPE_V5_0", "GUAR_MSG_TYPE_V5_0_2", "QUEUE_MSG_TYPE_V5_0_2", "SYNC_QUEUE_MSG_TYPE_V5_0_2", "BATCH_SPLIT_TYPE", "DURABLE_SMO_UPDATE_TYPE", "SYNC_DELETE_MSG_EVT", "QUEUE_MSG_TYPE_V5_1", "QUEUE_MSG_SEND_TYPE_V5_1", "SYNC_QUEUE_MSG_TYPE_V5_1", "QUEUE_MSG_MOVE_TYPE_V5_1", "TEMP_QUEUE_CREATION_EVT", "TEMP_QUEUE_DELETION_EVT", "SYNC_TEMP_QUEUE_EVT", "TXN_PRECOMMIT_TYPE_V6_0", "TXN_COMMIT_TYPE_V6_0", "TXN_PREPARE_TYPE_V6_0", "TXN_BEGIN_TYPE_V6_0", "TXN_ABORT_TYPE_V6_0", "TXN_ABORT_BEGIN_TYPE_V6_0", "NO_DUP_COMMIT_BEG_TYPE_V6_0", "SYNC_TXN_TYPE_V6_0", "CHANNEL_TXN_SYNC_TYPE_V6_0", "GLB_TXN_BEGIN_TYPE_V6_0", "GLB_TXN_END_TYPE_V6_0", "GLB_TXN_JOIN_TYPE_V6_0", "GLB_TXN_SUSPEND_TYPE_V6_0", "GLB_TXN_RESUME_TYPE_V6_0", "GLB_TXN_PREPARE_TYPE_V6_0", "GLB_TXN_PRECOMMIT_TYPE_V6_0", "GLB_TXN_COMMIT_TYPE_V6_0", "GLB_TXN_ABORT_TYPE_V6_0", "GLB_TXN_SYNC_TYPE_V6_0", "REPLY_ACK_TYPE", "COUNTER_TYPE", "SYNC_COUNTER_TYPE", "QUEUE_MSG_ACKED_TYPE_V6_0", "SYNC_RM_INBOUND_EVT", "RM_INBOUND_EVT", "RM_INBOUND_END_EVT", "SYNC_RM_OUTBOUND_EVT", "RM_OUTBOUND_EVT", "RM_OUTBOUND_END_EVT"};
    private static Hashtable _string_to_type_table;
    private static Hashtable _type_table;

    public static short stringToType(String s) {
        Short b = (Short)_string_to_type_table.get(s);
        if (b == null) {
            return -1;
        }
        return b.byteValue();
    }

    public static String typeToString(short b) {
        String s = (String)_type_table.get(new Short(b));
        if (s == null) {
            s = Short.toString(b);
        }
        return s;
    }

    public static void diagnose(LogEvent evt) {
        String s = LogTrace.diagnosticString(evt);
        if (s != null) {
            System.out.println(s);
        }
    }

    public static void diagnose(String pre, LogEvent evt) {
        String s = LogTrace.diagnosticString(evt);
        if (s != null) {
            System.out.println(pre + s);
        }
    }

    public static String diagnosticString(LogEvent evt) {
        return evt.toString();
    }

    public static boolean isTransacted(LogEvent evt) {
        if (evt.type() == 75) {
            QueueMsgEvt qme = (QueueMsgEvt)evt;
            return qme.isTransacted();
        }
        if (evt.type() == 69) {
            GuarMsgEvt gme = (GuarMsgEvt)evt;
            return gme.isTransacted();
        }
        return false;
    }

    public static String getAppid(LogEvent evt) {
        try {
            long cid = evt.getClientID();
            IClientContext icc = AgentRegistrar.getAgentRegistrar().getClient(cid);
            return icc.getAppid();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        _type_table = new Hashtable();
        _string_to_type_table = new Hashtable();
        for (int i = 0; i < _types.length; ++i) {
            Short b = new Short(_types[i]);
            _type_table.put(b, _type_strings[i]);
            _string_to_type_table.put(_type_strings[i], b);
        }
    }
}

