/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

public class ProxyDoubtResolvedEvt
extends LogEvent {
    private long m_id;
    private ArrayList m_trackNums = new ArrayList();

    public ProxyDoubtResolvedEvt(long id) {
        this.m_id = id;
    }

    ProxyDoubtResolvedEvt() {
    }

    public long getId() {
        return this.m_id;
    }

    @Override
    public short type() {
        return 62;
    }

    @Override
    public boolean usesClientRegistry() {
        return true;
    }

    @Override
    public long getClientID() {
        return this.m_id;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 12 + 8 * this.m_trackNums.size();
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
        StreamUtil.writeInt(this.m_trackNums.size(), os);
        Iterator it = this.m_trackNums.iterator();
        while (it.hasNext()) {
            StreamUtil.writeLong((long)((Long)it.next()), os);
        }
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
        int c = StreamUtil.readInt(in);
        for (int i = 0; i < c; ++i) {
            this.m_trackNums.add(new Long(StreamUtil.readLong(in)));
        }
    }

    public void addTracking(long tracking) {
        this.m_trackNums.add(new Long(tracking));
    }

    public Iterator getTrackingNums() {
        return this.m_trackNums.iterator();
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoProxyDoubtResolved(this);
    }

    @Override
    public String toString() {
        return super.toString() + "ProxyDoubtResolvedEvt cid: " + this.m_id;
    }
}

