/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.List;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class QueueMsgGroupUnassignEvt
extends LogEvent {
    private String m_queueName;
    private List<String> m_groupNames = new ArrayList<String>();

    public QueueMsgGroupUnassignEvt() {
        this.setReplicateOnly(true);
    }

    public QueueMsgGroupUnassignEvt(String queueName) {
        this.m_queueName = queueName;
        this.setReplicateOnly(true);
    }

    public QueueMsgGroupUnassignEvt(String queueName, String groupName) {
        this(queueName);
        this.addGroupName(groupName);
    }

    public final void addGroupName(String groupName) {
        this.m_groupNames.add(groupName);
    }

    @Override
    public short type() {
        return 188;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoQueueMsgGroupUnassign(this.m_queueName, this.m_groupNames);
    }

    @Override
    protected int memSizeBody() {
        int size = this.m_queueName.length() << 1;
        for (String groupName : this.m_groupNames) {
            size += groupName.length() << 1;
        }
        return size;
    }

    @Override
    protected int serializedSizeBody() {
        return this.streamSizeBody();
    }

    @Override
    protected void writeBodyToLog(OutputStream os, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(os);
    }

    @Override
    protected int streamSizeBody() {
        int size;
        block3: {
            size = 0;
            try {
                size += StringUtil.stringToUTF(this.m_queueName).length;
                size += 4;
                for (String groupName : this.m_groupNames) {
                    size += StringUtil.stringToUTF(groupName).length;
                }
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block3;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return size;
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_queueName = StreamUtil.readUTF(in);
        int numGroups = StreamUtil.readInt(in);
        for (int i = 0; i < numGroups; ++i) {
            this.addGroupName(StreamUtil.readUTF(in));
        }
    }

    private void writeBody(OutputStream out) throws IOException {
        byte[] utfQueueName = StringUtil.stringToUTF(this.m_queueName);
        out.write(utfQueueName, 0, utfQueueName.length);
        StreamUtil.writeInt(this.m_groupNames.size(), out);
        for (String groupName : this.m_groupNames) {
            byte[] utfGroupName = StringUtil.stringToUTF(groupName);
            out.write(utfGroupName, 0, utfGroupName.length);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(this.m_queueName);
        sb.append(" groups[").append(this.m_groupNames.size()).append("]:");
        for (String groupName : this.m_groupNames) {
            sb.append(" \"").append(groupName).append('\"');
        }
        return sb.toString();
    }
}

