/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Objects;
import progress.message.broker.BrokerSearchResults;
import progress.message.security.EPermissionConflict;
import progress.message.security.EUnknownPermission;
import progress.message.zclient.FastVector;
import progress.message.zclient.Group;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.SearchResults;

public final class SubjectAclEntry
implements ISubjectMatchObject,
Serializable {
    Principal m_principal;
    byte m_posPerms;
    byte m_negPerms;
    boolean m_isGroup;
    boolean m_includesGroupPerms;
    private static final byte NoPosPerms = 0;
    private static final byte NoNegPerms = -1;
    private static final int NumPermissions = 4;
    public static final byte PosPublishPermission = 1;
    public static final byte PosSendPermission = 1;
    public static final byte PosSubscribePermission = 2;
    public static final byte PosReceivePermission = 2;
    public static final byte PosGuaranteedPermission = 4;
    public static final byte PosBrowsePermission = 8;
    public static final byte NegPublishPermission = -2;
    public static final byte NegSendPermission = -2;
    public static final byte NegSubscribePermission = -3;
    public static final byte NegReceivePermission = -3;
    public static final byte NegGuaranteedPermission = -5;
    public static final byte NegBrowsePermission = -9;
    public static final byte UnusedPosPermissions = -16;
    public static final byte UnusedNegPermissions = 15;

    public SubjectAclEntry(Principal principal) {
        this.m_principal = principal;
        this.m_posPerms = 0;
        this.m_negPerms = (byte)-1;
        this.m_isGroup = principal instanceof Group;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public boolean includesGroupPerms() {
        return this.m_includesGroupPerms;
    }

    public void setIncludesGroupPerms(boolean inc) {
        this.m_includesGroupPerms = inc;
    }

    public synchronized void addPermission(byte perm) throws EUnknownPermission, EPermissionConflict {
        this.addPermission(perm, false);
    }

    public synchronized void addPermission(byte perm, boolean merge) throws EUnknownPermission, EPermissionConflict {
        if (SubjectAclEntry.invalidPermission(perm)) {
            throw new EUnknownPermission();
        }
        if ((perm & 0xFFFFFFF0) == 0) {
            byte newPerm = (byte)(perm | this.m_posPerms);
            if (merge) {
                this.m_negPerms = (byte)(this.m_negPerms | newPerm);
                this.m_posPerms = newPerm;
            } else {
                if ((newPerm & ~this.m_negPerms) != 0) {
                    throw new EPermissionConflict(SubjectAclEntry.permissionString(perm));
                }
                this.m_posPerms = newPerm;
            }
        } else {
            byte newPerm = (byte)(perm & this.m_negPerms);
            if (merge) {
                this.m_posPerms = (byte)(this.m_posPerms & newPerm);
                this.m_negPerms = newPerm;
            } else {
                if ((this.m_posPerms & ~newPerm) != 0) {
                    throw new EPermissionConflict(SubjectAclEntry.permissionString(perm));
                }
                this.m_negPerms = newPerm;
            }
        }
    }

    public synchronized void removePermission(byte perm) throws EUnknownPermission, EPermissionConflict {
        if (SubjectAclEntry.invalidPermission(perm)) {
            throw new EUnknownPermission();
        }
        if ((perm & 0xFFFFFFF0) == 0) {
            byte newPerm = (byte)(~perm & this.m_posPerms);
            if ((newPerm & ~this.m_negPerms) != 0) {
                throw new EPermissionConflict(SubjectAclEntry.permissionString(perm));
            }
            this.m_posPerms = newPerm;
        } else {
            byte newPerm = (byte)(~perm | this.m_negPerms);
            if ((this.m_posPerms & ~newPerm) != 0) {
                throw new EPermissionConflict(SubjectAclEntry.permissionString(perm));
            }
            this.m_negPerms = newPerm;
        }
    }

    public synchronized void addPosPermissions(byte perms) throws EUnknownPermission {
        if ((perms & 0xFFFFFFF0) != 0) {
            throw new EUnknownPermission();
        }
        this.m_posPerms = (byte)(this.m_posPerms | perms);
    }

    public boolean checkPermission(byte perm) throws EUnknownPermission {
        if (SubjectAclEntry.invalidPermission(perm) || (perm & 0xFFFFFFF0) != 0) {
            throw new EUnknownPermission();
        }
        if ((perm & ~this.m_negPerms) != 0) {
            return false;
        }
        return (perm & this.m_posPerms) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void prefixMatch(ISubject subject, SearchResults result) {
        BrokerSearchResults parent = (BrokerSearchResults)result.getSearchParent();
        if (parent != null) {
            this.prefixMatch(subject, parent);
        }
        BrokerSearchResults set = (BrokerSearchResults)result;
        FastVector v = this.m_isGroup ? set.m_groupAcls : set.m_userAcls;
        SubjectAclEntry entry = this.findPrincipalEntry(v);
        if (entry != null) {
            this.updateAclEntry(entry);
        } else {
            FastVector fastVector = v;
            synchronized (fastVector) {
                v.addElement(this.copy());
            }
        }
    }

    @Override
    public final boolean localEffect() {
        return false;
    }

    public SubjectAclEntry copyForPrincipal(Principal principal) {
        SubjectAclEntry newEntry = this.copy();
        newEntry.m_principal = principal;
        newEntry.m_isGroup = principal instanceof Group;
        return newEntry;
    }

    public SubjectAclEntry copyPosPermissions(Principal principal) {
        SubjectAclEntry newEntry = new SubjectAclEntry(this.m_principal);
        newEntry.m_posPerms = this.m_posPerms;
        newEntry.m_principal = principal;
        newEntry.m_isGroup = principal instanceof Group;
        return newEntry;
    }

    private static final boolean invalidPermission(byte permParam) {
        byte perm = permParam;
        if ((perm & 0xFFFFFFF0) != 0 && (perm | 0xF) != -1) {
            return true;
        }
        if ((perm & 0xFFFFFFF0) != 0) {
            perm = ~perm;
        }
        boolean set = false;
        for (int i = 0; i < 4; ++i) {
            if ((perm & 1) != 0) {
                if (set) {
                    return true;
                }
                set = true;
            }
            perm = (byte)(perm >> 1);
        }
        return !set;
    }

    private static final String permissionString(byte perm) {
        switch (perm) {
            case 1: {
                return "Publish";
            }
            case 2: {
                return "Subscribe";
            }
            case 4: {
                return "Guaranteed";
            }
            case -2: {
                return "Negative Publish";
            }
            case -3: {
                return "Negative Subscribe";
            }
            case -5: {
                return "Negative Guaranteed";
            }
        }
        return "Unknown permission";
    }

    private SubjectAclEntry findPrincipalEntry(FastVector aclList) {
        for (int i = 0; i < aclList.m_count; ++i) {
            SubjectAclEntry entry = (SubjectAclEntry)aclList.m_data[i];
            if (!this.m_principal.equals(entry.m_principal)) continue;
            return entry;
        }
        return null;
    }

    private SubjectAclEntry copy() {
        SubjectAclEntry copyEntry = new SubjectAclEntry(this.m_principal);
        copyEntry.m_isGroup = this.m_isGroup;
        copyEntry.m_posPerms = this.m_posPerms;
        copyEntry.m_negPerms = this.m_negPerms;
        return copyEntry;
    }

    private void updateAclEntry(SubjectAclEntry entry) {
        byte newPosPerms = (byte)(this.m_posPerms | entry.m_posPerms);
        entry.m_posPerms = newPosPerms = (byte)(newPosPerms & this.m_negPerms);
        byte newNegPerms = (byte)(entry.m_negPerms & this.m_negPerms);
        entry.m_negPerms = newNegPerms = (byte)(newNegPerms | this.m_posPerms);
    }

    public void setPermissions(byte pos, byte neg) {
        this.m_posPerms = pos;
        this.m_negPerms = neg;
    }

    public byte getPosPermissions() {
        return this.m_posPerms;
    }

    public byte getNegPermissions() {
        return this.m_negPerms;
    }

    public synchronized void setPermissions(String permString) throws EUnknownPermission {
        int posPerms = 0;
        int negPerms = -1;
        boolean neg = false;
        block6: for (int p = 0; p < permString.length(); ++p) {
            switch (permString.charAt(p)) {
                case '-': {
                    if (!neg) {
                        neg = true;
                        continue block6;
                    }
                    throw new EUnknownPermission(permString);
                }
                case 'S': 
                case 'p': {
                    if (neg) {
                        negPerms = (byte)(negPerms & 0xFFFFFFFE);
                    } else {
                        posPerms = (byte)(posPerms | 1);
                    }
                    neg = false;
                    continue block6;
                }
                case 'R': 
                case 's': {
                    if (neg) {
                        negPerms = (byte)(negPerms & 0xFFFFFFFD);
                    } else {
                        posPerms = (byte)(posPerms | 2);
                    }
                    neg = false;
                    continue block6;
                }
                case 'g': {
                    if (neg) {
                        negPerms = (byte)(negPerms & 0xFFFFFFFB);
                    } else {
                        posPerms = (byte)(posPerms | 4);
                    }
                    neg = false;
                    continue block6;
                }
                default: {
                    throw new EUnknownPermission(permString);
                }
            }
        }
        if (neg || (posPerms & ~negPerms) != 0) {
            throw new EUnknownPermission(permString);
        }
        this.m_posPerms = (byte)posPerms;
        this.m_negPerms = (byte)negPerms;
    }

    public String getPermissionString() {
        String permString = "";
        if ((this.m_posPerms & 1) != 0) {
            permString = permString + "p";
        } else if (~(this.m_negPerms | 0xFFFFFFFE) != 0) {
            permString = permString + "-p";
        }
        if ((this.m_posPerms & 2) != 0) {
            permString = permString + "s";
        } else if (~(this.m_negPerms | 0xFFFFFFFD) != 0) {
            permString = permString + "-s";
        }
        if ((this.m_posPerms & 4) != 0) {
            permString = permString + "g";
        } else if (~(this.m_negPerms | 0xFFFFFFFB) != 0) {
            permString = permString + "-g";
        }
        return permString;
    }

    public String getQueuePermissionString() {
        String permString = "";
        if ((this.m_posPerms & 1) != 0) {
            permString = permString + "S";
        } else if (~(this.m_negPerms | 0xFFFFFFFE) != 0) {
            permString = permString + "-S";
        }
        if ((this.m_posPerms & 2) != 0) {
            permString = permString + "R";
        } else if (~(this.m_negPerms | 0xFFFFFFFD) != 0) {
            permString = permString + "-R";
        }
        return permString;
    }

    public boolean equals(Object obj) {
        return obj instanceof SubjectAclEntry && ((SubjectAclEntry)obj).getPrincipal().equals(this.m_principal);
    }

    public int hashCode() {
        return Objects.hash(this.m_principal);
    }

    public void serialize(DataOutput dos) throws IOException {
        dos.writeInt(((ProgressPrincipal)this.m_principal).getStreamHandle());
        dos.writeByte(this.m_posPerms);
        dos.writeByte(this.m_negPerms);
        dos.writeBoolean(this.m_isGroup);
        dos.writeBoolean(this.m_includesGroupPerms);
    }

    public static SubjectAclEntry unserialize(DataInput dis, ProgressPrincipal[] streamHandles) throws IOException {
        SubjectAclEntry subaclentry = new SubjectAclEntry(streamHandles[dis.readInt()]);
        subaclentry.setPermissions(dis.readByte(), dis.readByte());
        subaclentry.m_isGroup = dis.readBoolean();
        subaclentry.setIncludesGroupPerms(dis.readBoolean());
        return subaclentry;
    }

    @Override
    public boolean isBatchable() {
        return false;
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }

    public boolean isEmpty() {
        return this.m_posPerms == 0 && this.m_negPerms == -1;
    }
}

