/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import progress.message.broker.durable.DurableInfoDelegator;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.msg.MgramFactory;
import progress.message.util.EAssertFailure;

public class DurableTrimReplyOp
extends DurableInfoDelegator
implements IDurableReplyOperation {
    private boolean m_containsError;
    private int m_errorCode;
    private static final int CURRENT_VERSION = 0;

    public DurableTrimReplyOp(String brokerName) {
        this.setBrokerName(brokerName);
    }

    public DurableTrimReplyOp(IMgram mg) {
        IOperationHandle iopHandle = mg.getOperationHandle();
        if (iopHandle.getOperationType() != 29) {
            throw new EAssertFailure("Invalid Operation type!");
        }
        ObjectInput dinput = mg.getPayloadInputStreamHandle();
        try {
            dinput.readByte();
            this.m_containsError = dinput.readBoolean();
            if (this.m_containsError) {
                this.m_errorCode = dinput.readInt();
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    @Override
    public IMgram getMgram() {
        IMgram mg = MgramFactory.getMgramFactory().buildOperationMgram(29);
        try {
            ObjectOutput doutput = mg.getPayloadOutputStreamHandle();
            doutput.writeByte(0);
            doutput.writeBoolean(this.m_containsError);
            if (this.m_containsError) {
                doutput.writeInt(this.m_errorCode);
            }
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return mg;
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public int getErrorCode() {
        return this.m_errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.m_errorCode = errorCode;
        this.m_containsError = true;
    }
}

