/*
 * Decompiled with CFR 0.152.
 */
package progress.message.client;

import com.sonicsw.security.pass.client.ILogin;
import com.sonicsw.security.pass.client.IPasswordUser;
import java.util.Objects;
import progress.message.client.EInauthenticClient;
import progress.message.client.Username;
import progress.message.client.prAccessor;

public final class Credentials
extends Username {
    private final transient String m_password;
    private transient byte[] m_passwordTransformed;

    public Credentials(String login, String password) throws EInauthenticClient {
        this(login, password, null);
    }

    public Credentials(String login, String password, ILogin loginSPI) throws EInauthenticClient {
        super(login);
        this.m_password = password;
        if (loginSPI != null) {
            loginSPI.setUserName(login);
            loginSPI.setPassword(this.m_password);
            boolean isLoginSuccessful = false;
            try {
                isLoginSuccessful = loginSPI.login();
            }
            catch (Exception ex) {
                throw new EInauthenticClient(-25, "Login SPI" + prAccessor.getString("EXT_AUTH_FAIL") + ex.getLocalizedMessage());
            }
            if (!isLoginSuccessful) {
                throw new EInauthenticClient(-25, "Login SPI" + prAccessor.getString("EXT_AUTH_FAIL"));
            }
            IPasswordUser passwordUser = loginSPI.getCredential();
            if (passwordUser != null && passwordUser.getName() != null && passwordUser.getPassword() != null && passwordUser.getPassword().length != 0) {
                String name = passwordUser.getName();
                this.setName(name);
                this.m_passwordTransformed = passwordUser.getPassword();
            }
        }
    }

    public String getPassword() {
        return this.m_password;
    }

    public byte[] getTransformedPassword() {
        return this.m_passwordTransformed;
    }

    @Override
    public boolean equals(Object o) {
        Credentials c;
        return o instanceof Credentials && (c = (Credentials)o).getName().equals(this.getName()) && c.getPassword().equals(this.m_password);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.m_password);
    }
}

