/*
 * Decompiled with CFR 0.152.
 */
package progress.message.db.pse.util;

import com.odi.Database;
import com.odi.ObjectStoreException;
import com.odi.Session;
import java.util.Vector;
import progress.message.db.EDatabaseException;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.util.OpContext;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.zclient.DebugObject;

public class OpExec
extends DebugObject {
    public OpExec() {
        super(DebugState.GLOBAL_DEBUG_ON ? "OpExec " : null);
    }

    public Object doit(Database psedb, Vector parms) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("doit: *** No op *** Thread " + Thread.currentThread());
        }
        return null;
    }

    public Object exec(OpContext opctx) throws EDatabaseException {
        return this.exec(opctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object exec(OpContext opctx, Vector parms) throws EDatabaseException {
        Session sess;
        Object result = null;
        PSEDbContext dbctx = opctx.m_dbCtx;
        int parmsize = 0;
        if (parms != null) {
            parmsize = parms.size();
        }
        if (this.DEBUG) {
            this.debug("exec: Thread " + Thread.currentThread() + " parmSize= " + parmsize);
        }
        try {
            sess = Session.getCurrent();
            if (sess != null) {
                throw new EAssertFailure("Session is active in current thread " + sess.getName());
            }
        }
        catch (ObjectStoreException ex) {
            dbctx.handlePSEException(ex);
        }
        sess = dbctx.getSession();
        try {
            sess.join();
            boolean hasReadLock = false;
            boolean hasUpdateLock = false;
            try {
                if (opctx.m_opType == 1 && opctx.m_readType == 1) {
                    dbctx.getDbLock().acquireReadLock();
                    hasReadLock = true;
                } else {
                    dbctx.getDbLock().acquireUpdateLock();
                    hasUpdateLock = true;
                }
                result = this.doit(dbctx.getDatabase(), parms);
                if (opctx.m_opType == 2) {
                    dbctx.commit();
                }
            }
            finally {
                if (hasUpdateLock) {
                    dbctx.getDbLock().releaseUpdateLock();
                }
                if (hasReadLock) {
                    dbctx.getDbLock().releaseReadLock();
                }
            }
        }
        catch (ObjectStoreException ex) {
            dbctx.handlePSEException(ex);
        }
        finally {
            sess = Session.getCurrent();
            if (sess != null) {
                sess.leave();
            }
        }
        return result;
    }
}

