/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v25;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import progress.message.msg.IFailoverStatusNotificationHandle;
import progress.message.msg.StreamUtilCounter;
import progress.message.msg.v25.Mgram;
import progress.message.msg.v25.Payload;
import progress.message.util.MemoryUtil;
import progress.message.util.StreamUtil;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.SessionConfig;

final class FailoverStatusNotificationPayload
extends Payload
implements IFailoverStatusNotificationHandle {
    private int m_state;
    private String[] m_urls;
    private String[] m_localURLs;
    private String[] m_standbyURLs;
    private boolean m_isDirty = true;
    private byte[] m_payload = null;
    static final int s_fsnPayloadMemSize = MemoryUtil.estimateBaseSize(FailoverStatusNotificationPayload.class);

    public FailoverStatusNotificationPayload(Mgram m) {
        super(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump() {
        PrintStream log;
        PrintStream printStream = log = SessionConfig.getLog();
        synchronized (printStream) {
            log.println("STATE: " + this.getState());
            for (int i = 0; i < this.m_urls.length; ++i) {
                log.println("REDUNDANT URL: " + this.m_urls[i]);
            }
            for (int j = 0; j < this.m_localURLs.length; ++j) {
                log.println("LOCAL URL: " + this.m_localURLs[j]);
            }
            for (int k = 0; k < this.m_standbyURLs.length; ++k) {
                log.println("STANDBY URL: " + this.m_standbyURLs[k]);
            }
        }
    }

    @Override
    protected boolean isDirty() {
        return this.m_isDirty;
    }

    @Override
    protected int memoryLength() {
        return s_fsnPayloadMemSize;
    }

    @Override
    protected void initPayloadFromStream(InputStream is, StreamUtilCounter sc) throws IOException, EMgramFormatError {
        this.m_state = StreamUtil.readInt(is);
        int arrayCount = StreamUtil.readInt(is);
        if (arrayCount > 0) {
            int local = StreamUtil.readInt(is);
            this.m_localURLs = new String[local];
            try {
                for (int j = 0; j < local; ++j) {
                    this.m_localURLs[j] = StreamUtil.readUTF(is);
                }
            }
            catch (IOException j) {
                // empty catch block
            }
            int standby = StreamUtil.readInt(is);
            this.m_standbyURLs = new String[standby];
            try {
                for (int k = 0; k < standby; ++k) {
                    this.m_standbyURLs[k] = StreamUtil.readUTF(is);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_isDirty = true;
    }

    @Override
    protected byte[] toByteArray() {
        this.sync();
        byte[] result = new byte[this.m_payload.length];
        System.arraycopy(this.m_payload, 0, result, 0, this.m_payload.length);
        return result;
    }

    @Override
    protected void sync() {
        if (!this.m_isDirty) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StreamUtil.writeInt(this.m_state, baos);
            if (this.m_localURLs != null || this.m_standbyURLs != null) {
                StreamUtil.writeInt(2, baos);
                StreamUtil.writeInt(this.m_localURLs.length, baos);
                for (int j = 0; j < this.m_localURLs.length; ++j) {
                    StreamUtil.writeUTF(this.m_localURLs[j], baos);
                }
                StreamUtil.writeInt(this.m_standbyURLs.length, baos);
                for (int k = 0; k < this.m_standbyURLs.length; ++k) {
                    StreamUtil.writeUTF(this.m_standbyURLs[k], baos);
                }
            } else {
                StreamUtil.writeInt(0, baos);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_payload = baos.toByteArray();
        this.m_isDirty = false;
    }

    @Override
    public void writeToStream(OutputStream os) throws IOException {
        this.sync();
        os.write(this.m_payload);
    }

    @Override
    public int length() {
        this.sync();
        return this.m_payload.length;
    }

    @Override
    public void setState(int state) {
        this.m_state = state;
        this.m_isDirty = true;
    }

    @Override
    public int getState() {
        return this.m_state;
    }

    @Override
    public void setRedundantURLs(String[] urls) {
        this.m_urls = urls;
        this.m_isDirty = true;
    }

    @Override
    public String[] getRedundantURLs() {
        return this.m_urls;
    }

    @Override
    public void setLocalURLs(String[] urls) {
        this.m_localURLs = urls;
        this.m_isDirty = true;
    }

    @Override
    public String[] getLocalURLs() {
        return this.m_localURLs;
    }

    @Override
    public void setStandbyURLs(String[] urls) {
        this.m_standbyURLs = urls;
        this.m_isDirty = true;
    }

    @Override
    public String[] getStandbyURLs() {
        return this.m_standbyURLs;
    }

    @Override
    public String summaryString() {
        StringBuffer sb = new StringBuffer();
        sb.append("state=" + this.m_state);
        if (this.m_urls != null && this.m_urls.length > 0) {
            sb.append(",redundants=");
            for (int i = 0; i < this.m_urls.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.m_urls[i]);
            }
        }
        if (this.m_localURLs != null && this.m_localURLs.length > 0) {
            sb.append(",local=");
            for (int j = 0; j < this.m_localURLs.length; ++j) {
                if (j > 0) {
                    sb.append(",");
                }
                sb.append(this.m_localURLs[j]);
            }
        }
        if (this.m_standbyURLs != null && this.m_standbyURLs.length > 0) {
            sb.append(",standby=");
            for (int k = 0; k < this.m_standbyURLs.length; ++k) {
                if (k > 0) {
                    sb.append(",");
                }
                sb.append(this.m_standbyURLs[k]);
            }
        }
        return sb.toString();
    }

    @Override
    public IFailoverStatusNotificationHandle getFailoverStatusNotificationHandle() {
        return this;
    }

    @Override
    public HashMap getPayloadProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("FSN_IS_DIRTY", new Boolean(this.m_isDirty));
        result.put("FSN_PAYLOAD", this.m_payload);
        result.put("FSN_STATE", new Integer(this.m_state));
        result.put("FSN_URLS", this.m_urls);
        return result;
    }

    @Override
    public void setPayloadProperties(HashMap map) {
        this.m_isDirty = (Boolean)map.get("FSN_IS_DIRTY");
        this.m_payload = (byte[])map.get("FSN_PAYLOAD");
        this.m_state = (Integer)map.get("FSN_STATE");
        this.m_urls = (String[])map.get("FSN_URLS");
    }
}

