/*
 * Decompiled with CFR 0.152.
 */
package progress.message.resources;

import java.text.MessageFormat;
import progress.message.resources.ParseException;
import progress.message.resources.prFieldPosition;
import progress.message.resources.prFormat;
import progress.message.resources.prParsePosition;
import progress.message.resources.prUtility;

public class prMessageFormat
extends prFormat {
    private String pattern = "";
    private int[] offsets = new int[10];
    private int[] argumentNumbers = new int[10];
    private int maxOffset = -1;

    public prMessageFormat(String pattern) {
        this.applyPattern(pattern);
    }

    public final void applyPattern(String newPattern) {
        StringBuffer[] segments = new StringBuffer[4];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new StringBuffer();
        }
        int part = 0;
        int formatNumber = 0;
        boolean inQuote = false;
        int braceStack = 0;
        block7: for (int i = 0; i < newPattern.length(); ++i) {
            char ch = newPattern.charAt(i);
            if (part == 0) {
                if (ch == '\'') {
                    if (i + 1 < newPattern.length() && newPattern.charAt(i + 1) == '\'') {
                        segments[part].append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    part = 1;
                    continue;
                }
                segments[part].append(ch);
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                if (ch != '\'') continue;
                inQuote = false;
                continue;
            }
            switch (ch) {
                case ',': {
                    if (part < 3) {
                        ++part;
                        continue block7;
                    }
                    segments[part].append(ch);
                    continue block7;
                }
                case '{': {
                    ++braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '}': {
                    if (braceStack == 0) {
                        part = 0;
                        this.makeFormat(i, formatNumber, segments);
                        ++formatNumber;
                        continue block7;
                    }
                    --braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '\'': {
                    inQuote = true;
                    segments[part].append(ch);
                    continue block7;
                }
                default: {
                    segments[part].append(ch);
                }
            }
        }
        this.pattern = segments[0].toString();
    }

    public String toPattern() {
        int lastOffset = 0;
        StringBuffer result = new StringBuffer();
        for (int i = 0; i <= this.maxOffset; ++i) {
            prMessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.offsets[i], result);
            lastOffset = this.offsets[i];
            result.append('{');
            result.append(this.argumentNumbers[i]);
            result.append('}');
        }
        prMessageFormat.copyAndFixQuotes(this.pattern, lastOffset, this.pattern.length(), result);
        return result.toString();
    }

    public final StringBuffer format(Object[] source, StringBuffer result, prFieldPosition ignore) {
        return this.format(source, result, ignore, 0);
    }

    public static String format(String pattern, Object[] arguments) {
        try {
            MessageFormat temp = new MessageFormat(pattern);
            return temp.format(arguments);
        }
        catch (Exception e) {
            return pattern;
        }
    }

    @Override
    public final StringBuffer format(Object source, StringBuffer result, prFieldPosition ignore) {
        return this.format((Object[])source, result, ignore, 0);
    }

    public Object[] parse(String source, prParsePosition status) {
        Object[] resultArray = new Object[10];
        int patternOffset = 0;
        int sourceOffset = status.index;
        prParsePosition tempStatus = new prParsePosition(0);
        for (int i = 0; i <= this.maxOffset; ++i) {
            int len = this.offsets[i] - patternOffset;
            if (len != 0 && !this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
                return null;
            }
            int tempLength = i != this.maxOffset ? this.offsets[i + 1] : this.pattern.length();
            int next = source.indexOf(this.pattern.substring(patternOffset += len, tempLength), sourceOffset += len);
            if (next < 0) {
                return null;
            }
            resultArray[this.argumentNumbers[i]] = source.substring(sourceOffset, next);
            sourceOffset = next;
        }
        int len = this.pattern.length() - patternOffset;
        if (len != 0 && !this.pattern.regionMatches(patternOffset, source, sourceOffset, len)) {
            return null;
        }
        status.index = sourceOffset + len;
        return resultArray;
    }

    public Object[] parse(String source) throws ParseException {
        prParsePosition status = new prParsePosition(0);
        Object[] result = this.parse(source, status);
        if (status.index == 0) {
            throw new ParseException("prMessageFormat parse error!", 0);
        }
        return result;
    }

    @Override
    public Object parseObject(String text, prParsePosition status) {
        return this.parse(text, status);
    }

    @Override
    public Object clone() {
        int i;
        prMessageFormat other = (prMessageFormat)super.clone();
        other.offsets = new int[this.offsets.length];
        for (i = 0; i < this.offsets.length; ++i) {
            other.offsets[i] = this.offsets[i];
        }
        other.argumentNumbers = new int[this.argumentNumbers.length];
        for (i = 0; i < this.argumentNumbers.length; ++i) {
            other.argumentNumbers[i] = this.argumentNumbers[i];
        }
        return other;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        prMessageFormat other = (prMessageFormat)obj;
        return this.maxOffset == other.maxOffset && this.pattern.equals(other.pattern) && prUtility.arrayEquals(this.offsets, (Object)other.offsets) && prUtility.arrayEquals(this.argumentNumbers, (Object)other.argumentNumbers);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private StringBuffer format(Object[] arguments, StringBuffer result, prFieldPosition status, int recursionProtection) {
        int lastOffset = 0;
        for (int i = 0; i <= this.maxOffset; ++i) {
            result.append(this.pattern.substring(lastOffset, this.offsets[i]));
            lastOffset = this.offsets[i];
            int argumentNumber = this.argumentNumbers[i];
            if (argumentNumber >= arguments.length) {
                throw new IllegalArgumentException("Argument # > Arg length");
            }
            try {
                Object obj = arguments[argumentNumber];
                boolean tryRecursion = false;
                if (!(obj instanceof String)) {
                    System.out.println("Unknown object of type:" + obj.getClass().getName());
                    throw new IllegalArgumentException("Unknown argument");
                }
                String arg = (String)obj;
                if (tryRecursion && arg.indexOf(123) >= 0) {
                    prMessageFormat temp = new prMessageFormat(arg);
                    temp.format(arguments, result, status, recursionProtection);
                    continue;
                }
                result.append(arg);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        result.append(this.pattern.substring(lastOffset, this.pattern.length()));
        return result;
    }

    private void makeFormat(int position, int offsetNumber, StringBuffer[] segments) {
        try {
            int argumentNumber = Integer.parseInt(segments[1].toString());
            if (argumentNumber < 0 || argumentNumber > 9) {
                throw new NumberFormatException();
            }
            this.maxOffset = offsetNumber;
            this.offsets[offsetNumber] = segments[0].length();
            this.argumentNumbers[offsetNumber] = argumentNumber;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("argument number too large at ");
        }
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    private static final int findKeyword(String sParam, String[] list) {
        String s = sParam;
        s = s.trim().toLowerCase();
        for (int i = 0; i < list.length; ++i) {
            if (!s.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    private static final void copyAndFixQuotes(String source, int start, int end, StringBuffer target) {
        for (int i = start; i < end; ++i) {
            char ch = source.charAt(i);
            if (ch == '{') {
                target.append("'{'");
                continue;
            }
            if (ch == '\'') {
                target.append("''");
                continue;
            }
            target.append(ch);
        }
    }
}

