/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util;

import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import progress.message.jimpl.Message;
import progress.message.jimpl.Queue;
import progress.message.jimpl.Topic;
import progress.message.util.EPropertyCheckFailed;

public class PropertyChecker {
    public static final boolean checkBooleanProperty(Object property) throws EPropertyCheckFailed {
        if (property == null) {
            return false;
        }
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        if (property instanceof String) {
            return Boolean.valueOf((String)property);
        }
        throw new EPropertyCheckFailed();
    }

    public static final byte checkByteProperty(Object property) throws EPropertyCheckFailed {
        block5: {
            boolean shouldBeNFE = false;
            try {
                if (property == null) {
                    shouldBeNFE = true;
                    throw new NumberFormatException();
                }
                if (property instanceof Byte) {
                    return (Byte)property;
                }
                if (property instanceof String) {
                    return Byte.valueOf((String)property);
                }
            }
            catch (NumberFormatException e) {
                if (!shouldBeNFE) break block5;
                throw new NumberFormatException();
            }
        }
        throw new EPropertyCheckFailed();
    }

    public static final float checkFloatProperty(Object property) throws EPropertyCheckFailed {
        try {
            if (property == null) {
                throw new NullPointerException();
            }
            if (property instanceof Float) {
                return ((Number)property).floatValue();
            }
            if (property instanceof String) {
                return Float.valueOf((String)property).floatValue();
            }
            throw new EPropertyCheckFailed();
        }
        catch (NumberFormatException nfe) {
            throw new EPropertyCheckFailed();
        }
    }

    public static final double checkDoubleProperty(Object property) throws EPropertyCheckFailed {
        try {
            if (property == null) {
                throw new NullPointerException();
            }
            if (property instanceof Double || property instanceof Float) {
                return ((Number)property).doubleValue();
            }
            if (property instanceof String) {
                return Double.valueOf((String)property);
            }
            throw new EPropertyCheckFailed();
        }
        catch (NumberFormatException nfe) {
            throw new EPropertyCheckFailed();
        }
    }

    public static final int checkIntProperty(Object property) throws EPropertyCheckFailed {
        boolean shouldBeNumberFormatException = false;
        try {
            if (property == null) {
                shouldBeNumberFormatException = true;
                throw new NumberFormatException();
            }
            if (property instanceof Integer || property instanceof Short || property instanceof Byte) {
                return ((Number)property).intValue();
            }
            if (property instanceof String) {
                return Integer.valueOf((String)property);
            }
            throw new EPropertyCheckFailed();
        }
        catch (NumberFormatException nfe) {
            if (shouldBeNumberFormatException) {
                throw nfe;
            }
            throw new EPropertyCheckFailed();
        }
    }

    public static final long checkLongProperty(Object property) throws EPropertyCheckFailed {
        boolean shouldBeNumberFormatException = false;
        try {
            if (property == null) {
                shouldBeNumberFormatException = true;
                throw new NumberFormatException();
            }
            if (property instanceof Long || property instanceof Integer || property instanceof Short || property instanceof Byte) {
                return ((Number)property).longValue();
            }
            if (property instanceof String) {
                return Long.valueOf((String)property);
            }
            throw new EPropertyCheckFailed();
        }
        catch (NumberFormatException nfe) {
            if (shouldBeNumberFormatException) {
                throw nfe;
            }
            throw new EPropertyCheckFailed();
        }
    }

    public static final short checkShortProperty(Object property) throws EPropertyCheckFailed {
        boolean shouldBeNumberFormatException = false;
        try {
            if (property == null) {
                shouldBeNumberFormatException = true;
                throw new NumberFormatException();
            }
            if (property instanceof Short || property instanceof Byte) {
                return ((Number)property).shortValue();
            }
            if (property instanceof String) {
                return Short.valueOf((String)property);
            }
            throw new EPropertyCheckFailed();
        }
        catch (NumberFormatException nfe) {
            if (shouldBeNumberFormatException) {
                throw nfe;
            }
            throw new EPropertyCheckFailed();
        }
    }

    public static final String checkStringProperty(Object property) throws EPropertyCheckFailed {
        if (property == null) {
            return null;
        }
        if (property instanceof String) {
            return (String)property;
        }
        if (property instanceof Boolean) {
            return ((Boolean)property).toString();
        }
        if (property instanceof Number) {
            return ((Number)property).toString();
        }
        throw new EPropertyCheckFailed();
    }

    public static final Destination checkDestinationProperty(Object property) throws EPropertyCheckFailed, InvalidDestinationException {
        if (property == null) {
            return null;
        }
        if (property instanceof String) {
            String destStr = (String)property;
            if (Message.getDestinationType(destStr) == 1) {
                return new Queue(destStr.substring("$Q.".length()), true);
            }
            return new Topic(destStr, true);
        }
        throw new EPropertyCheckFailed();
    }
}

