/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.blackbird.evs.nio.nwlink.util;

public final class BufferSizeManager {
    private final int m_quantum;
    private final float m_lambda;
    private final int m_maxSize;
    private final int m_minSize;
    private final int m_growthPolicy;
    private int m_currentSize;
    private int m_weightedAverage;
    public static final int GROWTH_POLICY_AGGRESIVE = 1;
    public static final int GROWTH_POLICY_QUANTUM = 2;

    public BufferSizeManager(int quantum, float lambda, int maxSize, int minSize, int intialSize, int growthPolicy) {
        this.m_quantum = quantum;
        this.m_lambda = lambda;
        this.m_maxSize = maxSize;
        this.m_minSize = minSize < maxSize ? minSize : this.m_maxSize;
        this.m_currentSize = intialSize > this.m_maxSize ? this.m_maxSize : (intialSize < this.m_minSize ? this.m_minSize : intialSize);
        this.m_weightedAverage = this.m_currentSize;
        this.m_growthPolicy = growthPolicy;
    }

    public final void updateDataSize(int dataSize) {
        if (dataSize >= this.m_currentSize) {
            switch (this.m_growthPolicy) {
                case 1: {
                    this.m_weightedAverage = this.m_currentSize = Math.min(dataSize, this.m_maxSize);
                    break;
                }
                case 2: {
                    this.m_weightedAverage = this.m_currentSize = Math.min(this.m_currentSize + this.m_quantum, this.m_maxSize);
                }
            }
            return;
        }
        if (this.m_currentSize > this.m_minSize) {
            if (dataSize < this.m_currentSize - this.m_quantum) {
                this.m_weightedAverage = (int)(this.m_lambda * (float)dataSize + (1.0f - this.m_lambda) * (float)this.m_weightedAverage);
                if (this.m_weightedAverage <= this.m_currentSize - this.m_quantum) {
                    this.m_currentSize = Math.max(this.m_currentSize - this.m_quantum, this.m_minSize);
                }
            } else {
                this.m_weightedAverage = this.m_currentSize;
            }
        }
    }

    public final int getBufferSize() {
        return this.m_currentSize;
    }
}

