/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import java.io.IOException;
import java.text.MessageFormat;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.Config;
import progress.message.broker.RoutingUserAclEntry;
import progress.message.broker.SubjectAclEntry;
import progress.message.broker.prAccessor;
import progress.message.resources.prMessageFormat;
import progress.message.security.EPermissionConflict;
import progress.message.security.EUnknownPermission;
import progress.message.util.DraDestUtil;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.ProgressPrincipal;

public class ACLConfigChangeHelper {
    public static void handleConfigurationChange(IComponentContext context, IElementChange elementChange, String configID, ConfigurationChangeBindHelper bindHelper) {
        if (elementChange.getChangeType() == 0) {
            ACLConfigChangeHelper.handleNewACL(context, elementChange, bindHelper);
        }
    }

    public static void handleNewACL(IComponentContext context, IElementChange elementChange, ConfigurationChangeBindHelper bindHelper) throws EAssertFailure {
        IElement newElement = (IElement)elementChange.getElement();
        IAttributeSet das = newElement.getAttributes();
        if (das != null) {
            String aclType = (String)das.getAttribute("ACL_TYPE");
            String principalName = (String)das.getAttribute("PRINCIPAL_NAME");
            String principalType = (String)das.getAttribute("PRINCIPAL_TYPE");
            String resourceType = (String)das.getAttribute("RESOURCE_TYPE");
            String resourceName = (String)das.getAttribute("RESOURCE_NAME");
            String permission = (String)das.getAttribute("PERMISSION");
            if (resourceType.equalsIgnoreCase("queue") && resourceName.startsWith("$Q.")) {
                throw new EAssertFailure("RESOURCE_NAME " + resourceName + " cannot have prefix " + "$Q.");
            }
            String internalName = DraDestUtil.resourceToSecSubject(resourceType, resourceName);
            if (internalName == null) {
                String s = "RESOURCE_NAME " + resourceName + " with " + "RESOURCE_TYPE" + " " + resourceType + " contains error";
                BrokerComponent.getComponentContext().logMessage(s, 2);
                return;
            }
            resourceName = internalName;
            ProgressPrincipal p = null;
            if (principalType.equalsIgnoreCase("GROUP")) {
                p = AgentRegistrar.getAgentRegistrar().getSecurityBean().getGroup(principalName);
            } else {
                principalName = principalName.replace('.', '$');
                p = AgentRegistrar.getAgentRegistrar().getSecurityBean().getUser(principalName);
            }
            if (p == null) {
                if ((BrokerComponent.getBrokerComponent().getTraceMask() & 0x80) > 0) {
                    Object[] obj = new Object[]{principalName.replace('$', '.')};
                    String s = prMessageFormat.format(prAccessor.getString("STR365"), obj);
                    BrokerComponent.getComponentContext().logMessage(s, 7);
                }
                if (principalType.equalsIgnoreCase("USER")) {
                    p = new ProgressPasswordUser(principalName, "");
                    ((ProgressPasswordUser)p).setInternalPrincipal(false);
                    ((ProgressPasswordUser)p).setCreatedDueToACLEntry(true);
                    ((ProgressPasswordUser)p).setExternalGroups(null);
                    Broker.getBroker().getSecurityCache().addUser((ProgressPasswordUser)p);
                } else if (principalType.equalsIgnoreCase("GROUP")) {
                    p = new ProgressGroup(principalName);
                    p.setInternalPrincipal(false);
                    ((ProgressGroup)p).setCreatedDueToACLEntry(true);
                    Broker.getBroker().getSecurityCache().addGroup((ProgressGroup)p);
                }
            } else if (((ProgressPrincipal)p).isInternalPrincipal() && !((ProgressPrincipal)p).isCreatedDueToACLEntry()) {
                ((ProgressPrincipal)p).setCreatedDueToACLEntry(true);
                if (principalType.equalsIgnoreCase("GROUP")) {
                    Broker.getBroker().getSecurityCache().addGroup((ProgressGroup)p);
                } else {
                    Broker.getBroker().getSecurityCache().addUser((ProgressPasswordUser)p);
                }
            }
            if (aclType.equals("ROUTING_USER_ACL")) {
                if (!Config.ENABLE_ROUTING) {
                    String warning = MessageFormat.format(prAccessor.getString("DRA_NOT_SUPPORTED3"), BrokerLicenseMgr.getLicenseMgr().getProductName());
                    context.logMessage(warning, 2);
                    return;
                }
                RoutingUserAclEntry ruae = new RoutingUserAclEntry(p, resourceName);
                if (permission.equalsIgnoreCase("GRANT")) {
                    ruae.setPosPermission();
                } else if (permission.equalsIgnoreCase("DENY")) {
                    ruae.setNegPermission();
                }
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().setRoutingUserAclEntry(resourceName, ruae);
                }
                catch (IOException ioe) {
                    ACLConfigChangeHelper.traceIOException(ioe);
                }
            } else {
                SubjectAclEntry sae = new SubjectAclEntry(p);
                ACLConfigChangeHelper.setSubjectACLPermissions(sae, aclType, permission);
                if (p == null) {
                    throw new NullPointerException("Principal is null at " + ACLConfigChangeHelper.class.getName() + ".handleNewACL( IComponentContext context, IElementChange elementChange, ConfigurationChangeBindHelper bindHelper )");
                }
                ((ProgressPrincipal)p).addAclSubject(resourceName);
                try {
                    AgentRegistrar.getAgentRegistrar().getSecurityBean().setAclEntry(resourceName, sae);
                    bindHelper.bindACLChangeHandlers(principalName, principalType, resourceName, aclType, das);
                }
                catch (IOException ioe) {
                    ACLConfigChangeHelper.traceIOException(ioe);
                }
            }
            bindHelper.bindACLPermissionChangeHandler(principalName, principalType, resourceName, aclType, das);
            bindHelper.bindRemoveACLChangeHandler(principalName, principalType, resourceName, aclType, das);
        }
    }

    private static void traceIOException(IOException ioe) {
    }

    private static void setSubjectACLPermissions(SubjectAclEntry sae, String aclType, String permission) {
        try {
            if (permission.equalsIgnoreCase("GRANT")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)4);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)1);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)2);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)8);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            } else if (permission.equalsIgnoreCase("DENY")) {
                if (aclType.equalsIgnoreCase("PUBLISH_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("SUBSCRIBE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("GUARANTEED_ACL")) {
                    sae.addPermission((byte)-5);
                } else if (aclType.equalsIgnoreCase("SEND_ACL")) {
                    sae.addPermission((byte)-2);
                } else if (aclType.equalsIgnoreCase("RECEIVE_ACL")) {
                    sae.addPermission((byte)-3);
                } else if (aclType.equalsIgnoreCase("BROWSE_ACL")) {
                    sae.addPermission((byte)-9);
                } else {
                    BrokerComponent.getComponentContext().logMessage("Unknown ACL type: " + aclType, 2);
                }
            }
        }
        catch (EPermissionConflict ePermissionConflict) {
        }
        catch (EUnknownPermission eUnknownPermission) {
            // empty catch block
        }
    }
}

