/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpConfigManager;
import progress.message.broker.HTTPAcceptor;

public class DirectProtocolConfigChangeHandler
implements IAttributeChangeHandler {
    private String m_protocolEntryName = null;
    private HTTPAcceptor m_acceptor = null;
    private IComponentContext m_context = BrokerComponent.getComponentContext();
    private boolean TRACE = false;

    public DirectProtocolConfigChangeHandler(String protocolEntryName, HTTPAcceptor acceptor) {
        this.m_protocolEntryName = protocolEntryName;
        this.m_acceptor = acceptor;
    }

    public void itemDeleted() {
        HttpConfigManager configMgr;
        if (this.TRACE) {
            System.out.println("DirectProtocolConfigChangeHandler.itemDeleted : protocl name = " + this.m_protocolEntryName);
        }
        if ((configMgr = this.m_acceptor.getConfigManager(this.m_protocolEntryName)) != null) {
            configMgr.onDeleted();
        } else {
            this.m_context.logMessage("HttpDirect protocol entry \"" + this.m_protocolEntryName + "\" not found", 3);
        }
        this.m_context.logMessage("HttpDirect protocol entry \"" + this.m_protocolEntryName + "\" is removed", 2);
    }

    public void itemModified(Object newValue) {
        if (this.TRACE) {
            System.out.println("Entering DirectProtocolConfigChangeHandler.itemModified : protocl name = " + this.m_protocolEntryName);
        }
        if (newValue == null) {
            return;
        }
    }
}

