/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

import com.sonicsw.net.http.HttpConstants;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpProtocolHandler;
import com.sonicsw.net.http.HttpRequestContext;
import com.sonicsw.net.http.QueueMessageRestorer;
import java.util.Enumeration;
import java.util.Hashtable;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BaseClientContext;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.PublishLimiter;
import progress.message.broker.UnsubscribeEvt;
import progress.message.msg.IMgram;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.Label;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.Subject;

public final class HttpClientContext
extends BaseClientContext {
    private static Hashtable m_lockPool = new Hashtable();
    private static QueueMessageRestorer s_queueMsgRestorer;
    private int m_minTopicPriority = 0;
    private static int s_globalMinTopicPriority;
    private static Hashtable s_contextPriorities;
    private boolean m_interBrokerHttpTopicReplyEnabled = false;
    private long m_clientId;
    private boolean m_isHTTPDirectOutbound = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HttpClientContext(long clientId, ClientSecurityContext csc, AgentConnection conn) {
        super(clientId, csc, conn);
        if (s_queueMsgRestorer == null) {
            Class<QueueMessageRestorer> clazz = QueueMessageRestorer.class;
            // MONITORENTER : com.sonicsw.net.http.QueueMessageRestorer.class
            if (s_queueMsgRestorer == null) {
                s_queueMsgRestorer = new QueueMessageRestorer();
            }
            // MONITOREXIT : clazz
        }
        this.m_clientId = clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpLock setAckLock(long id) {
        HttpLock lock = null;
        Long obj = new Long(id);
        Hashtable hashtable = m_lockPool;
        synchronized (hashtable) {
            lock = (HttpLock)m_lockPool.get(obj);
            if (lock == null) {
                lock = new HttpLock(id);
                m_lockPool.put(obj, lock);
            }
            lock.addWaiting();
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAckLock(HttpLock lock) {
        Hashtable hashtable = m_lockPool;
        synchronized (hashtable) {
            if (lock.getNumWaiting() == 0) {
                m_lockPool.remove(new Long(lock.getId()));
            }
        }
    }

    public HttpRequestContext waitForAck(HttpLock lock, long timeout) throws InterruptedException {
        HttpClientContext.printWaitingForAckLock(lock);
        IMgram responseMgram = lock.waitForAck(timeout);
        HttpRequestContext reqContext = new HttpRequestContext(lock);
        reqContext.setMgram(responseMgram);
        return reqContext;
    }

    public HttpRequestContext waitForAck(HttpLock lock) throws InterruptedException {
        HttpClientContext.printWaitingForAckLock(lock);
        LockExpirer exp = new LockExpirer(this, lock, lock.getId());
        AgentRegistrar.getAgentRegistrar().getWatchDogThread().addAbsoluteTimer(exp, exp.getExpirationTime());
        IMgram responseMgram = lock.waitForAck();
        HttpRequestContext reqContext = new HttpRequestContext(lock);
        reqContext.setMgram(responseMgram);
        return reqContext;
    }

    private static void printWaitingForAckLock(HttpLock lock) {
    }

    private void ackLock(long id, int errorType, String message) {
        Long obj = new Long(id);
        HttpLock lock = (HttpLock)m_lockPool.get(obj);
        if (lock != null) {
            lock.ack(errorType, message);
        }
    }

    private void ackMgramReceipt(IMgram m, long id) {
        Long obj = new Long(id);
        HttpLock lock = (HttpLock)m_lockPool.get(obj);
        if (lock != null) {
            lock.ackMgramReceipt(m);
        }
    }

    public Long extractContentReplyTracking(String dest) {
        Long id = null;
        String idStr = dest.substring(dest.indexOf("HttpProtocolHandlerResponse") + HttpProtocolHandler.CONTENT_REPLY_TEMP_DESTINATION_PREFIX_LENGTH);
        id = new Long(idStr);
        return id;
    }

    public Long extractPollingReceiveTracking(String destParam) {
        String dest = destParam;
        Long id = null;
        String secondKey = "";
        dest = this.getDest(dest);
        id = new Long(SessionConfig.stringToClientId(dest, secondKey));
        return id;
    }

    private void missingContentReplyLock(IMgram m) {
        try {
            AgentRegistrar.getAgentRegistrar().getQueueProc().processUndelivered(m, 5, false);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void missingPollingReceiveLock(IMgram m, String destParam) {
        String dest = destParam;
        dest = this.getDest(dest);
        s_queueMsgRestorer.restore(m, dest);
    }

    private String getDest(String destParam) {
        String dest = destParam;
        if (dest.startsWith("$Q.")) {
            dest = dest.substring("$Q.".length());
        }
        return dest;
    }

    @Override
    public void sendThrough(IMgram m) {
        long tracking;
        int errorType = 200;
        String msg = "";
        switch (m.getType()) {
            case 3: {
                short ackErr = m.getAckHandle().getErr();
                if (ackErr == 0) break;
                if (ackErr == -6 || ackErr == -26) {
                    errorType = 401;
                    msg = "User not permitted to access this resource.";
                    break;
                }
                if (ackErr == -15) {
                    errorType = 505;
                    msg = "Destination queue not found.";
                    break;
                }
                if (ackErr == -18) {
                    errorType = 503;
                    msg = "Service temporary unavailable.";
                    break;
                }
                if (ackErr == -16) {
                    errorType = 413;
                    msg = "Message size larger than configured limit (max queue size).";
                    break;
                }
                HttpConstants.DEBUG("Received ack with unanticipated error, code=" + ackErr, 1);
                errorType = 500;
                break;
            }
            case 20: {
                errorType = 507;
                msg = "Destination is blocked.";
                break;
            }
            case 18: {
                errorType = 507;
                msg = "Destination is blocked.";
                return;
            }
            case 19: {
                try {
                    if (!m.isSend()) {
                        this.m_flowController.onResumeReply(m);
                    }
                }
                catch (EMgramFormatError e) {
                    HttpConstants.DEBUG(e, 1);
                }
                return;
            }
            case 37: {
                IPTPFlowControlHandle handle = m.getPTPFlowControlHandle();
                switch (handle.getSubType()) {
                    case 2: {
                        try {
                            handle.setSubType((byte)3);
                            this.m_flowController.onResumeReply(m);
                        }
                        catch (EMgramFormatError e) {
                            HttpConstants.DEBUG(e, 1);
                        }
                        return;
                    }
                }
                return;
            }
            case 6: {
                errorType = 503;
                byte priority = m.getFlowControlHandle().getMinPriority();
                msg = "Destination is flow controlled.  Must send with priority >= " + priority;
                this.setMinTopicPriority(priority);
                return;
            }
            case -1: {
                errorType = 500;
                return;
            }
            case 0: {
                return;
            }
            default: {
                HttpConstants.DEBUG("Received unrecognized mgram of type " + m.getType(), 1);
            }
        }
        if ((tracking = m.getAckHandle().getTrackingNumber()) != 0L) {
            this.ackLock(tracking, errorType, msg);
        }
    }

    @Override
    public int send(IMgram m, Label opts, PublishLimiter limiter) {
        if (m.isPubSub() || m.isPTP()) {
            boolean isPollingReceive = false;
            String dest = m.getSubject().getSubjectString();
            boolean isTempDest = dest.indexOf("HttpProtocolHandlerResponse") != -1;
            isPollingReceive = !isTempDest;
            Long id = !isPollingReceive ? this.extractContentReplyTracking(dest) : this.extractPollingReceiveTracking(dest);
            HttpLock lock = (HttpLock)m_lockPool.get(id);
            if (lock == null) {
                if (isTempDest) {
                    this.missingContentReplyLock(m);
                } else {
                    this.missingPollingReceiveLock(m, dest);
                }
            } else {
                long tracking = id;
                if (tracking != 0L) {
                    this.ackMgramReceipt(m, tracking);
                }
            }
        } else {
            throw new EAssertFailure("Invalid message type on send!");
        }
        return 0;
    }

    @Override
    public int batch(IMgram m, Label opts, PublishLimiter pubLimiter) {
        return this.send(m, opts, pubLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(AgentConnection conn, boolean isInterbroker) {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.setupPTPFlowController();
            this.m_state = 8;
        }
    }

    public void disconnect() {
        this.m_flowController.disconnect();
        s_contextPriorities.remove(new Long(this.getId()));
        this.evaluateGlobalMinTopicPriority();
        try {
            AgentRegistrar.getAgentRegistrar().getQueueProc().removeTemporaryQueues(this.getId());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isInterBrokerHttpTopicReplyEnabled()) {
            long senderID = this.getCSC().getClientId();
            UnsubscribeEvt ue = new UnsubscribeEvt(null, senderID, new Subject("TEMPORARYTOPIC." + this.getClientId() + ".*"));
            try {
                AgentRegistrar.getAgentRegistrar().unsubscribe(ue);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
            }
            catch (EOldVirtualClockException eOldVirtualClockException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_state = 0;
    }

    public int getMinTopicPriority() {
        return this.m_minTopicPriority;
    }

    public int getGlobalMinTopicPriority() {
        return s_globalMinTopicPriority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMinTopicPriority(int priority) {
        Object object = this.m_syncObj;
        synchronized (object) {
            this.m_minTopicPriority = priority;
            s_contextPriorities.put(new Long(this.getId()), new Integer(priority));
            this.evaluateGlobalMinTopicPriority();
        }
    }

    private void evaluateGlobalMinTopicPriority() {
        Enumeration priorities = s_contextPriorities.elements();
        int minPrio = 0;
        while (priorities.hasMoreElements()) {
            int prio = (Integer)priorities.nextElement();
            minPrio = Math.max(minPrio, prio);
        }
        s_globalMinTopicPriority = minPrio;
        if (s_globalMinTopicPriority == 0) {
            s_contextPriorities.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingIfIdle() throws InterruptedException {
        Object object = this.m_syncObj;
        synchronized (object) {
            return;
        }
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean isHTTPDirect() {
        return true;
    }

    public void setHTTPDirectOutbound() {
        this.m_isHTTPDirectOutbound = true;
    }

    public boolean isHTTPDirectOutbound() {
        return this.m_isHTTPDirectOutbound;
    }

    @Override
    public boolean okToDispatchQueueMsgs(IMinEnqueuePriorityListener listener) {
        return true;
    }

    static QueueMessageRestorer getQueueMessageRestorer() {
        return s_queueMsgRestorer;
    }

    public boolean isInterBrokerHttpTopicReplyEnabled() {
        return this.m_interBrokerHttpTopicReplyEnabled;
    }

    public void setInterBrokerHttpTopicReplyEnabled(boolean b) {
        this.m_interBrokerHttpTopicReplyEnabled = b;
    }

    public long getClientId() {
        return this.m_clientId;
    }

    static {
        s_globalMinTopicPriority = 0;
        s_contextPriorities = new Hashtable();
    }

    public class LockExpirer
    implements Runnable {
        public HttpClientContext m_ctx;
        public HttpLock m_lock;
        public long m_tracking;
        public long m_expirationTime;

        public LockExpirer(HttpClientContext ctx, HttpLock lock, long tracking) {
            this.m_ctx = ctx;
            this.m_lock = lock;
            this.m_tracking = tracking;
            this.m_expirationTime = System.currentTimeMillis() + (long)(lock.getContentReplyTimeout() * 1000);
        }

        public long getExpirationTime() {
            return this.m_expirationTime;
        }

        @Override
        public void run() {
            Long obj = new Long(this.m_tracking);
            HttpLock lock = (HttpLock)m_lockPool.remove(obj);
            if (lock == null) {
                this.cleanupData();
                return;
            }
            if (this.m_lock.getAck()) {
                this.cleanupData();
                return;
            }
            int errorType = 503;
            String message = "Request timed out while waiting for response";
            this.m_lock.ack(errorType, message);
            this.cleanupData();
        }

        private void cleanupData() {
            this.cleanup();
            this.m_lock = null;
            this.m_ctx = null;
        }

        private void cleanup() {
            if (this.m_lock.isPTP()) {
                String qname = this.m_lock.getTempDest();
                if (qname != null) {
                    try {
                        AgentRegistrar.getAgentRegistrar().getQueueProc().removeTemporaryQueue(HttpClientContext.this.getCSC().getClientId(), qname);
                    }
                    catch (InterruptedException ex) {
                        HttpConstants.DEBUG(ex, 1);
                    }
                }
            } else {
                String topicname = this.m_lock.getTempDest();
                if (topicname != null) {
                    long senderID = HttpClientContext.this.getCSC().getClientId();
                    UnsubscribeEvt ue = new UnsubscribeEvt(null, senderID, new Subject(topicname));
                    try {
                        AgentRegistrar.getAgentRegistrar().unsubscribe(ue);
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                    }
                    catch (EOldVirtualClockException eOldVirtualClockException) {
                    }
                    catch (InterruptedException ex) {
                        HttpConstants.DEBUG(ex, 1);
                    }
                }
            }
        }
    }
}

