/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

final class CertChain {
    Vector<CertEntry> m_certTable = new Vector();
    X509Certificate[] m_chain = null;

    CertChain(X509Certificate[] certs) {
        if (certs == null) {
            return;
        }
        for (int i = 0; i < certs.length; ++i) {
            this.addCert(certs[i]);
        }
    }

    void addCert(X509Certificate cert) {
        CertEntry newEntry = new CertEntry(cert);
        for (int i = 0; i < this.m_certTable.size(); ++i) {
            this.m_certTable.elementAt(i).checkIssuer(newEntry);
        }
        this.m_certTable.add(newEntry);
        if (this.m_chain != null) {
            this.m_chain = null;
        }
    }

    X509Certificate[] getCertificateChain() {
        if (this.m_chain != null) {
            return this.m_chain;
        }
        if (this.m_certTable.isEmpty()) {
            return null;
        }
        CertEntry target = null;
        for (int i = 0; i < this.m_certTable.size(); ++i) {
            target = this.m_certTable.elementAt(i);
            if (!target.m_isIssuer) break;
        }
        if (target == null) {
            return null;
        }
        CertEntry entry = target;
        this.m_chain = new X509Certificate[this.m_certTable.size()];
        for (int i = 0; i < this.m_chain.length; ++i) {
            this.m_chain[i] = entry.m_cert;
            entry = entry.m_issuerEntry;
        }
        return this.m_chain;
    }

    class CertEntry {
        X509Certificate m_cert = null;
        X500Principal m_subject = null;
        X500Principal m_issuer = null;
        CertEntry m_issuerEntry = null;
        boolean m_isIssuer = false;

        CertEntry(X509Certificate cert) {
            this.m_cert = cert;
            this.m_subject = cert.getSubjectX500Principal();
            this.m_issuer = cert.getIssuerX500Principal();
            if (this.m_subject.equals(this.m_issuer)) {
                this.m_issuerEntry = this;
                this.m_isIssuer = true;
            }
        }

        boolean checkIssuer(CertEntry newEntry) {
            boolean found = false;
            if (this.m_issuerEntry == null && this.m_issuer.equals(newEntry.m_subject)) {
                this.m_issuerEntry = newEntry;
                newEntry.m_isIssuer = true;
                found = true;
            }
            if (this.m_subject.equals(newEntry.m_issuer)) {
                this.m_isIssuer = true;
                newEntry.m_issuerEntry = this;
            }
            return found;
        }
    }
}

