/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.security.ssl;

import com.sonicsw.security.ssl.X509KeyManagerWrapper;
import java.net.Socket;
import java.security.Principal;

public class X509KeyManagerServerImpl
extends X509KeyManagerWrapper {
    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (this.DEBUG) {
            this.printData(issuers, keyType);
        }
        boolean aliasFound = this.isAliasFound(issuers, keyType);
        return this.printData(aliasFound, keyType);
    }

    private boolean isAliasFound(Principal[] issuers, String keyType) {
        boolean aliasFound = false;
        String[] validAliases = this.getServerAliases(keyType, issuers);
        if (validAliases != null) {
            for (int j = 0; j < validAliases.length && !aliasFound; ++j) {
                if (!validAliases[j].equals(this.getKeyAlias())) continue;
                aliasFound = true;
                break;
            }
        }
        return aliasFound;
    }

    private void printData(Principal[] issuers, String keyType) {
        System.out.println(this.getClass().getName() + ".chooseServerAlias(): keyType = " + keyType + ", server alias = " + this.getKeyAlias());
        if (issuers != null) {
            for (int i = 0; i < issuers.length; ++i) {
                System.out.println("issuers # " + (i + 1) + " : " + issuers[i]);
            }
        }
    }

    private String printData(boolean aliasFound, String keyType) {
        if (aliasFound) {
            if (this.DEBUG) {
                System.out.println(this.getClass().getName() + ".chooseServerAlias(): returning " + this.getKeyAlias());
            }
            return this.getKeyAlias();
        }
        if (this.DEBUG) {
            System.out.println(this.getKeyAlias() + " - alias not found for key type :" + keyType);
        }
        return null;
    }
}

