/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.addressing;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class AddressingUtils {
    public static final String NS_ADDRESSING_WSDL_2006_05 = "http://www.w3.org/2006/05/addressing/wsdl";
    public static final String NS_ADDRESSING_WSDL_2006_02 = "http://www.w3.org/2006/02/addressing/wsdl";
    public static final String NS_ADDRESSING_WSDL_2005_03 = "http://www.w3.org/2005/03/addressing";
    public static final String NS_ADDRESSING_WSDL_2005_02 = "http://www.w3.org/2005/02/addressing";
    public static final String NS_ADDRESSING_WSDL_2004_12 = "http://www.w3.org/2004/12/addressing";
    private static final Set ADDRESSING_NS_SET = new HashSet();
    private static final Set ADDRESSING_FAULT_SET = new HashSet();
    private static final Set ADDRESSING_ANON_URI_SET = new HashSet();
    private static final Set ADDRESSING_NONE_URI_SET = new HashSet();
    private static final Set ADDRESSING_WSDL_NS_SET = new HashSet();

    public static String getDefaultNS() {
        String nsURI = System.getProperty("addressing.namespace.URI");
        if (nsURI != null) {
            return nsURI;
        }
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }

    public static boolean isAddressingNS(String s) {
        return ADDRESSING_NS_SET.contains(s);
    }

    public static boolean isNoneURI(String s) {
        return ADDRESSING_NONE_URI_SET.contains(s);
    }

    public static boolean isAnonymousURI(String s) {
        return ADDRESSING_ANON_URI_SET.contains(s);
    }

    public static boolean isFaultURI(String s) {
        return ADDRESSING_FAULT_SET.contains(s);
    }

    public static boolean isAddressingWSDLNS(String s) {
        return ADDRESSING_WSDL_NS_SET.contains(s);
    }

    public static QName getResponseRelationshipType(String nsURI) {
        if (nsURI.equals("http://schemas.xmlsoap.org/ws/2003/03/addressing")) {
            return new QName(nsURI, "Response");
        }
        return new QName(nsURI, "Reply");
    }

    public static String getAnonymousRoleURI(String namespaceURI) {
        if ("http://www.w3.org/2005/08/addressing".equals(namespaceURI)) {
            return "http://www.w3.org/2005/08/addressing/anonymous";
        }
        return namespaceURI + "/role/anonymous";
    }

    static {
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing");
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing");
        ADDRESSING_NS_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        ADDRESSING_NS_SET.add("http://www.w3.org/2005/08/addressing");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing/fault");
        ADDRESSING_FAULT_SET.add("http://www.w3.org/2005/08/addressing/fault");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/03/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
        ADDRESSING_ANON_URI_SET.add("http://www.w3.org/2005/08/addressing/anonymous");
        ADDRESSING_NONE_URI_SET.add("http://www.w3.org/2005/08/addressing/none");
        ADDRESSING_WSDL_NS_SET.add(NS_ADDRESSING_WSDL_2006_05);
        ADDRESSING_WSDL_NS_SET.add(NS_ADDRESSING_WSDL_2006_02);
        ADDRESSING_WSDL_NS_SET.add(NS_ADDRESSING_WSDL_2005_03);
        ADDRESSING_WSDL_NS_SET.add(NS_ADDRESSING_WSDL_2005_02);
        ADDRESSING_WSDL_NS_SET.add(NS_ADDRESSING_WSDL_2004_12);
    }
}

