/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.sender.fsm;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpLock;
import com.sonicsw.net.http.HttpOutboundHandler;
import com.sonicsw.ws.axis.handlers.HandlerUtils;
import com.sonicsw.ws.rm.common.RMEvent;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.rm.protocol.Constants;
import com.sonicsw.ws.rm.protocol.ElementCreator;
import com.sonicsw.ws.rm.protocol.ReliableHeaders;
import com.sonicsw.ws.rm.protocol.SequenceFault;
import com.sonicsw.ws.rm.receiver.fsm.ReceiverClient;
import com.sonicsw.ws.rm.sender.fsm.RMSendSequence;
import java.net.SocketException;
import java.util.Hashtable;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;

public class RequestTerminateEvent
extends RMEvent {
    @Override
    public void execute() {
        try {
            Constants RMConstants = this.getSequence().getConstants();
            org.apache.axis.message.SOAPEnvelope se = ElementCreator.createTerminateSequence(this.getSequence().getId(), this.getSequence().getSequenceState().getEndpointReference(), this.getSequence().getSOAPConstants(), RMConstants);
            ElementCreator.addNamespaceDeclarations(se, RMConstants);
            AddressingHeaders ah = new AddressingHeaders((SOAPEnvelope)se, false, true);
            Message m = new Message((Object)se);
            ReceiverClient rc = ReceiverClient.getReceiverClient();
            ReliableHeaders rh = new ReliableHeaders();
            rh.fromSOAPEnvelope(se);
            MessageContext mc = new MessageContext((AxisEngine)rc.getAxisClient());
            String transportURL = this.getSequence().getSequenceState().getEndpointReference().getAddress().toString();
            mc.setPastPivot(false);
            mc.setResponseMessage(null);
            mc.setRequestMessage(m);
            mc.setProperty("COM_SONIC_RM_REQUEST_HEADERS", (Object)rh);
            if (ah.getAction() != null) {
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("SOAPAction", ah.getAction().toString());
                props.put("Content-Type", "text/xml");
                mc.setProperty("HTTP_OUT_REQUEST_PROPERTIES", props);
            }
            HttpLock lock = new HttpLock(610L);
            mc.setProperty("com.sonicsw.net.http.HttpLock", (Object)lock);
            mc.setSOAPConstants(this.getSequence().getSOAPConstants());
            mc.setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", (Object)ah);
            String wsaNS = this.getSequence().getWSANS();
            if (wsaNS != null) {
                mc.setProperty("addressing.namespace.URI", (Object)wsaNS);
            }
            mc.setProperty("transport.url", (Object)transportURL);
            mc.setProperty("addressing.setMustUnderstand", (Object)Boolean.toString(false));
            mc.setMessage((SOAPMessage)m);
            HttpOutboundHandler handler = HandlerUtils.locateHttpRoutingHandler(transportURL);
            if (handler != null) {
                mc.setProperty("com.sonicsw.net.http.HttpOutboundHandler", (Object)handler);
            }
            rc.sendAxis(mc);
        }
        catch (Exception e) {
            Throwable cause;
            RMSendSequence support = (RMSendSequence)this.getSequence();
            RMManager rmm = RMManager.getRMManager();
            if (rmm.getRMSendSequenceSupport(support.getId()) != null) {
                support.markForTermination(null);
                rmm.onSequenceTermination(support.getId());
                support.faultSequence(SequenceFault.makeSequenceTerminatedFault(support.getConstants(), support.getId()), false, false);
                rmm.removeRMSequenceSupport(support);
            }
            if ((cause = e.getCause()) != null && cause instanceof SocketException) {
                BrokerComponent.getComponentContext().logMessage("Network failure attempting to send TerminateSequence message for SOAP reliable send sequence - " + cause.getMessage() + " :" + this.getSequence().getId(), BrokerComponent.getLevelWarning().intValue());
            }
            BrokerComponent.getComponentContext().logMessage("Failure attempting to send TerminateSequence message for SOAP reliable send sequence:" + this.getSequence().getId(), (Throwable)e, BrokerComponent.getLevelWarning().intValue());
        }
    }

    public String toString() {
        return "RequestTerminateEvent";
    }
}

