/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.model;

import com.sonicsw.ws.security.policy.model.BootstrapToken;
import com.sonicsw.ws.security.policy.model.HttpsToken;
import com.sonicsw.ws.security.policy.model.IssuerToken;
import com.sonicsw.ws.security.policy.model.KeyStoreEntry;
import com.sonicsw.ws.security.policy.model.RequiredElements;
import com.sonicsw.ws.security.policy.model.SecureConversationToken;
import com.sonicsw.ws.security.policy.model.TransportBinding;
import com.sonicsw.ws.security.policy.model.TransportToken;
import com.sonicsw.ws.security.policy.model.Trust10Token;
import com.sonicsw.ws.security.policy.model.X509IssuerSerial;
import com.sonicsw.ws.security.policy.model.X509Token;
import com.sonicsw.ws.security.policy.parser.SecurityPolicy;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RootPolicyEngineData;

public class SonicPolicyEngineData
extends RootPolicyEngineData {
    private ArrayList topLevelPEDs = new ArrayList();

    public void addTopLevelPED(PolicyEngineData ped) {
        if (!this.topLevelPEDs.contains(ped)) {
            this.topLevelPEDs.add(ped);
        }
    }

    public ArrayList getTopLevelPEDs() {
        return this.topLevelPEDs;
    }

    public static PolicyEngineData copy(QName name) throws WSSPolicyException {
        if (name.getLocalPart().equals(SecurityPolicy.httpsToken.getTokenName())) {
            return new HttpsToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.transportToken.getTokenName())) {
            return new TransportToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.transportBinding.getTokenName())) {
            return new TransportBinding();
        }
        if (name.getLocalPart().equals(SecurityPolicy.secureConversationToken.getTokenName())) {
            return new SecureConversationToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.issuer.getTokenName())) {
            return new IssuerToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.bootstrapPolicy.getTokenName())) {
            return new BootstrapToken();
        }
        if (name.getLocalPart().equals(SecurityPolicy.trust10.getTokenName())) {
            return new Trust10Token();
        }
        if (name.getLocalPart().equals(SecurityPolicy.requiredElements.getTokenName())) {
            return new RequiredElements();
        }
        if (name.getLocalPart().equals(SecurityPolicy.x509Token.getTokenName())) {
            return new X509Token();
        }
        if (name.getLocalPart().equals(SecurityPolicy.keyStoreEntry.getTokenName())) {
            return new KeyStoreEntry();
        }
        if (name.getLocalPart().equals(SecurityPolicy.x509IssuerSerial.getTokenName())) {
            return new X509IssuerSerial();
        }
        return PolicyEngineData.copy((QName)name);
    }
}

