/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;

class ConnectionIdEvt
extends LogEvent {
    private long m_id;

    ConnectionIdEvt(long id) {
        this.m_id = id;
    }

    ConnectionIdEvt() {
    }

    @Override
    public short type() {
        return 45;
    }

    @Override
    protected int memSizeBody() {
        return 8;
    }

    @Override
    public int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    public int serializedSizeBody() {
        return 8;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_id, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_id = StreamUtil.readLong(in);
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoConnectionId(this.m_id);
    }

    @Override
    public String toString() {
        return super.toString() + "Connection id: " + this.m_id;
    }
}

