/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Date;
import progress.message.broker.IBrokerSubscription;
import progress.message.zclient.DebugObject;

public class ExpirationQueue
extends DebugObject {
    private static final int MIN_SIZE = 16;
    private IBrokerSubscription[] m_heap = new IBrokerSubscription[16];
    private int m_count = 0;

    ExpirationQueue() {
        super("ExpirationQueue");
    }

    public synchronized void insert(IBrokerSubscription bs) {
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "] inserting bs = " + bs);
        }
        int oldindex = bs.getExpQIndex();
        long oldkey = bs.getExpQKey();
        long newkey = bs.getTTE();
        bs.setExpQKey(newkey);
        if (oldindex >= 0) {
            if (newkey > oldkey) {
                this.keyIncreased(oldindex);
            } else {
                this.keyDecreased(oldindex);
            }
        } else {
            if (this.m_count == this.m_heap.length) {
                this.resizeHeap(this.m_heap.length << 1);
            }
            int i = this.m_count++;
            bs.setExpQIndex(i);
            this.m_heap[i] = bs;
            this.keyDecreased(i);
        }
    }

    synchronized long getSoonestTime() {
        if (this.m_count == 0) {
            return -1L;
        }
        return this.m_heap[0].getExpQKey();
    }

    synchronized IBrokerSubscription extractSoonest() {
        if (this.m_count == 0) {
            return null;
        }
        IBrokerSubscription bs = this.m_heap[0];
        this.remove(bs);
        return bs;
    }

    synchronized void remove(IBrokerSubscription bs) {
        int i = bs.getExpQIndex();
        if (i < 0) {
            return;
        }
        this.m_heap[i] = this.m_heap[--this.m_count];
        this.m_heap[i].setExpQIndex(i);
        if (this.m_heap[i].getExpQKey() > bs.getExpQKey()) {
            this.keyIncreased(i);
        } else {
            this.keyDecreased(i);
        }
        if (this.m_count > 16 && this.m_count < this.m_heap.length >>> 2) {
            this.resizeHeap(this.m_heap.length >>> 1);
        }
        bs.setExpQIndex(-1);
        if (this.DEBUG) {
            this.debug("[" + new Date(System.currentTimeMillis()) + "] removed bs = " + bs);
        }
    }

    private void resizeHeap(int size) {
        IBrokerSubscription[] newheap = new IBrokerSubscription[size];
        System.arraycopy(this.m_heap, 0, newheap, 0, this.m_count);
        this.m_heap = newheap;
    }

    private int parent(int i) {
        return i - 1 >>> 1;
    }

    private int left(int i) {
        return (i << 1) + 1;
    }

    private int right(int i) {
        return (i << 1) + 2;
    }

    private void keyDecreased(int iParam) {
        int i = iParam;
        IBrokerSubscription bs = this.m_heap[i];
        long key = bs.getExpQKey();
        while (i > 0 && this.m_heap[this.parent(i)].getExpQKey() > key) {
            int p = this.parent(i);
            this.m_heap[i] = this.m_heap[p];
            this.m_heap[i].setExpQIndex(i);
            i = p;
        }
        this.m_heap[i] = bs;
        bs.setExpQIndex(i);
    }

    private void keyIncreased(int i) {
        long rkey;
        long lkey;
        int l = this.left(i);
        int r = this.right(i);
        long ikey = this.m_heap[i].getExpQKey();
        int lowest = i;
        long lowestKey = ikey;
        if (l < this.m_count && (lkey = this.m_heap[l].getExpQKey()) < lowestKey) {
            lowest = l;
            lowestKey = lkey;
        }
        if (r < this.m_count && (rkey = this.m_heap[r].getExpQKey()) < lowestKey) {
            lowest = r;
            lowestKey = rkey;
        }
        if (lowest != i) {
            IBrokerSubscription temp = this.m_heap[i];
            this.m_heap[i] = this.m_heap[lowest];
            this.m_heap[i].setExpQIndex(i);
            this.m_heap[lowest] = temp;
            this.m_heap[lowest].setExpQIndex(lowest);
            this.keyIncreased(lowest);
        }
    }
}

