/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class LogOrderedList
extends DebugObject {
    long[] m_orderedArray;
    long[] m_entryArray;
    int m_length;
    int m_current;

    public LogOrderedList(int length) {
        super(DebugState.GLOBAL_DEBUG_ON ? "LogOrderedList" : null);
        this.m_length = length;
        this.m_orderedArray = new long[length];
        this.m_entryArray = new long[length];
        this.m_current = 0;
    }

    public void add(long numParam) {
        long num = numParam;
        this.delete(this.m_entryArray[this.m_current]);
        this.m_entryArray[this.m_current] = num;
        ++this.m_current;
        if (this.m_current >= this.m_length) {
            this.m_current = 0;
        }
        for (int i = this.m_length - 1; i >= 0; --i) {
            long val = this.m_orderedArray[i];
            if (num < val) continue;
            this.m_orderedArray[i] = num;
            num = val;
        }
    }

    private void delete(long num) {
        boolean found = false;
        for (int i = this.m_length - 1; i > 0; --i) {
            if (num == this.m_orderedArray[i]) {
                found = true;
            }
            if (!found) continue;
            this.m_orderedArray[i] = this.m_orderedArray[i - 1];
        }
        this.m_orderedArray[0] = 0L;
    }

    public int diff() {
        int count = 0;
        for (int i = 0; i < this.m_length - 1; ++i) {
            if (this.m_orderedArray[i] == this.m_orderedArray[i + 1]) continue;
            ++count;
        }
        return count;
    }
}

