/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.MessageGroupTable;
import progress.message.broker.parser.EvalException;
import progress.message.broker.parser.MessageSelector;
import progress.message.msg.IMgram;

public class MessageGroupSelector
extends MessageSelector {
    private long m_uid = -1L;
    private String m_groupIdPropertyName = null;
    private String m_groupSeqPropertyName = null;
    private MessageGroupTable m_groupMappingTable = null;

    public MessageGroupSelector(long uid, MessageGroupTable table, String groupID, String groupSeq) {
        super(0);
        this.m_uid = uid;
        this.m_groupIdPropertyName = groupID;
        this.m_groupSeqPropertyName = groupSeq;
        this.m_groupMappingTable = table;
    }

    @Override
    public boolean match(IMgram m) throws EvalException {
        String groupID = MessageGroupSelector.getGroupID(m, this.m_groupIdPropertyName);
        if (groupID == null) {
            return true;
        }
        boolean last = false;
        long tracking = -1L;
        Object groupSeq = MessageGroupSelector.getGroupSeq(m, this.m_groupSeqPropertyName);
        if (groupSeq != null) {
            try {
                int seq = groupSeq instanceof String ? Integer.parseInt((String)groupSeq) : (Integer)groupSeq;
                if (seq == 0) {
                    last = true;
                } else if (seq == -1) {
                    last = true;
                    if (m.isDiscardable()) {
                        tracking = AgentRegistrar.getAgentRegistrar().getLogManager().allocSeqNo() & 0xFFFFFFFFFFFFL;
                        m.setGuarenteed(tracking);
                    } else {
                        tracking = m.getGuarenteedTrackingNum();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.m_groupMappingTable.match(groupID, this.m_uid, last, tracking);
    }

    static String getGroupID(IMgram msg, String groupPropertyName) {
        Object property;
        String groupID = null;
        IMgram msgToCheck = MessageGroupSelector.findMsgToCheck(msg);
        if (msgToCheck != null && msgToCheck.hasSidebandData() && (property = msgToCheck.getSidebandDataReadOnly().getProperty(groupPropertyName)) != null && property instanceof String) {
            groupID = (String)property;
        }
        return groupID;
    }

    private static Object getGroupSeq(IMgram msg, String seqPropertyName) {
        Object property;
        IMgram msgToCheck = MessageGroupSelector.findMsgToCheck(msg);
        if (msgToCheck != null && msgToCheck.hasSidebandData() && (property = msgToCheck.getSidebandDataReadOnly().getProperty(seqPropertyName)) != null && (property instanceof String || property instanceof Integer)) {
            return property;
        }
        return null;
    }

    private static IMgram findMsgToCheck(IMgram msg) {
        Iterator it;
        IMgram msgToCheck = msg;
        if (msg.getType() == 27 && (it = msg.getBatchHandle().getBatchIterator()).hasNext()) {
            msgToCheck = (IMgram)it.next();
        }
        return msgToCheck;
    }
}

