/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EInvalidAdminAddress;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.prAccessor;
import progress.message.client.EGeneralException;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;
import progress.message.zclient.Subject;

final class Unsubscribe
implements IMessageHandler {
    private AgentRegistrar m_reg;

    Unsubscribe(AgentRegistrar reg) {
        this.m_reg = reg;
    }

    @Override
    public void handleMessage(Session s, Envelope env) {
        try {
            Message msg = env.getMessage();
            long requestor = AddrUtil.getIdFromAdmin(env.getSubject());
            int refCount = msg.readInt();
            String sub = msg.readUTF();
            this.m_reg.unsubscribe(new UnsubscribeEvt(env, requestor, new Subject(sub)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (EClientNotRegistered e) {
        }
        catch (EInvalidAdminAddress e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (EGeneralException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        catch (IOException e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
    }

    static void sendSuccessReply(UnsubscribeEvt evt) {
        block2: {
            try {
                Envelope req = evt.getRequest();
                Message rep = new Message();
                AgentRegistrar.getAgentRegistrar().getAdminSession().reply(rep, req, false);
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block2;
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR271") + e.getMessage(), (Throwable)e, 2);
            }
        }
    }
}

