/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.SubAckMessage;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

class SubAckEncoder
extends DemuxEncoder<SubAckMessage> {
    SubAckEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(SubAckMessage message, IByteBuffer out) {
        if (message.grantedQos().isEmpty()) {
            throw new MqttException("SubAck with empty granted QoS");
        }
        int variableHeaderSize = 2 + message.grantedQos().size();
        ByteBuffer buff = new ByteBuffer(6 + variableHeaderSize);
        try {
            byte flags = MqttCodecUtils.encodeFlags(message);
            buff.writeByte(0x90 | flags);
            buff.merge(MqttCodecUtils.encodeRemainingLength(variableHeaderSize));
            buff.writeUnsignedShort(message.getMessageId());
            for (MqttQoS c : message.grantedQos()) {
                buff.writeByte(c.value());
            }
            out.merge(buff);
        }
        finally {
            buff.clear();
        }
    }
}

