/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import progress.message.broker.mqtt.codec.DemuxEncoder;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.broker.mqtt.proto.UnsubscribeMessage;
import progress.message.util.server.ByteBuffer;
import progress.message.util.server.IByteBuffer;

class UnsubscribeEncoder
extends DemuxEncoder<UnsubscribeMessage> {
    UnsubscribeEncoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(UnsubscribeMessage message, IByteBuffer out) {
        if (message.topicFilters().isEmpty()) {
            throw new MqttException("Unsubscribe with empty topic filters");
        }
        if (message.getQos() != MqttQoS.AT_LEAST_ONCE) {
            throw new MqttException("Unsubscribe MUST have QoS 1 (AT_LEAST_ONCE), got QoS = " + (Object)((Object)message.getQos()));
        }
        ByteBuffer variableHeaderBuff = new ByteBuffer(4);
        IByteBuffer buff = null;
        try {
            variableHeaderBuff.writeUnsignedShort(message.getMessageId());
            for (String topic : message.topicFilters()) {
                variableHeaderBuff.merge(MqttCodecUtils.encodeString(topic));
            }
            int variableHeaderSize = variableHeaderBuff.countUnread();
            byte flags = MqttCodecUtils.encodeFlags(message);
            buff = new ByteBuffer(2 + variableHeaderSize);
            buff.writeByte(0xA0 | flags);
            buff.merge(MqttCodecUtils.encodeRemainingLength(variableHeaderSize));
            buff.merge(variableHeaderBuff);
            out.merge(buff);
        }
        finally {
            variableHeaderBuff.clear();
            buff.clear();
        }
    }
}

