/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse;

import com.odi.Database;
import com.odi.tools.dbdump.LogTarget;
import com.odi.util.OSHashtable;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import java.util.Vector;
import progress.message.broker.CompactStatusMonitor;
import progress.message.db.EBrokerNameTooLong;
import progress.message.db.EDatabaseException;
import progress.message.db.EDatabaseNotExists;
import progress.message.db.pse.PSEBrokerDb;
import progress.message.db.pse.PSEDbContext;
import progress.message.db.pse.PSEUtil;
import progress.message.db.pse.util.OpContext;
import progress.message.db.pse.util.OpExec;
import progress.message.dbsc.ISchemaDef;
import progress.message.dbsc.SchemaDefBase;
import progress.message.dbsc.pse.DBCompact;
import progress.message.dbsc.pse.UpgradeHelperV7ToV702;
import progress.message.dbsc.pse.pc.dd.PSEDupDetectInfo;
import progress.message.dbsc.pse.pc.gr.PSERemoteBroker;
import progress.message.dbsc.pse.pc.ptp.PSEQMessage;
import progress.message.dbsc.pse.pc.ptp.PSEQueue;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.v2.PSEMessages2;
import progress.message.dbsc.pse.pc.reg.PSEClient;
import progress.message.util.DebugState;

public class DbSchemaPSE
extends SchemaDefBase
implements ISchemaDef {
    TreeMap m_rdefs;
    PSEBrokerDb m_pseDb;
    SingleDbDefBase m_regDef;
    SingleDbDefBase m_ddDef;
    SingleDbDefBase m_routingDef;
    SingleDbDefBase m_pubsubDef;
    SingleDbDefBase m_ptpDef;
    DBCompact compacter;

    public DbSchemaPSE(PSEBrokerDb psedb) {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName("DbSchemaPSE " + psedb.getDbDir());
        }
        this.m_pseDb = psedb;
        this.m_regDef = new SchemaReg(this.m_pseDb.getDbDir(), "reg", "reg");
        this.m_ddDef = new SchemaDD(this.m_pseDb.getDbDir(), "dd", "dd", this.m_pseDb.getDDName());
        this.m_routingDef = new SchemaRouting(this.m_pseDb.getDbDir(), "gr", "gr");
        this.m_pubsubDef = new SchemaPubSub(this.m_pseDb.getDbDir(), "pubsub", "pubsub");
        this.m_ptpDef = new SchemaPtp(this.m_pseDb.getDbDir(), "ptp", "ptp");
        this.m_rdefs = new TreeMap();
        RDefBase rd = new RootDefBrokerDBVer();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefBrokerInfo();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefBrokerMode();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefBrokerName();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefBrokerQoPCipher();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefBrokerState();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefClientUndelMsgs();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefCounters();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefQCounters();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefLogTime();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefMessages();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefRBRegistry();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefRouteInfo();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefSyncPoint();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefClients();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefQueues();
        this.m_rdefs.put(rd.getName(), rd);
        rd = new RootDefQMessages();
        this.m_rdefs.put(rd.getName(), rd);
    }

    @Override
    public void createAll() throws EDatabaseException, EBrokerNameTooLong {
        PSEDbContext pdb = this.m_regDef.createSchema();
        pdb = this.m_routingDef.createSchema();
        pdb = this.m_ptpDef.createSchema();
        pdb = this.m_pubsubDef.createSchema();
    }

    @Override
    public void createDD() throws EDatabaseException, EBrokerNameTooLong {
        PSEDbContext pdb = this.m_ddDef.createSchema();
    }

    public PSEDbContext openReg() throws EDatabaseException {
        return this.m_regDef.open();
    }

    public PSEDbContext openDD() throws EDatabaseException {
        return this.m_ddDef.open();
    }

    public PSEDbContext openPubSub() throws EDatabaseException {
        return this.m_pubsubDef.open();
    }

    public PSEDbContext openGR() throws EDatabaseException {
        return this.m_routingDef.open();
    }

    public PSEDbContext openPtp() throws EDatabaseException {
        return this.m_ptpDef.open();
    }

    @Override
    public void dropAll() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("dropAll starting");
        }
        this.m_pseDb.validateDb();
        this.m_regDef.drop();
        this.m_routingDef.drop();
        this.m_ptpDef.drop();
        this.m_pubsubDef.drop();
        if (this.DEBUG) {
            this.debug("dropAll completed");
        }
    }

    @Override
    public void dropDD() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("dropDD starting");
        }
        this.m_ddDef.drop();
        if (this.DEBUG) {
            this.debug("dropDD completed");
        }
    }

    @Override
    public void upgradeAll(int dbvers) throws EDatabaseException {
        UpgradeHelperV7ToV702 upgradeLogic = new UpgradeHelperV7ToV702(this.m_pseDb, this);
        upgradeLogic.doUpgrade();
    }

    @Override
    public void upgradeDD(int invers) throws EDatabaseException {
    }

    @Override
    public void stopCompact() {
        if (this.compacter == null) {
            return;
        }
        this.compacter.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact(String workingDir) throws EDatabaseException {
        SingleDbDefBase[] dbFiles = new SingleDbDefBase[]{this.m_regDef, this.m_ddDef, this.m_routingDef, this.m_pubsubDef, this.m_ptpDef};
        CompactStatusMonitor.CompactStatus status = CompactStatusMonitor.CompactStatus.IN_PROGRESS;
        Throwable thrown = null;
        CompactStatusMonitor.setStatus(status);
        try {
            LogTarget lt = this.getCompatorLog();
            this.compacter = new DBCompact(workingDir, lt);
            for (int i = 0; i < dbFiles.length; ++i) {
                SingleDbDefBase db = dbFiles[i];
                this.compacter.compact(db.getFullFileName() + ".odb", db.m_pseDbFileName + ".odb");
            }
            status = CompactStatusMonitor.CompactStatus.COMPLETED_OK;
        }
        catch (Throwable t) {
            try {
                this.compacter = null;
                status = CompactStatusMonitor.CompactStatus.COMPLETED_FAILED;
                thrown = t;
            }
            catch (Throwable throwable) {
                CompactStatusMonitor.setStatus(status, thrown);
                throw throwable;
            }
            CompactStatusMonitor.setStatus(status, thrown);
        }
        CompactStatusMonitor.setStatus(status, thrown);
    }

    private LogTarget getCompatorLog() {
        final ISchemaDef.LogTarget dbLt = this.logTarget;
        LogTarget lt = new LogTarget(){

            public void log(String type, String message) {
                if (dbLt != null) {
                    dbLt.log(type, message);
                } else {
                    System.out.println(message);
                }
            }
        };
        return lt;
    }

    class RootDefClients
    extends RDefBase {
        RootDefClients() {
            super("Clients");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), PSEClient.class, "getClientId()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefRouteInfo
    extends RDefBase {
        RootDefRouteInfo() {
            super("RouteInfo");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            OpExec op = new OpExec(){

                @Override
                public Object doit(Database db, Vector parms) throws EDatabaseException {
                    String nm = (String)parms.elementAt(0);
                    OSHashtable ht = new OSHashtable();
                    db.createRoot(nm, (Object)ht);
                    return null;
                }
            };
            Vector<String> parms = new Vector<String>();
            parms.addElement(DbSchemaPSE.this.m_pseDb.rootName(this.getName()));
            op.exec(new OpContext(2, pdb), parms);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefRBRegistry
    extends RDefBase {
        RootDefRBRegistry() {
            super("RBRegistry");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            Class<PSERemoteBroker> cl = PSERemoteBroker.class;
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), cl, "getClientId()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefQueues
    extends RDefBase {
        RootDefQueues() {
            super("Queues");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            Class<PSEQueue> cl = PSEQueue.class;
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), cl, "getQueueName()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefQMessages
    extends RDefBase {
        RootDefQMessages() {
            super("QMessages");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            Class<PSEQMessage> cl = PSEQMessage.class;
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), cl, "getMessageId()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefMessages
    extends RDefBase {
        RootDefMessages() {
            super("Messages");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            OpExec op = new OpExec(){

                @Override
                public Object doit(Database db, Vector parms) throws EDatabaseException {
                    String nm = (String)parms.elementAt(0);
                    PSEMessages2 msgs = new PSEMessages2(db);
                    db.createRoot(nm, (Object)msgs);
                    return null;
                }
            };
            Vector<String> parms = new Vector<String>();
            parms.addElement(DbSchemaPSE.this.m_pseDb.rootName(this.getName()));
            op.exec(new OpContext(2, pdb), parms);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefQCounters
    extends RDefBase {
        RootDefQCounters() {
            super("QCounters");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefCounters
    extends RDefBase {
        RootDefCounters() {
            super("Counters");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefSyncPoint
    extends RDefBase {
        RootDefSyncPoint() {
            super("SyncPoint");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefLogTime
    extends RDefBase {
        RootDefLogTime() {
            super("LogTime");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefDD
    extends RDefBase {
        RootDefDD(String name) {
            super(name);
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            Class<PSEDupDetectInfo> cl = PSEDupDetectInfo.class;
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), cl, "getCommitID()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefClientUndelMsgs
    extends RDefBase {
        RootDefClientUndelMsgs() {
            super("ClientUndelMsgs");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            Class<IPSEClientUndelMsgs> cl = IPSEClientUndelMsgs.class;
            DbSchemaPSE.this.m_pseDb.createRootTreeSet(pdb, this.getName(), cl, "getClientId()");
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerState
    extends RDefBase {
        RootDefBrokerState() {
            super("BrokerState");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerQoPCipher
    extends RDefBase {
        RootDefBrokerQoPCipher() {
            super("BrokerQoPCipher");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerName
    extends RDefBase {
        RootDefBrokerName() {
            super("BrokerName");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), new String(DbSchemaPSE.this.m_pseDb.getBrokerName()));
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerMode
    extends RDefBase {
        RootDefBrokerMode() {
            super("BrokerMode");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerInfo
    extends RDefBase {
        RootDefBrokerInfo() {
            super("BrokerInfo");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    class RootDefBrokerDBVer
    extends RDefBase {
        RootDefBrokerDBVer() {
            super("BrokerDBVer");
        }

        @Override
        public void createRoot(PSEDbContext pdb) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.m_pseDb.createRoot(pdb, this.getName(), null);
        }

        public Vector getIndexNames() {
            return null;
        }
    }

    abstract class RDefBase {
        String m_name;

        RDefBase(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public abstract void createRoot(PSEDbContext var1) throws EDatabaseException, EBrokerNameTooLong;

        public void create(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            DbSchemaPSE.this.notifyCreate(this.m_name);
            this.createRoot(ctx);
        }

        public void drop() {
        }
    }

    public class SchemaRouting
    extends SingleDbDefBase {
        SchemaRouting(String dbDir, String subdir, String filename) {
            super(dbDir, subdir, filename, 2);
        }

        @Override
        public void createSchema(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            RDefBase def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("RBRegistry");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("RouteInfo");
            def.create(ctx);
        }
    }

    public class SchemaPtp
    extends SingleDbDefBase {
        SchemaPtp(String dbDir, String subdir, String filename) {
            super(dbDir, subdir, filename, 4);
        }

        @Override
        public void createSchema(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            RDefBase def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("Queues");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("QMessages");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("QCounters");
            def.create(ctx);
        }
    }

    public class SchemaPubSub
    extends SingleDbDefBase {
        SchemaPubSub(String dbDir, String subdir, String filename) {
            super(dbDir, subdir, filename, 3);
        }

        @Override
        public void createSchema(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            RDefBase def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("ClientUndelMsgs");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("Messages");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("Counters");
            def.create(ctx);
        }
    }

    public class SchemaDD
    extends SingleDbDefBase {
        String m_ddName;

        SchemaDD(String dbDir, String subdir, String filename, String ddName) {
            super(dbDir, subdir, filename, 5);
            this.m_ddName = ddName;
        }

        @Override
        public void createSchema(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            RootDefDD rd = new RootDefDD(this.m_ddName);
            rd.create(ctx);
        }
    }

    public class SchemaReg
    extends SingleDbDefBase {
        SchemaReg(String dbDir, String subdir, String filename) {
            super(dbDir, subdir, filename, 1);
        }

        @Override
        public void createSchema(PSEDbContext ctx) throws EDatabaseException, EBrokerNameTooLong {
            RDefBase def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerName");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerDBVer");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerInfo");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerMode");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerQoPCipher");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("BrokerState");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("LogTime");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("SyncPoint");
            def.create(ctx);
            def = (RDefBase)DbSchemaPSE.this.m_rdefs.get("Clients");
            def.create(ctx);
        }
    }

    abstract class SingleDbDefBase {
        String m_dbDir;
        String m_subDir;
        String m_pseDbFileName;
        int m_ident;

        SingleDbDefBase(String dbDir, String subdir, String filename, int ident) {
            this.m_dbDir = dbDir;
            this.m_subDir = subdir;
            this.m_pseDbFileName = filename;
            this.m_ident = ident;
        }

        public PSEDbContext createSchema() throws EDatabaseException, EBrokerNameTooLong {
            PSEUtil.createNewDbSubDir(this.m_dbDir, this.m_subDir);
            String fullDir = PSEUtil.buildDirName(this.m_dbDir, this.m_subDir);
            if (DbSchemaPSE.this.DEBUG) {
                DbSchemaPSE.this.debug("createSchema " + this.getClass().getName() + ": fullDir= " + fullDir);
            }
            PSEDbContext pdb = DbSchemaPSE.this.m_pseDb.createNewContext(this.m_ident, fullDir, this.m_pseDbFileName, true);
            this.createSchema(pdb);
            return pdb;
        }

        public String getFullFileName() {
            String fullDir = PSEUtil.buildDirName(this.m_dbDir, this.m_subDir);
            File fullFile = new File(fullDir, this.m_pseDbFileName);
            return fullFile.getAbsolutePath();
        }

        public abstract void createSchema(PSEDbContext var1) throws EDatabaseException, EBrokerNameTooLong;

        public PSEDbContext open() throws EDatabaseException {
            String fullDir = PSEUtil.buildDirName(this.m_dbDir, this.m_subDir);
            File f = new File(fullDir);
            if (!f.exists()) {
                throw new EDatabaseNotExists("Directory does not exist: " + fullDir);
            }
            if (DbSchemaPSE.this.DEBUG) {
                DbSchemaPSE.this.debug("open " + this.getClass().getName() + ": fullDir= " + fullDir);
            }
            DBCompact compacter = new DBCompact(null, DbSchemaPSE.this.getCompatorLog());
            try {
                compacter.restore(fullDir, this.m_pseDbFileName);
            }
            catch (IOException ioe) {
                throw new EDatabaseException(ioe);
            }
            PSEDbContext pdb = DbSchemaPSE.this.m_pseDb.createNewContext(this.m_ident, fullDir, this.m_pseDbFileName, false);
            return pdb;
        }

        public void drop() throws EDatabaseException {
            if (DbSchemaPSE.this.DEBUG) {
                DbSchemaPSE.this.debug("drop " + this.getClass().getName() + " starting");
            }
            if (!PSEUtil.existsPSEDbFile(this.m_dbDir, this.m_subDir, this.m_pseDbFileName)) {
                return;
            }
            PSEDbContext pdb = this.open();
            try {
                DbSchemaPSE.this.m_pseDb.destroy(this.m_ident);
                PSEUtil.deleteDbSubDir(this.m_dbDir, this.m_subDir);
            }
            catch (EDatabaseException eDatabaseException) {
                // empty catch block
            }
            if (DbSchemaPSE.this.DEBUG) {
                DbSchemaPSE.this.debug("drop " + this.getClass().getName() + " completed");
            }
        }
    }
}

