/*
 * Decompiled with CFR 0.152.
 */
package progress.message.dbsc.pse.pc.pubsub;

import com.odi.ClassInfo;
import com.odi.Database;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.Placement;
import com.odi.imp.ObjectReference;
import com.odi.util.DuplicateKeyException;
import com.odi.util.IndexIterator;
import com.odi.util.OSTreeSet;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import progress.message.dbsc.pse.pc.pubsub.IPSEClientUndelMsgs;
import progress.message.dbsc.pse.pc.pubsub.IPSEMessage;
import progress.message.dbsc.pse.pc.pubsub.IPSEUndelMsg;
import progress.message.dbsc.pse.pc.pubsub.PSEMultiSubjectUndelMsg;
import progress.message.dbsc.pse.pc.pubsub.PSEUndelMsg;
import progress.message.util.EAssertFailure;

public class PSEClientUndelMsgs
implements IPSEClientUndelMsgs,
IPersistent,
IPersistentHooks {
    private long _ClientId;
    private long _totalSize;
    private OSTreeSet _undelMsgs;
    private static Class msgClass;
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    static ClassInfo myOdiClassInfoInstance;

    public PSEClientUndelMsgs(Database db, long cid) {
        this._ClientId = cid;
        this._undelMsgs = new OSTreeSet((Placement)db, msgClass, "getMessageId()");
    }

    @Override
    public long getClientId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._ClientId;
    }

    @Override
    public long getTotalSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._totalSize;
    }

    @Override
    public OSTreeSet getAllUndel() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._undelMsgs;
    }

    @Override
    public boolean addUndel(long mid, long seq, int size, boolean red, Date exp, boolean frb, boolean pers, Collection undelSubjectIds, IPSEMessage msg) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        boolean added = false;
        try {
            added = undelSubjectIds != null ? this._undelMsgs.add((Object)new PSEMultiSubjectUndelMsg(this._ClientId, mid, seq, size, red, exp, frb, pers, undelSubjectIds, msg)) : this._undelMsgs.add((Object)new PSEUndelMsg(this._ClientId, mid, seq, size, red, exp, frb, pers, msg));
            if (added) {
                msg.addRecipient(this._ClientId);
                this.updateTotalSize(size);
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        return added;
    }

    @Override
    public IPSEUndelMsg getUndelMsg(long mid) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        IPSEUndelMsg cmsg = (IPSEUndelMsg)this._undelMsgs.getFromPrimaryIndex((Object)new Long(mid));
        return cmsg;
    }

    @Override
    public boolean deleteUndel(long mid) {
        IPSEUndelMsg undelmsg;
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if ((undelmsg = this.getUndelMsg(mid)) == null) {
            return false;
        }
        boolean removed = this._undelMsgs.remove((Object)undelmsg);
        if (removed) {
            this.cleanupUndel(undelmsg);
        }
        return removed;
    }

    @Override
    public int deleteUndelLE(long mid, int batchsize) {
        IPSEUndelMsg msg;
        IndexIterator it = this.getUndelIterator();
        int ctDeleted = 0;
        while (it.hasNext() && (msg = (IPSEUndelMsg)it.next()).getMessageId() <= mid) {
            it.remove();
            this.cleanupUndel(msg);
            if (++ctDeleted != batchsize) continue;
            break;
        }
        return ctDeleted;
    }

    @Override
    public int deleteUndelAllNoCleanup(int maxTxnSize) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        int ctDeleted = 0;
        IndexIterator it = this.getUndelIterator();
        while (it.hasNext()) {
            it.advance();
            Long msgId = (Long)it.currentKey();
            IPSEUndelMsg undelMsg = null;
            try {
                undelMsg = (IPSEUndelMsg)it.currentValue();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            it.remove();
            if (undelMsg != null && !ObjectStore.isDestroyed((Object)undelMsg)) {
                ObjectStore.destroy((Object)undelMsg);
            }
            if (++ctDeleted < maxTxnSize) continue;
            break;
        }
        if (this.getUndelCount() == 0) {
            PSEClientUndelMsgs pSEClientUndelMsgs;
            if (((pSEClientUndelMsgs = this).ODIObjectState & 2) != 0) {
                pSEClientUndelMsgs = pSEClientUndelMsgs;
                ObjectStore.dirty((IPersistent)pSEClientUndelMsgs);
            }
            pSEClientUndelMsgs._totalSize = 0L;
        }
        return ctDeleted;
    }

    private void cleanupUndel(IPSEUndelMsg undelmsg) {
        try {
            if (this.ODIObjectState < 0) {
                ObjectStore.fetch((IPersistent)this);
            }
            this.updateTotalSize(-undelmsg.getMessageSize());
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
        boolean removed = false;
        try {
            IPSEMessage msg = undelmsg.getMessage();
            msg.removeRecipient(this._ClientId);
        }
        catch (ObjectStoreException objectStoreException) {
            // empty catch block
        }
        ObjectStore.destroy((Object)undelmsg);
    }

    @Override
    public long getMaxMessageId() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        long max = 0L;
        Long maxL = (Long)this._undelMsgs.getMaxPrimaryKey();
        if (maxL != null) {
            max = maxL;
        }
        return max;
    }

    @Override
    public void updateTotalSize(int size) {
        if ((this.ODIObjectState & 2) != 0) {
            ObjectStore.dirty((IPersistent)this);
        }
        this._totalSize += (long)size;
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        Iterator it = this._undelMsgs.iterator();
        while (it.hasNext()) {
            IPSEUndelMsg msg = (IPSEUndelMsg)it.next();
            it.remove();
            this.cleanupUndel(msg);
        }
        ObjectStore.destroy((IPersistent)this._undelMsgs);
    }

    @Override
    public IndexIterator getUndelIterator() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._undelMsgs.primaryIndexIterator();
    }

    @Override
    public IndexIterator getUndelIterator(long mid) {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (mid >= 0L) {
            return this._undelMsgs.primaryIndexIterator((Object)new Long(mid));
        }
        return this._undelMsgs.primaryIndexIterator();
    }

    @Override
    public int getUndelCount() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._undelMsgs.size();
    }

    @Override
    public long getUndelSize() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this._totalSize;
    }

    @Override
    public String toStringAll() {
        StringBuffer buf = new StringBuffer("PSEClientUndelMsgs: ");
        buf.append("\tCid: " + this.getClientId());
        buf.append("\tSize: " + this.getUndelSize());
        buf.append("\tUndelCount: " + this.getUndelCount());
        return buf.toString();
    }

    public String toString() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return "PSEClientUndelMsgs " + this._ClientId;
    }

    static {
        myOdiClassInfoInstance = PSEClientUndelMsgs.getClassInfoInstance();
        String msgClassName = "progress.message.dbsc.pse.pc.pubsub.PSEUndelMsg";
        try {
            msgClass = Class.forName(msgClassName);
        }
        catch (ClassNotFoundException cnfe) {
            new EAssertFailure("Class Not Found: " + msgClassName).printStackTrace();
        }
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectReference) {
        this.ODIref = objectReference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte by) {
        this.ODIObjectState = by;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        ((PSEClientUndelMsgs)super.clone()).ODIref = null;
        ((PSEClientUndelMsgs)super.clone()).ODIObjectState = 0;
        return (PSEClientUndelMsgs)super.clone();
    }

    public void postInitializeContents() {
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public void initializeContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        this._ClientId = genericObject.getLongField(1, classInfo);
        this._totalSize = genericObject.getLongField(2, classInfo);
        this._undelMsgs = (OSTreeSet)genericObject.getClassField(3, classInfo);
    }

    public void flushContents(GenericObject genericObject) {
        ClassInfo classInfo = myOdiClassInfoInstance;
        genericObject.setLongField(1, this._ClientId, classInfo);
        genericObject.setLongField(2, this._totalSize, classInfo);
        genericObject.setClassField(3, (Object)this._undelMsgs, classInfo);
    }

    public void clearContents() {
        this._ClientId = 0L;
        this._totalSize = 0L;
        this._undelMsgs = null;
    }

    public PSEClientUndelMsgs(ClassInfo classInfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        try {
            return ClassInfo.get(Class.forName("progress.message.dbsc.pse.pc.pubsub.PSEClientUndelMsgs"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

