/*
 * Decompiled with CFR 0.152.
 */
package progress.message.security;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import progress.message.broker.AgentSubjectSpace;
import progress.message.broker.SubjectAclEntry;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.security.SecurityBean;
import progress.message.security.SecurityCache;
import progress.message.security.SecurityEvent;
import progress.message.security.prAccessor;
import progress.message.zclient.ISubjectMatchObject;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPrincipal;
import progress.message.zclient.SessionConfig;

public final class NewAclEntryEvent
extends SecurityEvent {
    NewAclEntryEvent(SecurityBean source, long starttime, int vtime, String subject, SubjectAclEntry sae) {
        super(source, starttime, vtime);
        this.m_subject = subject;
        this.m_aclEntry = sae;
    }

    NewAclEntryEvent() {
    }

    @Override
    void callProcessMethod(SecurityCache cache) {
        cache.processNewAclEntryEvent(this);
    }

    @Override
    public void updateSubjectSpace(AgentSubjectSpace ss) {
        try {
            ss.put(this.m_subject, (ISubjectMatchObject)this.m_aclEntry);
        }
        catch (EInvalidSubjectSyntax e) {
            String mf41 = prAccessor.getString("STR089");
            Object[] ob41 = new Object[]{this.m_subject};
            SessionConfig.logMessage(MessageFormat.format(mf41, ob41), SessionConfig.getLevelWarning());
        }
        ss.resetCache();
    }

    @Override
    short getType() {
        return 3;
    }

    @Override
    void serialize(ObjectOutput out) throws IOException {
        super.serialize(out);
        out.writeUTF(this.m_subject);
        out.writeUTF(this.m_aclEntry.getPrincipal().getName());
        out.writeByte(this.m_aclEntry.getPosPermissions());
        out.writeByte(this.m_aclEntry.getNegPermissions());
    }

    @Override
    void unserialize(ObjectInput in, SecurityCache cache) throws IOException {
        super.unserialize(in, cache);
        this.m_subject = in.readUTF();
        String pname = in.readUTF();
        ProgressPrincipal p = cache.getPrincipal(pname);
        if (p == null) {
            p = new ProgressGroup(pname);
        }
        this.m_aclEntry = new SubjectAclEntry(p);
        this.m_aclEntry.setPermissions(in.readByte(), in.readByte());
    }
}

