/*
 * Decompiled with CFR 0.152.
 */
package progress.message.zclient;

import com.sonicsw.security.pass.client.ILogin;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.JMSSecurityException;
import progress.message.jimpl.JMSExceptionUtil;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.SonicCompressionFactory;
import progress.message.util.VersionData;
import progress.message.zclient.IPTPFlowControlHandler;
import progress.message.zclient.ISubject;
import progress.message.zclient.PTPFlowControlHandlerP27;
import progress.message.zclient.PTPFlowControlHandlerP28;
import progress.message.zclient.SubjectUtil;
import progress.message.zclient.Version;
import progress.message.zclient.prAccessor;
import progress.message.zclient.xonce.IOutboundContext;

public final class SessionConfig {
    public static boolean CONFIGURED = false;
    public static boolean DEBUG;
    public static boolean FLOW_DEBUG;
    public static String DEBUG_NAME;
    public static String DEBUG_CALLBACK;
    public static String DEBUG_FILTERS;
    public static final boolean DEBUG_PROXY = false;
    public static boolean IN_BROKER;
    public static boolean BROKER_EXITING;
    public static int PORT;
    public static String PKG;
    public static final byte SESSION_VER_OLD_23 = 23;
    public static final byte SESSION_VER = 32;
    public static final String PROVIDER_NAME = "SonicMQ/Java";
    public static final String RELEASE_NAME;
    public static final short MAJOR_VERSION = 12;
    public static final byte MINOR_VERSION = 0;
    public static final int BUILD_NUMBER = 116;
    private static final byte[] SUPPORTED_CLIENT_SESSION_VERS;
    private static final byte[] SUPPORTED_JMSCLIENT_SESSION_VERS;
    private static final byte[] SUPPORTED_CAA_SESSION_VERS;
    private static final byte[] SUPPORTED_IB_SESSION_VERS;
    public static final byte EARLIEST_GR_FC_NOTIFICATIONS_VERS = 32;
    public static final byte EARLIEST_IB_FC_NOTIFICATIONS_VERS = 31;
    public static final byte EARLIEST_CONNECT_PARMS_PDTINFO_VERS = 31;
    public static final byte EARLIEST_ASYNC_DELIVERY_VERSION = 30;
    public static final byte EARLIEST_DELIVERY_LIMIT_VER = 29;
    public static final byte EARLIEST_MULTITOPIC_VERSION = 28;
    public static final byte EARLIEST_NPFT_NON_DURABLE_VERSION = 28;
    public static final byte EARLIEST_FT_VERSION_SESSION_VERS = 27;
    public static final byte REVISED_FSN_VERSION_SESSION_VERS = 27;
    public static final byte EARLIEST_CONNECT_PARMS_VERSION_SESSION_VERS = 27;
    public static final byte EARLIEST_FLOW_TO_DISK_VER = 27;
    public static final byte EARLIEST_TUNNELING_ACK_MODE_VERSION = 26;
    public static final byte RELEASE_5_0_2_SESSION_VERSION = 26;
    public static final byte EARLIEST_REMOTE_PUBSUB_VERSION = 25;
    public static final byte EARLIEST_WILDCARD_ROUTES_VERSION = 25;
    public static final byte EARLIEST_TUNNELING_FLAGS_VERSION = 25;
    public static final byte EARLIEST_FSN_VERSION_SESSION_VERS = 25;
    public static final byte EARLIEST_CWADS_VERSION_SESSION_VERS = 25;
    public static final byte SELECTOR_AT_BROKER_SESSION_VERS = 24;
    public static final byte EARLIEST_OPEN_QUEUERECEIVER_OPTIMIZATION_VER = 24;
    public static final String RELEASE;
    public static final String RELEASE_BANNER;
    public static final int ABS_BROKER_DB_VERSION = 702000;
    public static final int REL_BROKER_DB_VERSION = 0;
    public static final int ABS_BROKER_DB_VERSION_SQL = 700000;
    private static final int[] UPGRADABLE_BROKER_DB_VERSIONS;
    public static final int UPGRADABLE_BROKER_DB_VERSION_SQL = 600001;
    public static final String APP_NAME;
    public static final String COPYRIGHT;
    public static final String ISYS = "$ISYS";
    public static final String SYS = "$SYS";
    public static final String QSYS = "$QSYS";
    public static final String USERS = "USERS";
    public static final String SONICMQ_SUBJ_PREFIX = "SonicMQ.";
    public static final String USERS_PREFIX = "$ISYS.USERS";
    public static final String ADMIN_PREFIX = "$ISYS.admin";
    public static final String ACCEPTOR_PREFIX = "$ISYS.acceptor";
    public static final int ISYS_SCODE;
    public static final int USERS_SCODE;
    public static final String JMS_CONNECTION_APPID_SUFFIX = "$CONNECTION$";
    public static final String JMS_SESSION_APPID_SUFFIX = "$SESSION$";
    public static final String JMS_QUEUE_RECEIVER_APPID_SUFFIX = "$QR$";
    public static final String JMS_QUEUE_BROWSER_APPID_SUFFIX = "$QB$";
    public static final String JMS_DURABLE_APPID_PREFIX = "$DURABLE$";
    public static final String JMS_GROUPSUBSCRIPTION_APPID_PREFIX = "$GROUPSUBSCRIPTION$";
    public static final String JMS_NONDURABLE_APPID_PREFIX = "$NONDURABLE$";
    public static final String JMS_TEMPORARY_QUEUE_APPID_SUFFIX = "TemporaryQueues";
    public static final String JMS_TEMPORARY_TOPIC_APPID_SUFFIX = "TemporaryTopics";
    public static final String JMS_CONNECTION_CONSUMER_APPID_SUFFIX = "$CC$";
    public static final String JMS_DURABLE_CC_APPID_SUFFIX = "$DURABLE$$CC$";
    public static final String JMS_TOPIC_CC_APPID_SUFFIX = "$CC$$TS$";
    public static final String JMS_QUEUE_CC_APPID_SUFFIX = "$CC$$QR$";
    public static final String MF_CONNECT_ID_PREFIX = "SonicMQ/mf/";
    public static final String JMS_SESSION_NAME_DEFAULT;
    public static final int JMS_SEND_TIMEOUT_DEFAULT;
    public static final String JMS_TEMPORARY_QUEUE_PREFIX = "$ISYS.USERS.TemporaryQueues";
    public static final String JMS_TEMPORARY_TOPIC_PREFIX = "$ISYS.USERS.TemporaryTopics";
    public static final String JMS_TEMPORARY_QUEUE_FULL_PREFIX = "$Q.$ISYS.USERS.TemporaryQueues";
    public static final String REPLY_OP = "reply";
    public static final int REPLY_SCODE = -1836570336;
    public static final String QOPCACHE_OP = "QopCache";
    public static final int QOPCACHE_SCODE = -434361444;
    public static final String SWIZZLE_OP = "Swizzle";
    public static final int SWIZZLE_SCODE = -54234532;
    public static final String REPLY_PREFIX = "$ISYS.USERS.reply";
    public static final String RNI_DLL_FILE = "ohmsbroker";
    public static final String JNI_DLL_FILE = "ohbroker";
    public static final String NETWARE_NLM_FILE = "broker";
    public static final String RootSubject = "$SonicMQ-Root-Subject";
    public static final String CONNECT_UNKNOWN_CODE;
    public static final String NOT_AVAILABLE;
    public static final String ARG_IS_NULL;
    public static final String NO_REQUEST;
    public static final String PARAM_IS_NULL;
    public static final String CANT_CONNECT_UNITOFWORK;
    public static final String CANT_DISCONNECT_UNITOFWORK;
    public static final String BAD_HOST_FORMAT;
    public static final String CONNECT_MAX_EXCEEDED;
    public static final String CONNECT_LOW_LEVEL_ERR;
    public static final String CONNECT_DROPPED;
    public static final String CONNECT_REJECTED;
    public static final String CONNECT_EXCEPTION;
    public static final String UNKNOWN_CODE;
    public static final String UNKNOWN_REQ_CODE;
    public static final String ERRMSG_TXN_ACC_VIOL;
    public static final String ERRMSG_TXN_SEQ_ERR;
    public static final String REQ_TIMEOUT;
    public static final String ADMIN_CLIENT_DEAD;
    public static final String INVALID_BEG_TXN_REPLY;
    public static final String SUB_REQ_ERROR;
    public static final String MALFORMED_EXCEPTION;
    public static final String IB_CONNECT_REFUSED;
    public static final String MSG_TOO_LARGE;
    public static final String MSG_BLOCKED_DUE_TO_FLOW_CONTROL;
    public static final String IP_ADDRESS_MAX_EXCEEDED;
    public static final String ERRMSG_QUEUE_NOT_FOUND;
    public static final String CLIENT_LANGUAGE = "us";
    public static final String CONNECT_RESPONSE_TIMEOUT_ATTR = "SonicMQ.CONNECT_RESPONSE_TIMEOUT";
    public static final int DISCONNECT_TIMEOUT = 30;
    public static final int CONNECT_RESPONSE_TIMEOUT;
    public static final int CONNECT_RESPONSE_TIMEOUT_DEFAULT = 20000;
    public static final int HTTP_PING_TIMEOUT;
    public static final String HTTP_SERVER_IDLE_TIMEOUT_ATTR = "HTTP_CLIENT_IDLE_TIMEOUT";
    public static final String HTTP_SERVER_CLIENT_READ_TIMEOUT_ATTR = "HTTP_CLIENT_READ_TIMEOUT";
    public static final int HTTP_REQUEST_SIZE = 4096;
    public static final short TXN_SUCCESS = 0;
    public static final short TXN_PARAM_ERR = 1;
    public static final short TXN_NOT_FOUND = 2;
    public static final short TXN_SEQ_ERR = 3;
    public static final short TXN_ABORT = 4;
    public static final short TXN_REQDATA_ERR = 5;
    public static final short TXN_ACC_VIOL = 6;
    public static final short TXN_INDEX_ALREADY_EXISTS = 7;
    public static final short TXN_DATABASE_EXCEPTION = 8;
    public static final short TXN_INVALID_DATA = 9;
    public static final short TXN_INDICES_NOT_SUPPORTED = 10;
    public static final short TXN_XA_DUPLICATE_XID = 11;
    public static final short TXN_XA_NO_XID = 12;
    public static final short TXN_INDEX_ACTIVE = 13;
    public static final short TXN_INDEX_COMPLETE = 14;
    public static final short TXN_RECORD_NOT_FOUND = 15;
    public static final String IN_DOUBT_TXN_SUBJ = "$SYS.TRANSACTION.IN-DOUBT";
    public static final String TXN_IDLE_TIMEOUT_SUBJ = "$SYS.TRANSACTION.IDLE_TIMEOUT";
    public static final int IN_DOUBT_TXT_SUBJ_QOP = 0;
    public static char defaultDOT;
    public static char defaultSINGLELEVEL;
    public static char defaultMULTILEVEL;
    public static final int ERROR_EXIT_CODE = 1;
    public static final int OUTPUT_BUFFER_SIZE = 250000;
    public static final int MIN_BUFFER_SIZE_PER_USER_PRIORITY = 5000;
    public static final int PRIORITY_OUTPUT_BUFFER_SIZE = 50000;
    public static final int INPUT_QUEUE_SIZE = 1000000;
    public static final int PRIORITY_INPUT_QUEUE_SIZE = 100000;
    public static final int FLOW_CONTROL_RESTART_THRESHOLD = 1000;
    private static int keyBits;
    public static final int DEFAULT_CLIENT_SUBJECT_CACHE = 8;
    public static final int MAX_CLIENT_SUBJECT_CACHE = 500;
    public static final String PROPERTY_DIAGNOSTIC_LEVEL = "messaging.diagnosticLevel";
    public static final int DEFAULT_DIAGNOSTIC_LEVEL = 0;
    public static final String PROPERTY_DEBUG_THREAD_NAME = "messaging.debugThreadName";
    public static boolean LOG_CONNECTION_DIAGNOSTICS;
    public static String LOGIN_SPI_CLASS_NAME;
    public static String KEY_STORE_CLASS;
    public static String REQUEST_TMP_APPID;
    public static String TMP_APPID_PREFIX;
    public static final String SOCKET_TCP_NO_DELAY_ATTR = "TCP_NODELAY";
    public static final boolean TCP_NODELAY;
    public static boolean DISABLE_NIO;
    public static final String TUNNELING_PROXY_PROTOCOL_ATTR = "TUNNELING_PROXY_PROTOCOL";
    public static final String TUNNELING_PROXY_HOST_ATTR = "TUNNELING_PROXY_HOST";
    public static final String TUNNELING_PROXY_PORT_ATTR = "TUNNELING_PROXY_PORT";
    public static final String PROXY_USER_NAME_ATTR = "PROXY_USER_NAME";
    public static final String PROXY_PASSWORD_ATTR = "PROXY_PASSWORD";
    public static final String HTTPS_PARAM_PROXY_AUTHENTICATION = "sonic.https.proxyAuthentication";
    public static final String HTTPS_PARAM_PROXY_USERNAME = "sonic.https.proxyUsername";
    public static final String HTTPS_PARAM_PROXY_PASSWORD = "sonic.https.proxyPassword";
    private static final String HTTPS_PARAM_PROXY_AUTHENTICATOR_DEPRECATED = "sonic.https.proxyAuthenticator";
    public static final String HTTPS_PARAM_PROXY_AUTHENTICATOR = "sonic.http.authenticator";
    public static final String HTTPS_PARAM_USE_ANY_HOSTNAME_VERIFIER = "sonic.https.useAnyHostnameVerifier";
    public static final String HTTPS_PARAM_HOSTNAME_VERIFIER = "sonic.https.hostnameVerifier";
    private static String TUNNELING_PROXY_HOST;
    private static int TUNNELING_PROXY_PORT;
    private static String TUNNELING_PROXY_USERNAME;
    private static String TUNNELING_PROXY_PASSWORD;
    public static String TCP_TUNNELING_PROXY_HOST;
    public static int TCP_TUNNELING_PROXY_PORT;
    public static String TCP_TUNNELING_PROXY_USERNAME;
    public static String TCP_TUNNELING_PROXY_PASSWORD;
    public static String SSL_TUNNELING_PROXY_HOST;
    public static int SSL_TUNNELING_PROXY_PORT;
    public static String SSL_TUNNELING_PROXY_USERNAME;
    public static String SSL_TUNNELING_PROXY_PASSWORD;
    public static String HTTP_PROXY_HOST;
    public static int HTTP_PROXY_PORT;
    public static String HTTP_PROXY_USERNAME;
    public static String HTTP_PROXY_PASSWORD;
    public static String HTTPS_TUNNELING_PROXY_HOST;
    public static int HTTPS_TUNNELING_PROXY_PORT;
    public static String HTTPS_TUNNELING_PROXY_USERNAME;
    public static String HTTPS_TUNNELING_PROXY_PASSWORD;
    public static String HTTPS_TUNNELING_PROXY_AUTHENTICATOR;
    public static String HTTPS_TUNNELING_PROXY_AUTHENTICATOR_DEPRECATED;
    public static boolean HTTPS_TUNNELING_PROXY_AUTHENTICATION;
    public static boolean HTTPS_TUNNELING_USE_ANY_HOSTNAME_VERIFIER;
    public static String HTTPS_TUNNELING_HOSTNAME_VERIFIER;
    public static final boolean USE_EVS_IO;
    public static final boolean USE_EVS_HTTP;
    public static final boolean USE_EVS_BLOCKING;
    public static final boolean USE_EVS_BLOCKING_HTTP_CLIENT;
    public static final String USE_LEGACY_HTTP_SERVER_ATTR = "USE_LEGACY_HTTP_SERVER";
    public static final boolean DIAG_MGRAM_HISTORY;
    public static final String CAPTURE_BUFFER_FILTER;
    public static final int SENDER_CAPTURE_BUFFER_SIZE;
    public static final int LISTENER_CAPTURE_BUFFER_SIZE;
    public static final boolean DBCLEANER_ASSERTION_RECOVERY;
    private static final HashMap s_cbFilters;
    public static final int IO_SECURITY_BUFFER_SIZE;
    public static final String MAX_SEND_IO_BUFFER_SIZE_ATTR = "MAX_SEND_IO_BUFFER_SIZE";
    public static final String MIN_SEND_IO_BUFFER_SIZE_ATTR = "MIN_SEND_IO_BUFFER_SIZE";
    public static final String INITIAL_SEND_IO_BUFFER_SIZE_ATTR = "INITIAL_SEND_IO_BUFFER_SIZE";
    public static final String MAX_RCV_IO_BUFFER_SIZE_ATTR = "MAX_RCV_IO_BUFFER_SIZE";
    public static final String MIN_RCV_IO_BUFFER_SIZE_ATTR = "MIN_RCV_IO_BUFFER_SIZE";
    public static final String INITIAL_RCV_IO_BUFFER_SIZE_ATTR = "INITIAL_RCV_IO_BUFFER_SIZE";
    public static final String HTTP_MAX_SEND_IO_BUFFER_SIZE_ATTR = "HTTP_MAX_SEND_IO_BUFFER_SIZE";
    public static final String HTTP_MIN_SEND_IO_BUFFER_SIZE_ATTR = "HTTP_MIN_SEND_IO_BUFFER_SIZE";
    public static final String HTTP_INITIAL_SEND_IO_BUFFER_SIZE_ATTR = "HTTP_INITIAL_SEND_IO_BUFFER_SIZE";
    public static final String HTTP_MAX_RCV_IO_BUFFER_SIZE_ATTR = "HTTP_MAX_RCV_IO_BUFFER_SIZE";
    public static final String HTTP_MIN_RCV_IO_BUFFER_SIZE_ATTR = "HTTP_MIN_RCV_IO_BUFFER_SIZE";
    public static final String HTTP_INITIAL_RCV_IO_BUFFER_SIZE_ATTR = "HTTP_INITIAL_RCV_IO_BUFFER_SIZE";
    public static final String SOCKET_MAX_SEND_BUFFER_SIZE_ATTR = "SOCKET_MAX_SEND_BUFFER_SIZE";
    public static final String SOCKET_MIN_SEND_BUFFER_SIZE_ATTR = "SOCKET_MIN_SEND_BUFFER_SIZE";
    public static final String SOCKET_INITIAL_SEND_BUFFER_SIZE_ATTR = "SOCKET_INITIAL_SEND_BUFFER_SIZE";
    public static final String SOCKET_MAX_RCV_BUFFER_SIZE_ATTR = "SOCKET_MAX_RCV_BUFFER_SIZE";
    public static final String SOCKET_MIN_RCV_BUFFER_SIZE_ATTR = "SOCKET_MIN_RCV_BUFFER_SIZE";
    public static final String SOCKET_INITIAL_RCV_BUFFER_SIZE_ATTR = "SOCKET_INITIAL_RCV_BUFFER_SIZE";
    public static final int MAX_SEND_IO_BUFFER_SIZE;
    public static final int MIN_SEND_IO_BUFFER_SIZE;
    public static final int INITIAL_SEND_IO_BUFFER_SIZE;
    public static final int MAX_RCV_IO_BUFFER_SIZE;
    public static final int MIN_RCV_IO_BUFFER_SIZE;
    public static final int INITIAL_RCV_IO_BUFFER_SIZE;
    public static final int HTTP_MAX_SEND_IO_BUFFER_SIZE;
    public static final int HTTP_MIN_SEND_IO_BUFFER_SIZE;
    public static final int HTTP_INITIAL_SEND_IO_BUFFER_SIZE;
    public static final int HTTP_MAX_RCV_IO_BUFFER_SIZE;
    public static final int HTTP_MIN_RCV_IO_BUFFER_SIZE;
    public static final int HTTP_INITIAL_RCV_IO_BUFFER_SIZE;
    public static final int SOCKET_MAX_SEND_BUFFER_SIZE;
    public static final int SOCKET_MIN_SEND_BUFFER_SIZE;
    public static int SOCKET_INITIAL_SEND_BUFFER_SIZE;
    public static int SOCKET_MAX_RCV_BUFFER_SIZE;
    public static int SOCKET_MIN_RCV_BUFFER_SIZE;
    public static int SOCKET_INITIAL_RCV_BUFFER_SIZE;
    public static final int HTTP_SOCKET_MAX_SEND_BUFFER_SIZE;
    public static final int HTTP_SOCKET_MIN_SEND_BUFFER_SIZE;
    public static int HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE;
    public static int HTTP_SOCKET_MAX_RCV_BUFFER_SIZE;
    public static int HTTP_SOCKET_MIN_RCV_BUFFER_SIZE;
    public static int HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE;
    public static final int HTTP_CONNECT_TIMEOUT;
    public static final int HTTP_CLOSE_TIMEOUT;
    public static long CLIENT_SEND_DELAY;
    public static boolean FT_SYNC_PING;
    public static int MAX_MSG_SIZE_BROKER_DEFAULT;
    public static int MAX_MSG_SIZE;
    public static int DEFAULT_CHANNEL_TIMEOUT;
    public static int DEFAULT_RETRY_INTERVAL;
    public static int DEFAULT_RETRY_COUNT;
    public static int DEFAULT_WINDOW_SIZE;
    public static int DEFAULT_FRAGMENT_SIZE;
    public static final Integer UNKNOWN;
    public static final Integer SEVERE;
    public static final Integer WARNING;
    public static final Integer INFO;
    public static final Integer CONFIG;
    public static final Integer FINE;
    public static final Integer FINER;
    public static final Integer FINEST;
    public static final Integer TRACE;
    public static final int BROKER_SPECIFIED_CLIENT_FC_MONITOR_INTERVAL = -1;
    public static final int BROKER_SPECIFIED_CLIENT_FC_MONITOR_INTERVAL_NOT_SUPPORTED = -999;
    public static final int DIRECTED_SUBJ_NUM_LEVELS = 7;
    public static final int DIRECTED_ADDR_LENGTH = 30;
    public static final int DIRECTED_SUBJ_UID_LEVEL = 3;
    public static final int DIRECTED_SUBJ_APPID_LEVEL = 4;
    public static final int DIRECTED_SUBJ_COLLECTIVE_LEVEL = 5;
    public static final int DIRECTED_SUBJ_BROKER_LEVEL = 6;
    public static final int DIRECTED_SUBJ_OP_LEVEL = 2;
    public static final int ADMIN_PREFIX_UID_LEVEL = 2;
    public static final int ADMIN_PREFIX_APPID_LEVEL = 3;
    public static String ACL_RESOURCE_TOPIC;
    public static String ACL_RESOURCE_QUEUE;
    public static String ACL_RESOURCE_NODE;
    public static String ACL_RESOURCE_URL;
    public static String ROUTING_ROOT;
    public static String HTTP_ROOT;
    public static String HTTPS_ROOT;
    public static String TOPIC_ROOT;
    public static String QUEUE_ROOT;
    public static String SONIC_HTTP;
    public static final int LG_NODE_TYPE_DEFAULT = -1;
    public static final int LG_NODE_TYPE_JMS = 1;
    public static final String COMPRESSION_FACTORY;
    public static final int DBLIMIT_EXCEPTIONS_OFF = 0;
    public static final int DBLIMIT_EXCEPTIONS_ON = 1;
    public static final int DBLIMIT_EXCEPTIONS_USE_BROKER_SETTING = 2;

    public static boolean isClientSessionVersionSupported(byte clientVersion) {
        return SessionConfig.arrayContains(SUPPORTED_CLIENT_SESSION_VERS, clientVersion);
    }

    public static byte getLatestSupportedClientSessionVers() {
        return SUPPORTED_CLIENT_SESSION_VERS[SUPPORTED_CLIENT_SESSION_VERS.length - 1];
    }

    public static final boolean isJmsClientSessionVersSupported(byte version) {
        return SessionConfig.arrayContains(SUPPORTED_JMSCLIENT_SESSION_VERS, version);
    }

    public static boolean isCAASessionVersionSupported(byte version) {
        return SessionConfig.arrayContains(SUPPORTED_CAA_SESSION_VERS, version);
    }

    public static byte getLatestSupportedCAASessionVers() {
        return SUPPORTED_CAA_SESSION_VERS[SUPPORTED_CAA_SESSION_VERS.length - 1];
    }

    public static boolean isIBSessionVersionSupported(byte version) {
        return SessionConfig.arrayContains(SUPPORTED_IB_SESSION_VERS, version);
    }

    public static byte getLatestSupportedIBSessionVers() {
        return SUPPORTED_IB_SESSION_VERS[SUPPORTED_IB_SESSION_VERS.length - 1];
    }

    private static boolean arrayContains(byte[] array, byte value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private static boolean arrayContains(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean isBrokerDBVersionUpgradable(int vers) {
        return SessionConfig.arrayContains(UPGRADABLE_BROKER_DB_VERSIONS, vers);
    }

    public static boolean isFlowToDiskSupported(String appid) {
        return appid.indexOf(JMS_NONDURABLE_APPID_PREFIX) > -1 || appid.indexOf(JMS_DURABLE_APPID_PREFIX) > -1 || appid.indexOf(JMS_DURABLE_CC_APPID_SUFFIX) > -1 || appid.indexOf(JMS_TOPIC_CC_APPID_SUFFIX) > -1 || appid.indexOf(JMS_GROUPSUBSCRIPTION_APPID_PREFIX) > -1;
    }

    public static boolean isNonDurableSubscriber(String appid) {
        return appid.indexOf(JMS_NONDURABLE_APPID_PREFIX) > -1 || appid.indexOf(JMS_TOPIC_CC_APPID_SUFFIX) > -1;
    }

    public static boolean isGroupSubscriptionAppid(String appid) {
        return appid.indexOf(JMS_GROUPSUBSCRIPTION_APPID_PREFIX) > -1;
    }

    public static final boolean matchCaptureFilterToUidAppid(String uid, String appid) {
        if (s_cbFilters == null) {
            return true;
        }
        if (SessionConfig.matchCaptureFilter(uid, (List)s_cbFilters.get("uid")) || SessionConfig.matchCaptureFilter(appid, (List)s_cbFilters.get("appid"))) {
            SessionConfig.logMessage("Matched capture filter for: " + uid + "/" + appid, INFO);
            return true;
        }
        return false;
    }

    private static boolean matchCaptureFilter(String match, List filters) {
        if (filters == null || match == null) {
            return false;
        }
        for (String filter : filters) {
            if (match.indexOf(filter) < 0) continue;
            return true;
        }
        return false;
    }

    public static final synchronized void initTCPProxySetting() {
        TCP_TUNNELING_PROXY_HOST = SessionConfig.getProperty("tcp.proxyHost", "").trim();
        if (TCP_TUNNELING_PROXY_HOST.length() > 0) {
            TCP_TUNNELING_PROXY_PORT = SessionConfig.getIntProperty("tcp.proxyPort", -1);
            if (TCP_TUNNELING_PROXY_PORT < 0) {
                SessionConfig.logln("tcp.proxyPort - Invalid optional property \"" + TCP_TUNNELING_PROXY_PORT + "\"");
                TCP_TUNNELING_PROXY_HOST = null;
            }
            TCP_TUNNELING_PROXY_USERNAME = SessionConfig.getProperty("sonic.tcp.proxyUsername", null);
            TCP_TUNNELING_PROXY_PASSWORD = SessionConfig.getProperty("sonic.tcp.proxyPassword", null);
        } else {
            TCP_TUNNELING_PROXY_HOST = TUNNELING_PROXY_HOST;
            TCP_TUNNELING_PROXY_PORT = TUNNELING_PROXY_PORT;
            TCP_TUNNELING_PROXY_USERNAME = TUNNELING_PROXY_USERNAME;
            TCP_TUNNELING_PROXY_PASSWORD = TUNNELING_PROXY_PASSWORD;
        }
    }

    public static final synchronized void initSSLProxySetting() {
        SSL_TUNNELING_PROXY_HOST = SessionConfig.getProperty("ssl.proxyHost", "").trim();
        if (SSL_TUNNELING_PROXY_HOST.length() > 0) {
            SSL_TUNNELING_PROXY_PORT = SessionConfig.getIntProperty("ssl.proxyPort", -1);
            if (SSL_TUNNELING_PROXY_PORT < 0) {
                SessionConfig.logln("ssl.proxyPort - Invalid optional property \"" + SSL_TUNNELING_PROXY_PORT + "\"");
                SSL_TUNNELING_PROXY_HOST = null;
            }
            SSL_TUNNELING_PROXY_USERNAME = SessionConfig.getProperty("sonic.ssl.proxyUsername", null);
            SSL_TUNNELING_PROXY_PASSWORD = SessionConfig.getProperty("sonic.ssl.proxyPassword", null);
        } else {
            SSL_TUNNELING_PROXY_HOST = TUNNELING_PROXY_HOST;
            SSL_TUNNELING_PROXY_PORT = TUNNELING_PROXY_PORT;
            SSL_TUNNELING_PROXY_USERNAME = TUNNELING_PROXY_USERNAME;
            SSL_TUNNELING_PROXY_PASSWORD = TUNNELING_PROXY_PASSWORD;
        }
    }

    public static final synchronized void initHTTPProxySetting() {
        HTTP_PROXY_HOST = SessionConfig.getProperty("http.proxyHost", "").trim();
        if (HTTP_PROXY_HOST.length() > 0) {
            HTTP_PROXY_PORT = SessionConfig.getIntProperty("http.proxyPort", -1);
            if (HTTP_PROXY_PORT < 0) {
                SessionConfig.logln("http.proxyPort - Invalid optional property \"" + HTTP_PROXY_PORT + "\"");
                HTTP_PROXY_HOST = null;
            }
            HTTP_PROXY_USERNAME = SessionConfig.getProperty("sonic.http.proxyUsername", null);
            HTTP_PROXY_PASSWORD = SessionConfig.getProperty("sonic.http.proxyPassword", null);
        } else {
            HTTP_PROXY_HOST = null;
        }
    }

    public static final synchronized void initHTTPSProxySetting() {
        HTTPS_TUNNELING_PROXY_HOST = SessionConfig.getProperty("https.proxyHost", "").trim();
        if (HTTPS_TUNNELING_PROXY_HOST.length() > 0) {
            HTTPS_TUNNELING_PROXY_PORT = SessionConfig.getIntProperty("https.proxyPort", -1);
            if (HTTPS_TUNNELING_PROXY_PORT < 0) {
                SessionConfig.logln("https.proxyPort - Invalid optional property \"" + HTTPS_TUNNELING_PROXY_PORT + "\"");
                HTTPS_TUNNELING_PROXY_HOST = null;
            }
            HTTPS_TUNNELING_PROXY_USERNAME = SessionConfig.getProperty(HTTPS_PARAM_PROXY_USERNAME, null);
            HTTPS_TUNNELING_PROXY_PASSWORD = SessionConfig.getProperty(HTTPS_PARAM_PROXY_PASSWORD, null);
            HTTPS_TUNNELING_PROXY_AUTHENTICATION = "true".equalsIgnoreCase(SessionConfig.getProperty(HTTPS_PARAM_PROXY_AUTHENTICATION, "false").trim());
            HTTPS_TUNNELING_PROXY_AUTHENTICATOR = SessionConfig.getProperty(HTTPS_PARAM_PROXY_AUTHENTICATOR, null);
            HTTPS_TUNNELING_PROXY_AUTHENTICATOR_DEPRECATED = SessionConfig.getProperty(HTTPS_PARAM_PROXY_AUTHENTICATOR_DEPRECATED, null);
            HTTPS_TUNNELING_USE_ANY_HOSTNAME_VERIFIER = "true".equalsIgnoreCase(SessionConfig.getProperty(HTTPS_PARAM_USE_ANY_HOSTNAME_VERIFIER, "false").trim());
            HTTPS_TUNNELING_HOSTNAME_VERIFIER = SessionConfig.getProperty(HTTPS_PARAM_HOSTNAME_VERIFIER, null);
        } else {
            HTTPS_TUNNELING_PROXY_HOST = TUNNELING_PROXY_HOST;
            HTTPS_TUNNELING_PROXY_PORT = TUNNELING_PROXY_PORT;
            HTTPS_TUNNELING_PROXY_USERNAME = TUNNELING_PROXY_USERNAME;
            HTTPS_TUNNELING_PROXY_PASSWORD = TUNNELING_PROXY_PASSWORD;
        }
    }

    public static PrintStream getLog() {
        return System.out;
    }

    public static void log(String s) {
        SessionConfig.getLog().print(s);
        SessionConfig.getLog().flush();
    }

    public static void logln(String s) {
        SessionConfig.getLog().println(s);
    }

    public static final long stringToClientId(String uid, String appid) {
        return (long)SubjectUtil.computeSCode(appid, 0, appid.length()) << 32 | (long)SubjectUtil.computeSCode(uid, 0, uid.length()) & 0xFFFFFFFFL;
    }

    public static final void logMessage(String s, Integer errorLevel) {
        if (s == null || errorLevel == null) {
            return;
        }
        if (IN_BROKER) {
            try {
                if (LoggerClassHolder.LOGGER_CLASS == null) {
                    SessionConfig.logln(s);
                    return;
                }
                if (LoggerMethodLazyHolder.LOGGER_METHOD == null) {
                    SessionConfig.logln(s);
                    return;
                }
                Object[] args = new Object[]{s, errorLevel};
                LoggerMethodLazyHolder.LOGGER_METHOD.invoke((Object)LoggerClassHolder.LOGGER_CLASS, args);
            }
            catch (IllegalAccessException iae) {
                SessionConfig.logln(s);
            }
            catch (InvocationTargetException ite) {
                SessionConfig.logln(s);
            }
        } else {
            SessionConfig.logln(s);
        }
    }

    public static final void logMessage(String s, Throwable t, Integer errorLevel) {
        if (s == null || t == null || errorLevel == null) {
            return;
        }
        if (IN_BROKER) {
            try {
                Class[] parameters = new Class[]{String.class, Throwable.class, Integer.class};
                Object[] args = new Object[]{s, t, errorLevel};
                SessionConfig.logMessage(parameters, args);
            }
            catch (ClassNotFoundException cnfe) {
                SessionConfig.logln(s + " " + t.toString());
                t.printStackTrace();
            }
            catch (NoSuchMethodException nsme) {
                SessionConfig.logln(s + " " + t.toString());
                t.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                SessionConfig.logln(s + " " + t.toString());
                t.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                SessionConfig.logln(s + " " + t.toString());
                t.printStackTrace();
            }
        } else {
            SessionConfig.logln(s + " " + t.toString());
            t.printStackTrace();
        }
    }

    public static final void logMessage(Throwable t, Integer errorLevel) {
        if (t == null || errorLevel == null) {
            return;
        }
        if (IN_BROKER) {
            try {
                Class[] parameters = new Class[]{Throwable.class, Integer.class};
                Object[] args = new Object[]{t, errorLevel};
                SessionConfig.logMessage(parameters, args);
            }
            catch (ClassNotFoundException cnfe) {
                SessionConfig.logln(t.toString());
                t.printStackTrace();
            }
            catch (NoSuchMethodException nsme) {
                SessionConfig.logln(t.toString());
                t.printStackTrace();
            }
            catch (IllegalAccessException iae) {
                SessionConfig.logln(t.toString());
                t.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                SessionConfig.logln(t.toString());
                t.printStackTrace();
            }
        } else {
            SessionConfig.logln(t.toString());
            t.printStackTrace();
        }
    }

    public static final Integer getLevelUnknown() {
        return LoggerLevelsHolder.LEVEL_UNKNOWN;
    }

    public static final Integer getLevelSevere() {
        return LoggerLevelsHolder.LEVEL_SEVERE;
    }

    public static final Integer getLevelWarning() {
        return LoggerLevelsHolder.LEVEL_WARNING;
    }

    public static final Integer getLevelInfo() {
        return LoggerLevelsHolder.LEVEL_INFO;
    }

    public static final Integer getLevelConfig() {
        return LoggerLevelsHolder.LEVEL_CONFIG;
    }

    public static final Integer getLevelFine() {
        return LoggerLevelsHolder.LEVEL_FINE;
    }

    public static final Integer getLevelFiner() {
        return LoggerLevelsHolder.LEVEL_FINER;
    }

    public static final Integer getLevelFinest() {
        return LoggerLevelsHolder.LEVEL_FINEST;
    }

    public static final String getAdminPrefix(String user_id, String application_id) {
        return "$ISYS.admin." + user_id + "." + application_id;
    }

    public static final String getUserAdminPrefix(String user_id, String application_id) {
        return "$SYS.admin." + user_id + "." + application_id;
    }

    public static final String getUidFromAdminSubject(ISubject sub) {
        String admin = sub.getSubjectString();
        int plen = ADMIN_PREFIX.length() + 1;
        return admin.substring(plen, admin.indexOf(".", plen));
    }

    public static final String getAppidFromAdminSubject(ISubject sub) {
        String admin = sub.getSubjectString();
        int plen = ADMIN_PREFIX.length() + 1 + SessionConfig.getUidFromAdminSubject(sub).length() + 1;
        return admin.substring(plen, admin.indexOf(".", plen));
    }

    public static final String getClientPrefix() {
        return "$SYS.client.";
    }

    public static final boolean isSystemSubject(String subject) {
        return subject.startsWith(SYS) || subject.startsWith(ISYS) || subject.startsWith(QSYS);
    }

    public static final boolean isSystemSubject(ISubject subject) {
        return subject.isAnySystem();
    }

    public static boolean isJMSSession(String appid) {
        return appid != null && appid.indexOf(JMS_SESSION_APPID_SUFFIX) >= 0;
    }

    public static String getConnectIDFromSessionAppID(String appid) {
        if (appid == null || appid.indexOf(JMS_SESSION_APPID_SUFFIX) < 0) {
            throw new IllegalArgumentException(appid + " not a session appid");
        }
        return appid.substring(0, appid.lastIndexOf(JMS_SESSION_APPID_SUFFIX));
    }

    public static String getConnectIDFromSubscriberAppid(String appid) {
        if (appid == null || appid.indexOf(JMS_NONDURABLE_APPID_PREFIX) < 0) {
            throw new IllegalArgumentException(appid + " not a nondurable subscriber appid");
        }
        return appid.substring(0, appid.lastIndexOf(JMS_NONDURABLE_APPID_PREFIX));
    }

    public static String getConnectIDFromQueueReceiverAppid(String appid) {
        if (appid == null || appid.indexOf(JMS_QUEUE_RECEIVER_APPID_SUFFIX) < 0) {
            throw new IllegalArgumentException(appid + " not a queue receiver subscriber appid");
        }
        return appid.substring(0, appid.indexOf(JMS_QUEUE_RECEIVER_APPID_SUFFIX));
    }

    public static String getDurableSubNameFromAppid(String appid) {
        String str = SessionConfig.getJMSClientId(appid);
        String subNm = str.substring(str.indexOf("$") + 1);
        return subNm;
    }

    public static String getDurableJMSClientIDFromAppid(String appid) {
        String str = SessionConfig.getJMSClientId(appid);
        String jmsClientID = str.substring(0, str.indexOf("$"));
        return jmsClientID;
    }

    private static String getJMSClientId(String appid) {
        if (appid == null || appid.indexOf(JMS_DURABLE_APPID_PREFIX) < 0) {
            throw new IllegalArgumentException(appid + " not a durable subscriber appid");
        }
        String str = appid.substring(9);
        if (str.startsWith(JMS_CONNECTION_CONSUMER_APPID_SUFFIX)) {
            str = str.substring(JMS_CONNECTION_CONSUMER_APPID_SUFFIX.length());
        }
        return str;
    }

    public static String createDurableAppid(String clientId, String name, boolean isConnectionConsumer) {
        String namePrime = SessionConfig.primeDurableName(name);
        String clientIdStr = clientId == null ? "" : clientId;
        String appId = isConnectionConsumer ? JMS_DURABLE_CC_APPID_SUFFIX + clientIdStr + "$" + namePrime : JMS_DURABLE_APPID_PREFIX + clientIdStr + "$" + namePrime;
        return appId;
    }

    public static final IPTPFlowControlHandler createPTPFlowControlHandler(IOutboundContext oc) {
        if (oc.getPeerSessionVer() < 28) {
            return new PTPFlowControlHandlerP27(oc.getFlowControllableOutputQueue(), oc);
        }
        return new PTPFlowControlHandlerP28(oc.getFlowControllableOutputQueue(), oc);
    }

    private static String primeDurableName(String name) {
        StringBuffer stringBufferPrime = new StringBuffer();
        String stringPrime = null;
        block3: for (int i = 0; i < name.length(); ++i) {
            switch (name.charAt(i)) {
                case '#': 
                case '*': 
                case '.': {
                    stringBufferPrime.append("@@@");
                    continue block3;
                }
                default: {
                    stringBufferPrime.append(name.charAt(i));
                }
            }
        }
        stringPrime = stringBufferPrime.toString();
        return stringPrime;
    }

    public static final ILogin createILoginInstance(String loginClassName) throws JMSSecurityException {
        if (loginClassName != null && loginClassName.trim().length() > 0) {
            try {
                Class<?> c = Class.forName(loginClassName);
                return (ILogin)c.newInstance();
            }
            catch (ClassCastException e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("CLASS_CAST_ERROR") + "com.sonicsw.security.pass.client.ILogin", -2001, e);
            }
            catch (ClassNotFoundException e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("CLASS_NOT_FOUND"), -2000, e);
            }
            catch (InstantiationException e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("CANNOT_INST_CLASS"), -2002, e);
            }
            catch (IllegalAccessException e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("ACCESS_ERROR"), -2003, e);
            }
            catch (SecurityException e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("SECURITY_ERROR"), -2006, e);
            }
            catch (Exception e) {
                throw JMSExceptionUtil.createJMSSecurityException("Login SPI" + progress.message.client.prAccessor.getString("LOAD_CLASS_FAILED"), -1, e);
            }
        }
        return null;
    }

    public static final String getDirectedSubject(String uid, String appid, String collective, String broker, String operation) {
        return "$ISYS.USERS." + operation + "." + uid + "." + appid + "." + collective + "." + broker;
    }

    public static final String getDirectedSubjectPrefix(String operation) {
        return "$ISYS.USERS." + operation;
    }

    public static void sessionLoadConfig() {
        defaultDOT = (char)46;
        defaultSINGLELEVEL = (char)42;
        defaultMULTILEVEL = (char)35;
        PORT = 2506;
        DEBUG = false;
        CONFIGURED = false;
    }

    public static int getKeyBits() {
        return keyBits;
    }

    public static void setMaxMsgSize(int size) {
        if (size <= 0) {
            MAX_MSG_SIZE = -1;
        } else if ((long)size * 0x100000L >= Integer.MAX_VALUE) {
            SessionConfig.logln("MAX_MSG_SIZE of " + size + "(Mb) is too large, the setting will be ignored.");
            MAX_MSG_SIZE = -1;
        } else {
            MAX_MSG_SIZE = size * 0x100000;
        }
    }

    public static String buildReleaseName(String relName, String buildNum) {
        return prMessageFormat.format(prAccessor.getString("STR999"), new Object[]{relName, buildNum});
    }

    private static final String getProperty(String propName, String defValue) {
        String s = null;
        try {
            s = System.getProperty(propName);
            if (s == null) {
                return defValue;
            }
            return s;
        }
        catch (SecurityException e) {
            SessionConfig.logln(propName + " - Invalid optional property; permission denied");
            return defValue;
        }
    }

    private static final int getIntProperty(String propName, int defValue) {
        String s = null;
        try {
            s = System.getProperty(propName);
            if (s == null) {
                return defValue;
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e1) {
            SessionConfig.logln(propName + " - Invalid optional property \"" + s + "\"");
        }
        catch (SecurityException e) {
            SessionConfig.logln(propName + " - Invalid optional property; permission denied");
        }
        return defValue;
    }

    private static final boolean getBooleanProperty(String propName, boolean defValue) {
        String s = null;
        try {
            s = System.getProperty(propName);
            if (s == null) {
                return defValue;
            }
            return new Boolean(s);
        }
        catch (SecurityException e) {
            SessionConfig.logln(propName + " - Invalid optional property; permission denied");
            return defValue;
        }
    }

    public static VersionData getCurrentVersionData() {
        return new VersionData(PROVIDER_NAME, 12, 0, 9, 116);
    }

    private static void logMessage(Class[] parameters, Object[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> c = Class.forName("com.sonicsw.mq.components.BrokerComponent");
        String methodName = "logMessage";
        Method m = c.getMethod(methodName, parameters);
        m.invoke(c, args);
    }

    private static final Integer getLevel(String methodName, Integer defaultLevel) {
        if (IN_BROKER) {
            try {
                Class<?>[] parameters = null;
                Method m = LoggerClassHolder.LOGGER_CLASS.getMethod(methodName, parameters);
                Object[] args = null;
                return (Integer)m.invoke((Object)LoggerClassHolder.LOGGER_CLASS, args);
            }
            catch (Exception e) {
                return defaultLevel;
            }
        }
        return defaultLevel;
    }

    static /* synthetic */ Integer access$100(String x0, Integer x1) {
        return SessionConfig.getLevel(x0, x1);
    }

    static {
        FLOW_DEBUG = false;
        IN_BROKER = false;
        BROKER_EXITING = false;
        PKG = "progress.message.client";
        RELEASE_NAME = Version.RELEASE_NAME;
        SUPPORTED_CLIENT_SESSION_VERS = new byte[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
        SUPPORTED_JMSCLIENT_SESSION_VERS = new byte[]{28, 29, 30, 31, 32};
        SUPPORTED_CAA_SESSION_VERS = new byte[]{28, 29, 30, 31, 32};
        SUPPORTED_IB_SESSION_VERS = new byte[]{28, 29, 30, 31, 32};
        RELEASE = prMessageFormat.format(prAccessor.getString("STR142"), new Object[]{Short.toString((short)12), Byte.toString((byte)0), Integer.toString(116)});
        RELEASE_BANNER = prMessageFormat.format(prAccessor.getString("STR999"), new Object[]{RELEASE_NAME, Integer.toString(116)});
        UPGRADABLE_BROKER_DB_VERSIONS = new int[]{600001, 700000};
        APP_NAME = prAccessor.getString("STR143");
        COPYRIGHT = prAccessor.getString("STR144");
        ISYS_SCODE = SubjectUtil.computeSCode(ISYS, 0, ISYS.length());
        USERS_SCODE = SubjectUtil.computeSCode(USERS, 0, USERS.length());
        JMS_SESSION_NAME_DEFAULT = System.getProperty("SonicMQ.DEFAULT_SESSION_NAME");
        JMS_SEND_TIMEOUT_DEFAULT = Integer.getInteger("SonicMQ.DEFAULT_SEND_TIMEOUT", 0);
        CONNECT_UNKNOWN_CODE = prAccessor.getString("STR145");
        NOT_AVAILABLE = prAccessor.getString("STR146");
        ARG_IS_NULL = prAccessor.getString("STR148");
        NO_REQUEST = prAccessor.getString("STR149");
        PARAM_IS_NULL = prAccessor.getString("STR150");
        CANT_CONNECT_UNITOFWORK = prAccessor.getString("STR151");
        CANT_DISCONNECT_UNITOFWORK = prAccessor.getString("STR152");
        BAD_HOST_FORMAT = prAccessor.getString("STR153");
        CONNECT_MAX_EXCEEDED = prAccessor.getString("STR154");
        CONNECT_LOW_LEVEL_ERR = prAccessor.getString("STR155");
        CONNECT_DROPPED = prAccessor.getString("STR156");
        CONNECT_REJECTED = prAccessor.getString("CONNECT_REJECTED");
        CONNECT_EXCEPTION = prAccessor.getString("STR157");
        UNKNOWN_CODE = prAccessor.getString("STR158");
        UNKNOWN_REQ_CODE = prAccessor.getString("STR159");
        ERRMSG_TXN_ACC_VIOL = prAccessor.getString("STR160");
        ERRMSG_TXN_SEQ_ERR = prAccessor.getString("STR161");
        REQ_TIMEOUT = prAccessor.getString("STR162");
        ADMIN_CLIENT_DEAD = prAccessor.getString("STR163");
        INVALID_BEG_TXN_REPLY = prAccessor.getString("STR164");
        SUB_REQ_ERROR = prAccessor.getString("STR165");
        MALFORMED_EXCEPTION = prAccessor.getString("STR166");
        IB_CONNECT_REFUSED = prAccessor.getString("STR167");
        MSG_TOO_LARGE = prAccessor.getString("MSG_TOO_LARGE");
        MSG_BLOCKED_DUE_TO_FLOW_CONTROL = prAccessor.getString("QUEUE_DEST_BLOCKED");
        IP_ADDRESS_MAX_EXCEEDED = prAccessor.getString("IPAddressLimitExceeded");
        ERRMSG_QUEUE_NOT_FOUND = prAccessor.getString("STR178");
        String s = null;
        int timeout = 20000;
        try {
            s = System.getProperty(CONNECT_RESPONSE_TIMEOUT_ATTR);
            if (s != null) {
                int t = Integer.parseInt(s);
                if (t >= 0) {
                    timeout = t;
                } else {
                    SessionConfig.logln("Invalid value for SonicMQ.CONNECT_RESPONSE_TIMEOUT,must be greater than or equal to 0: " + s);
                }
            }
        }
        catch (NumberFormatException e1) {
            SessionConfig.logln("SonicMQ.CONNECT_RESPONSE_TIMEOUT - Invalid optional property \"" + s + "\"");
        }
        catch (SecurityException e) {
            SessionConfig.logln("SonicMQ.CONNECT_RESPONSE_TIMEOUT- Invalid optional property; permission denied");
        }
        CONNECT_RESPONSE_TIMEOUT = timeout;
        HTTP_PING_TIMEOUT = SessionConfig.getIntProperty("SonicMQ.HTTP_PING_TIMEOUT", 30);
        keyBits = 56;
        LOGIN_SPI_CLASS_NAME = SessionConfig.getProperty("SonicMQ.LOGIN_SPI", null);
        KEY_STORE_CLASS = SessionConfig.getProperty("KEY_STORE_CLASS", "progress.message.net.ssl.jsafe.jsafeKeyStore");
        REQUEST_TMP_APPID = "$RQSTTMPAPPID$";
        TMP_APPID_PREFIX = "$TMPAPPID$";
        TCP_NODELAY = SessionConfig.getBooleanProperty("SonicMQ.TCP_NODELAY", true);
        DISABLE_NIO = SessionConfig.getBooleanProperty("SonicMQ.DISABLE_NIO", true);
        TUNNELING_PROXY_HOST = null;
        TUNNELING_PROXY_PORT = -1;
        TUNNELING_PROXY_USERNAME = null;
        TUNNELING_PROXY_PASSWORD = null;
        TCP_TUNNELING_PROXY_HOST = null;
        TCP_TUNNELING_PROXY_PORT = -1;
        TCP_TUNNELING_PROXY_USERNAME = null;
        TCP_TUNNELING_PROXY_PASSWORD = null;
        SSL_TUNNELING_PROXY_HOST = null;
        SSL_TUNNELING_PROXY_PORT = -1;
        SSL_TUNNELING_PROXY_USERNAME = null;
        SSL_TUNNELING_PROXY_PASSWORD = null;
        HTTP_PROXY_HOST = null;
        HTTP_PROXY_PORT = -1;
        HTTP_PROXY_USERNAME = null;
        HTTP_PROXY_PASSWORD = null;
        HTTPS_TUNNELING_PROXY_HOST = null;
        HTTPS_TUNNELING_PROXY_PORT = -1;
        HTTPS_TUNNELING_PROXY_USERNAME = null;
        HTTPS_TUNNELING_PROXY_PASSWORD = null;
        HTTPS_TUNNELING_PROXY_AUTHENTICATOR = null;
        HTTPS_TUNNELING_PROXY_AUTHENTICATOR_DEPRECATED = null;
        HTTPS_TUNNELING_PROXY_AUTHENTICATION = false;
        HTTPS_TUNNELING_USE_ANY_HOSTNAME_VERIFIER = false;
        HTTPS_TUNNELING_HOSTNAME_VERIFIER = null;
        USE_EVS_IO = SessionConfig.getBooleanProperty("USE_EVS_IO", false);
        USE_EVS_HTTP = SessionConfig.getBooleanProperty("USE_EVS_HTTP", true);
        USE_EVS_BLOCKING = SessionConfig.getBooleanProperty("USE_EVS_BLOCKING", true);
        USE_EVS_BLOCKING_HTTP_CLIENT = SessionConfig.getBooleanProperty("USE_EVS_BLOCKING_HTTP_CLIENT", false);
        DIAG_MGRAM_HISTORY = SessionConfig.getBooleanProperty("SonicMQ.DIAG_MGRAM_HISTORY", false);
        CAPTURE_BUFFER_FILTER = SessionConfig.getProperty("SonicMQ.CAPTURE_BUFFER_FILTER", "");
        SENDER_CAPTURE_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.SENDER_CAPTURE_BUFFER_SIZE", 262144);
        LISTENER_CAPTURE_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.LISTENER_CAPTURE_BUFFER_SIZE", 8192);
        DBCLEANER_ASSERTION_RECOVERY = SessionConfig.getBooleanProperty("SonicMQ.DBCLEANER_ASSERTION_RECOVERY", false);
        HashMap<String, ArrayList<String>> cbFilters = null;
        if (CAPTURE_BUFFER_FILTER.length() > 0) {
            StringTokenizer tok = new StringTokenizer(CAPTURE_BUFFER_FILTER, ";");
            while (tok.hasMoreTokens()) {
                String filter = tok.nextToken();
                String filterName = null;
                int fIndex = filter.indexOf(":");
                if (fIndex <= 0) continue;
                filterName = filter.substring(0, fIndex);
                StringTokenizer filterTok = new StringTokenizer(filter.substring(fIndex + 1), ",");
                if (filterTok.countTokens() <= 0) continue;
                ArrayList<String> filterList = new ArrayList<String>(filterTok.countTokens());
                if (cbFilters == null) {
                    cbFilters = new HashMap<String, ArrayList<String>>();
                }
                while (filterTok.hasMoreTokens()) {
                    String filterVal = filterTok.nextToken();
                    filterList.add(filterVal);
                }
                cbFilters.put(filterName.toLowerCase(), filterList);
            }
        }
        s_cbFilters = cbFilters;
        IO_SECURITY_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.IO_SECURITY_BUFFER_SIZE", 51200);
        MAX_SEND_IO_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.MAX_SEND_IO_BUFFER_SIZE", 8192);
        MIN_SEND_IO_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.MIN_SEND_IO_BUFFER_SIZE", MAX_SEND_IO_BUFFER_SIZE), MAX_SEND_IO_BUFFER_SIZE);
        INITIAL_SEND_IO_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.INITIAL_SEND_IO_BUFFER_SIZE", MIN_SEND_IO_BUFFER_SIZE), MIN_SEND_IO_BUFFER_SIZE);
        MAX_RCV_IO_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.MAX_RCV_IO_BUFFER_SIZE", 8192);
        MIN_RCV_IO_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.MIN_RCV_IO_BUFFER_SIZE", MAX_RCV_IO_BUFFER_SIZE), MAX_RCV_IO_BUFFER_SIZE);
        INITIAL_RCV_IO_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.INITIAL_RCV_IO_BUFFER_SIZE", MIN_RCV_IO_BUFFER_SIZE), MIN_RCV_IO_BUFFER_SIZE);
        HTTP_MAX_SEND_IO_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.HTTP_MAX_SEND_IO_BUFFER_SIZE", 131072);
        HTTP_MIN_SEND_IO_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.HTTP_MIN_SEND_IO_BUFFER_SIZE", HTTP_MAX_SEND_IO_BUFFER_SIZE), HTTP_MAX_SEND_IO_BUFFER_SIZE);
        HTTP_INITIAL_SEND_IO_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.HTTP_INITIAL_SEND_IO_BUFFER_SIZE", HTTP_MIN_SEND_IO_BUFFER_SIZE), HTTP_MIN_SEND_IO_BUFFER_SIZE);
        HTTP_MAX_RCV_IO_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.HTTP_MAX_RCV_IO_BUFFER_SIZE", 65536);
        HTTP_MIN_RCV_IO_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.HTTP_MIN_RCV_IO_BUFFER_SIZE", HTTP_MAX_RCV_IO_BUFFER_SIZE), HTTP_MAX_RCV_IO_BUFFER_SIZE);
        HTTP_INITIAL_RCV_IO_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.HTTP_INITIAL_RCV_IO_BUFFER_SIZE", HTTP_MIN_RCV_IO_BUFFER_SIZE), HTTP_MIN_RCV_IO_BUFFER_SIZE);
        SOCKET_MAX_SEND_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.TCP_SEND_BUFFER_SIZE", 32768);
        SOCKET_MIN_SEND_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.TCP_MIN_SEND_BUFFER_SIZE", SOCKET_MAX_SEND_BUFFER_SIZE), SOCKET_MAX_SEND_BUFFER_SIZE);
        SOCKET_INITIAL_SEND_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.TCP_INITIAL_SEND_BUFFER_SIZE", SOCKET_MIN_SEND_BUFFER_SIZE), SOCKET_MIN_SEND_BUFFER_SIZE);
        SOCKET_MAX_RCV_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.TCP_RECEIVE_BUFFER_SIZE", 32768);
        SOCKET_MIN_RCV_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.TCP_MIN_RCV_BUFFER_SIZE", SOCKET_MAX_RCV_BUFFER_SIZE), SOCKET_MAX_RCV_BUFFER_SIZE);
        SOCKET_INITIAL_RCV_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.TCP_INITIAL_RCV_BUFFER_SIZE", SOCKET_MIN_RCV_BUFFER_SIZE), SOCKET_MIN_RCV_BUFFER_SIZE);
        HTTP_SOCKET_MAX_SEND_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_SEND_BUFFER_SIZE", 65536);
        HTTP_SOCKET_MIN_SEND_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_MIN_SEND_BUFFER_SIZE", HTTP_SOCKET_MAX_SEND_BUFFER_SIZE), HTTP_SOCKET_MAX_SEND_BUFFER_SIZE);
        HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_INITIAL_SEND_BUFFER_SIZE", HTTP_SOCKET_MIN_SEND_BUFFER_SIZE), HTTP_SOCKET_MIN_SEND_BUFFER_SIZE);
        HTTP_SOCKET_MAX_RCV_BUFFER_SIZE = SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_RECEIVE_BUFFER_SIZE", 65536);
        HTTP_SOCKET_MIN_RCV_BUFFER_SIZE = Math.min(SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_MIN_RCV_BUFFER_SIZE", HTTP_SOCKET_MAX_RCV_BUFFER_SIZE), HTTP_SOCKET_MAX_RCV_BUFFER_SIZE);
        HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE = Math.max(SessionConfig.getIntProperty("SonicMQ.HTTP_SOCKET_INITIAL_RCV_BUFFER_SIZE", HTTP_SOCKET_MIN_RCV_BUFFER_SIZE), HTTP_SOCKET_MIN_RCV_BUFFER_SIZE);
        HTTP_CONNECT_TIMEOUT = SessionConfig.getIntProperty("SonicMQ.HTTP_CONNECT_TIMEOUT", 120000);
        HTTP_CLOSE_TIMEOUT = SessionConfig.getIntProperty("SonicMQ.HTTP_CLOSE_TIMEOUT", 120000);
        if (USE_EVS_IO) {
            System.out.println("Evs IO Enabled");
            System.out.println("");
        }
        if ((TUNNELING_PROXY_HOST = SessionConfig.getProperty(TUNNELING_PROXY_HOST_ATTR, "").trim()).length() > 0) {
            TUNNELING_PROXY_PORT = SessionConfig.getIntProperty(TUNNELING_PROXY_PORT_ATTR, -1);
            if (TUNNELING_PROXY_PORT < 0) {
                SessionConfig.logln("TUNNELING_PROXY_PORT - Invalid optional property \"" + TUNNELING_PROXY_PORT + "\"");
                TUNNELING_PROXY_HOST = null;
            }
            TUNNELING_PROXY_USERNAME = SessionConfig.getProperty(HTTPS_PARAM_PROXY_USERNAME, null);
            TUNNELING_PROXY_PASSWORD = SessionConfig.getProperty(HTTPS_PARAM_PROXY_PASSWORD, null);
        } else {
            TUNNELING_PROXY_HOST = null;
        }
        SessionConfig.initTCPProxySetting();
        SessionConfig.initSSLProxySetting();
        SessionConfig.initHTTPProxySetting();
        SessionConfig.initHTTPSProxySetting();
        CLIENT_SEND_DELAY = SessionConfig.getIntProperty("SonicMQ.CLIENT_SEND_DELAY", 5);
        FT_SYNC_PING = SessionConfig.getBooleanProperty("SonicMQ.FT_SYNC_PING", true);
        MAX_MSG_SIZE_BROKER_DEFAULT = 10;
        MAX_MSG_SIZE = -1;
        DEFAULT_CHANNEL_TIMEOUT = 60000;
        DEFAULT_RETRY_INTERVAL = 10000;
        DEFAULT_RETRY_COUNT = 10;
        DEFAULT_WINDOW_SIZE = 10;
        DEFAULT_FRAGMENT_SIZE = 1024;
        UNKNOWN = new Integer(0);
        SEVERE = new Integer(1);
        WARNING = new Integer(2);
        INFO = new Integer(3);
        CONFIG = new Integer(4);
        FINE = new Integer(5);
        FINER = new Integer(6);
        FINEST = new Integer(7);
        TRACE = new Integer(7);
        int diagnosticLevel = SessionConfig.getIntProperty(PROPERTY_DIAGNOSTIC_LEVEL, 0);
        DebugState.setDiagnosticLevel(diagnosticLevel);
        boolean bl = LOG_CONNECTION_DIAGNOSTICS = (diagnosticLevel & 1) > 0;
        if (!IN_BROKER) {
            DEBUG_NAME = SessionConfig.getProperty("SonicMQ.DEBUG_NAME", null);
            DebugState.parse(DEBUG_NAME);
            DEBUG_CALLBACK = SessionConfig.getProperty("SonicMQ.DEBUG_CALLBACK", null);
            DebugState.parseCallbacks(DEBUG_CALLBACK);
            DEBUG_FILTERS = SessionConfig.getProperty("SonicMQ.DEBUG_FILTERS", null);
        }
        DebugState.setDebugThreadName(SessionConfig.getBooleanProperty(PROPERTY_DEBUG_THREAD_NAME, false));
        ACL_RESOURCE_TOPIC = "topic";
        ACL_RESOURCE_QUEUE = "queue";
        ACL_RESOURCE_NODE = "node";
        ACL_RESOURCE_URL = "URL";
        ROUTING_ROOT = "$RNN.";
        HTTP_ROOT = "$HTTP.";
        HTTPS_ROOT = "$HTTPS.";
        TOPIC_ROOT = "$T.";
        QUEUE_ROOT = "$Q.";
        SONIC_HTTP = "sonic.http";
        COMPRESSION_FACTORY = SonicCompressionFactory.class.getName();
    }

    private static class LoggerLevelsHolder {
        private static final Integer LEVEL_FINEST = SessionConfig.access$100("getLevelFinest", FINEST);
        private static final Integer LEVEL_FINER = SessionConfig.access$100("getLevelFiner", FINER);
        private static final Integer LEVEL_FINE = SessionConfig.access$100("getLevelFine", FINE);
        private static final Integer LEVEL_CONFIG = SessionConfig.access$100("getLevelConfig", CONFIG);
        private static final Integer LEVEL_INFO = SessionConfig.access$100("getLevelInfo", INFO);
        private static final Integer LEVEL_WARNING = SessionConfig.access$100("getLevelWarning", WARNING);
        private static final Integer LEVEL_SEVERE = SessionConfig.access$100("getLevelSevere", SEVERE);
        private static final Integer LEVEL_UNKNOWN = SessionConfig.access$100("getLevelUnknown", UNKNOWN);

        private LoggerLevelsHolder() {
        }
    }

    private static class LoggerMethodLazyHolder {
        private static final Method LOGGER_METHOD = LoggerMethodLazyHolder.getLoggerMethod();

        private LoggerMethodLazyHolder() {
        }

        private static Method getLoggerMethod() {
            Class[] parameters = new Class[]{String.class, Integer.class};
            String methodName = "logMessage";
            try {
                return LoggerClassHolder.LOGGER_CLASS.getMethod(methodName, parameters);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }

    private static class LoggerClassHolder {
        private static final Class LOGGER_CLASS = LoggerClassHolder.getLoggerClass();

        private LoggerClassHolder() {
        }

        private static Class getLoggerClass() {
            try {
                return Class.forName("com.sonicsw.mq.components.BrokerComponent");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
    }
}

