/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;

public class AddNewQueueChangeHandler
implements IAttributeChangeHandler {
    private AttributesHolder s_attributesHolder = null;
    private ConfigurationChangeBindHelper s_bindHelper = null;

    public AddNewQueueChangeHandler(AttributesHolder attributesHolder, ConfigurationChangeBindHelper bindHelper) {
        this.s_attributesHolder = attributesHolder;
        this.s_bindHelper = bindHelper;
    }

    public void itemDeleted() {
    }

    public void itemModified(Object newValue) {
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        int len = newAttributes.length;
        if (len == 0) {
            return;
        }
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        IAttributeSet qas = null;
        for (int i = 0; i < len; ++i) {
            try {
                qas = (IAttributeSet)delta.getNewValue(newAttributes[i]);
                Object paramVal = null;
                String queueName = (String)qas.getAttribute("QUEUE_NAME");
                String queueType = "AdministrativelyCreated";
                paramVal = (String)qas.getAttribute("QUEUE_TYPE");
                if (paramVal != null) {
                    queueType = paramVal;
                }
                int queueMaxSize = 1000;
                paramVal = qas.getAttribute("QUEUE_MAX_SIZE");
                if (paramVal != null) {
                    queueMaxSize = (Integer)paramVal;
                }
                int queueSaveThreshold = 1536;
                paramVal = qas.getAttribute("QUEUE_SAVE_THRESHOLD");
                if (paramVal != null) {
                    queueSaveThreshold = (Integer)paramVal;
                }
                boolean isGlobal = false;
                paramVal = qas.getAttribute("GLOBAL");
                if (paramVal != null) {
                    isGlobal = (Boolean)paramVal;
                }
                boolean isReadExclusive = false;
                paramVal = qas.getAttribute("READ_EXCLUSIVE");
                if (paramVal != null) {
                    isReadExclusive = (Boolean)paramVal;
                }
                boolean isClustered = false;
                paramVal = qas.getAttribute("CLUSTERED");
                if (paramVal != null) {
                    isClustered = (Boolean)paramVal;
                }
                if (!queueType.equalsIgnoreCase("AdministrativelyCreated")) continue;
                boolean isMessageGroupEnabled = false;
                paramVal = qas.getAttribute("ENABLE_MESSAGE_GROUPING");
                if (paramVal != null) {
                    isMessageGroupEnabled = (Boolean)paramVal;
                }
                String groupPropertyName = "JMSXGroupID";
                paramVal = qas.getAttribute("ALTERNATE_GROUP_NAME");
                if (paramVal != null) {
                    groupPropertyName = (String)paramVal;
                }
                int idleTimeoutInMinutes = -1;
                paramVal = qas.getAttribute("GROUP_IDLE_TIMEOUT");
                if (paramVal != null) {
                    idleTimeoutInMinutes = (Integer)paramVal;
                }
                int maxWaitTimeInMiliSeconds = 10;
                paramVal = qas.getAttribute("MAX_WAIT_TIME");
                if (paramVal != null) {
                    maxWaitTimeInMiliSeconds = (Integer)paramVal;
                }
                int minConsumers = 2;
                paramVal = qas.getAttribute("MIN_CONSUMERS");
                if (paramVal != null) {
                    minConsumers = (Integer)paramVal;
                }
                aqp.createQueueDynamic(queueName, queueMaxSize, queueSaveThreshold, isReadExclusive, isGlobal, isClustered, isMessageGroupEnabled, groupPropertyName, idleTimeoutInMinutes * 60, maxWaitTimeInMiliSeconds / 1000, minConsumers);
                this.s_bindHelper.bindQueueChangeHandler(queueName, qas);
                this.s_attributesHolder.addQueueAttributeSet(queueName, qas);
                continue;
            }
            catch (NotModifiedAttException notModifiedAttException) {
                // empty catch block
            }
        }
    }
}

