/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.policy;

import com.sonicsw.ws.rm.policy.RMProcessorContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class RMPolicyToken {
    public static final int COMPLEX_TOKEN = 1;
    public static final int SIMPLE_TOKEN = 2;
    public static final int WITH_CONTENT = 100;
    private String tokenName;
    private int tokenType = 0;
    private String[] attributes = null;
    private Object handler = null;
    private Method processTokenMethod = null;
    private ArrayList childTokens = null;

    public RMPolicyToken(String token, int type, String[] attribs, Object h) throws SecurityException, NoSuchMethodException {
        this(token, type, attribs);
        this.setProcessTokenMethod(h);
    }

    public RMPolicyToken(String token, int type, String[] attribs) {
        this.tokenName = token;
        this.tokenType = type;
        this.attributes = attribs;
        if (this.tokenType == 1) {
            this.childTokens = new ArrayList();
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public final void setProcessTokenMethod(Object h) throws NoSuchMethodException {
        if (h == null) {
            return;
        }
        this.handler = h;
        Class<?> handlerCls = h.getClass();
        Class[] parameters = new Class[]{RMProcessorContext.class};
        this.processTokenMethod = handlerCls.getDeclaredMethod("do" + this.tokenName, parameters);
    }

    public boolean invokeProcessTokenMethod(RMProcessorContext spc) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (this.processTokenMethod == null) {
            return false;
        }
        Object[] parameter = new Object[]{spc};
        Object ret = this.processTokenMethod.invoke(this.handler, parameter);
        if (ret instanceof Boolean) {
            Boolean bool = (Boolean)ret;
            return bool;
        }
        return false;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setChildToken(RMPolicyToken spt) {
        this.childTokens.add(spt);
    }

    public RMPolicyToken getChildToken(String sptName) {
        for (RMPolicyToken tmpSpt : this.childTokens) {
            if (!sptName.equals(tmpSpt.getTokenName())) continue;
            return tmpSpt;
        }
        return null;
    }

    public void removeChildToken(String sptName) {
        for (RMPolicyToken tmpSpt : this.childTokens) {
            if (!sptName.equals(tmpSpt.getTokenName())) continue;
            this.childTokens.remove(tmpSpt);
            return;
        }
    }

    public RMPolicyToken copy() {
        RMPolicyToken spt = new RMPolicyToken(this.tokenName, this.tokenType, this.attributes);
        if (this.childTokens != null) {
            for (RMPolicyToken tmpSpt : this.childTokens) {
                spt.setChildToken(tmpSpt);
            }
        }
        return spt;
    }
}

