/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.IClientContext;
import progress.message.broker.LBSTrackingInfo;
import progress.message.msg.IMgram;
import progress.message.zclient.BaseConnection;
import progress.message.zclient.Connection;
import progress.message.zclient.xonce.IMgramTraceHelper;

public class BrokerMgramTraceHelper
implements IMgramTraceHelper {
    @Override
    public String getSocketId(BaseConnection c) {
        long sockId = -1L;
        if (c instanceof Connection) {
            sockId = ((Connection)c).getSocketId();
        }
        if (c instanceof AgentConnection) {
            sockId = ((AgentConnection)c).getSocketId();
        }
        return Long.toString(sockId);
    }

    @Override
    public String getApplicationId(BaseConnection c, IMgram m) {
        if (c instanceof Connection) {
            return ((Connection)c).getApplicationId();
        }
        if (c instanceof AgentConnection) {
            return BrokerMgramTraceHelper.getApplicationId((AgentConnection)c, m);
        }
        return "???";
    }

    private static String getApplicationId(AgentConnection ac, IMgram m) {
        long clientId = ac.getClientId(m.getChannel());
        try {
            IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
            if (cc == null) {
                return "UNREGISTERED";
            }
            return cc.getAppid();
        }
        catch (Exception e) {
            return "UNREGISTERED";
        }
    }

    @Override
    public String getUserId(BaseConnection bc, IMgram m) {
        if (bc instanceof Connection) {
            try {
                return ((Connection)bc).getSecurityContext().getUid();
            }
            catch (Exception ecnr) {
                return "UNREGISTERED";
            }
        }
        if (bc instanceof AgentConnection) {
            AgentConnection ac = (AgentConnection)bc;
            long clientId = ac.getClientId(m.getChannel());
            try {
                IClientContext cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
                if (cc == null) {
                    return "UNREGISTERED";
                }
                return cc.getUid();
            }
            catch (Exception ecnr) {
                return "UNREGISTERED";
            }
        }
        return "???";
    }

    @Override
    public String getUserFromClientId(long id) {
        if (id == -1L) {
            return "NO_PARENT";
        }
        IClientContext cc = null;
        try {
            cc = AgentRegistrar.getAgentRegistrar().getClient(id);
            return cc.getUid() + "/" + cc.getAppid();
        }
        catch (EClientNotRegistered ex) {
            return "UNREGISTERED-" + id;
        }
    }

    @Override
    public String getLBSInfo(IMgram m) {
        LBSTrackingInfo groups = LBSTrackingInfo.unmarshalLBTargetWrapper(m);
        return groups.toString();
    }
}

