/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import progress.message.broker.BrokerSubscription;
import progress.message.broker.IClientContext;
import progress.message.util.LongHashTable;
import progress.message.zclient.ISubject;
import progress.message.zclient.Label;

public class MergedBrokerSubscription
extends BrokerSubscription {
    private LongHashTable m_contributors = new LongHashTable();

    public LongHashTable getContributors() {
        return this.m_contributors;
    }

    MergedBrokerSubscription(IClientContext client, ISubject subject, Label lbl) {
        super(client, subject, lbl);
        if (this.DEBUG) {
            this.debug("New merged subscription for: " + this.toString());
        }
    }

    synchronized boolean addSubscription(BrokerSubscription sub) {
        sub.setParent(this);
        boolean first = this.m_contributors.isEmpty();
        this.m_contributors.put(sub.getClientId(), sub);
        if (this.DEBUG) {
            this.debug("Added contributing subscription: " + sub.toString() + " to merged subscription: " + this.toString());
        }
        return first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeSubscription(BrokerSubscription sub) {
        boolean empty = false;
        String[] selectorStrings = sub.getSelectorStrings();
        MergedBrokerSubscription mergedBrokerSubscription = this;
        synchronized (mergedBrokerSubscription) {
            if (selectorStrings != null) {
                for (int ii = 0; ii < selectorStrings.length; ++ii) {
                    this.removeSelector(selectorStrings[ii]);
                }
            }
            this.m_contributors.remove(sub.getClientId());
            if (this.DEBUG) {
                this.debug("Removed contributing subscription: " + sub.toString() + " from merged subscription: " + this.toString());
            }
            empty = this.m_contributors.isEmpty();
        }
        return empty;
    }

    synchronized boolean addSelector(BrokerSubscription.SelectorInfo newSelector) {
        boolean addedNew = false;
        MergedSelectorInfo selector = (MergedSelectorInfo)this.m_selectors.get(newSelector.m_messageSelectorString);
        if (selector == null) {
            this.m_messageSelectorStrings = null;
            selector = new MergedSelectorInfo();
            selector.m_messageSelectorString = newSelector.m_messageSelectorString;
            selector.m_messageSelector = newSelector.m_messageSelector;
            selector.m_count = 1;
            this.m_selectors.put(selector.m_messageSelectorString, selector);
            if (selector.m_messageSelector == null) {
                this.m_hasEmptySelector = true;
            }
            addedNew = true;
            if (this.DEBUG) {
                this.debug("Added new selector: " + newSelector.m_messageSelectorString + " to merged subscription: " + this.toString());
            }
        } else {
            ++selector.m_count;
            if (this.DEBUG) {
                this.debug("Incremented count (" + selector.m_count + ") for selector: " + newSelector.m_messageSelectorString + " for merged subscription: " + this.toString());
            }
        }
        return addedNew;
    }

    synchronized boolean removeSelector(String oldSelectorString) {
        boolean removedOld = false;
        MergedSelectorInfo selector = (MergedSelectorInfo)this.m_selectors.get(oldSelectorString);
        if (selector != null) {
            --selector.m_count;
            if (this.DEBUG) {
                this.debug("Decremented count (" + selector.m_count + ") for selector: " + selector.m_messageSelectorString + " for merged subscription: " + this.toString());
            }
            if (selector.m_count == 0) {
                this.m_messageSelectorStrings = null;
                this.m_selectors.remove(selector.m_messageSelectorString);
                if (selector.m_messageSelector == null) {
                    this.m_hasEmptySelector = false;
                }
                removedOld = true;
                if (this.DEBUG) {
                    this.debug("Removed selector: " + selector.m_messageSelectorString + " from merged subscription: " + this.toString());
                }
            }
        }
        return removedOld;
    }

    @Override
    public boolean isBatchable() {
        return false;
    }

    @Override
    public boolean isBatchAtomic(boolean batchAtomicIfNonDurable) {
        return false;
    }

    class MergedSelectorInfo
    extends BrokerSubscription.SelectorInfo {
        int m_count = 0;

        MergedSelectorInfo() {
        }
    }
}

