/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.Iterator;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.EInvalidLogEvent;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.MgramSerializer;
import progress.message.broker.RecoveryMgr;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.EMgramFormatError;

public class SyncQueueMsgEvt
extends LogEvent {
    long m_tracking;
    IMgram m_msg;
    long m_origSender;
    long m_origTracking;
    boolean m_needGuarAck;
    long m_receiverId;
    boolean m_delivered;
    String m_queueName;
    long m_oldTracking;
    boolean m_parentExists = false;
    int m_tid;
    private boolean m_splitBatch = false;
    boolean m_isTemp;
    byte m_priority;
    long m_expiration;
    long m_enqueuedSize;
    short m_eventType = (short)77;
    private boolean m_delayLogLimiterRelease = true;

    SyncQueueMsgEvt(AgentQueueMsgTracker tracker) {
        this.m_tracking = tracker.getTracking();
        this.m_msg = tracker.getMessage();
        if (this.m_msg != null) {
            this.setReplicateOnly(this.m_msg.isNonPersistentReplicated());
        } else {
            this.setReplicateOnly(tracker.isReplicateOnly());
        }
        this.m_needGuarAck = tracker.needGuarAck();
        if (this.m_needGuarAck) {
            this.m_origSender = tracker.getOrigSender();
            this.m_origTracking = tracker.getOrigTracking();
        }
        this.m_delivered = tracker.isDelivered();
        this.m_receiverId = tracker.getReceiverId();
        this.m_oldTracking = tracker.getOldTracking();
        this.m_queueName = tracker.getLocalQueueName();
        if (this.m_queueName == null) {
            throw new EAssertFailure("null queue name");
        }
        if (tracker.getParentTracker() != null) {
            this.m_parentExists = true;
        }
        this.m_tid = tracker.getTransactionId();
        this.m_isTemp = tracker.isTemporary();
        this.m_expiration = tracker.getExpiration();
        this.m_priority = tracker.getPriority();
        this.m_enqueuedSize = tracker.getEnqueuedSize();
        this.m_splitBatch = tracker.splitBatch();
        if (this.DEBUG) {
            this.debug("Created; queueName = " + this.m_queueName);
        }
    }

    SyncQueueMsgEvt(short type) {
        this.m_eventType = type;
    }

    @Override
    public short type() {
        return 77;
    }

    @Override
    protected int memSizeBody() {
        int size = 48 + (this.m_msg != null ? this.m_msg.serializedLength() : 0) + 4 + (this.m_queueName != null ? this.m_queueName.length() << 1 : 0) + 8 + 1 + 1 + 8 + 8;
        return size;
    }

    @Override
    public void saveMemory() {
        if (this.m_msg != null) {
            this.m_msg.saveMemory();
        }
    }

    public boolean splitBatch() {
        return this.m_splitBatch;
    }

    public void setSplitBatch(boolean splitBatch) {
        this.m_splitBatch = splitBatch;
    }

    @Override
    protected int streamSizeBody() {
        return this.baseSize() + (this.m_msg != null && !this.m_parentExists ? this.m_msg.networkLength() : 0);
    }

    @Override
    protected int serializedSizeBody() {
        return this.baseSize() + (this.m_msg != null && !this.m_parentExists ? this.m_msg.serializedLength() : 0);
    }

    private int baseSize() {
        int result = 0;
        int namelen = 0;
        byte[] utfqname = null;
        if (this.m_queueName != null) {
            block3: {
                try {
                    utfqname = StringUtil.stringToUTF(this.m_queueName);
                }
                catch (UTFDataFormatException e) {
                    if (!this.DEBUG) break block3;
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            namelen = utfqname.length;
        }
        result += 15;
        result += 32 + namelen;
        result += 4;
        ++result;
        result += 8;
        ++result;
        return result += 8;
    }

    @Override
    public boolean delayLogLimiterRelease() {
        return this.m_delayLogLimiterRelease;
    }

    @Override
    public void prepareToFire() {
        AgentRegistrar.getAgentRegistrar().getLogManager().releaseLimiter(this);
        this.m_delayLogLimiterRelease = false;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writePreMgramToStream(out);
        if (this.m_msg != null && !this.m_parentExists) {
            StreamUtil.writeBoolean(true, out);
            MgramSerializer.getMgramSerializer().serialize(out, this.m_msg, false);
        } else {
            StreamUtil.writeBoolean(false, out);
        }
        this.writePostMgramToStream(out);
    }

    private void writePreMgramToStream(OutputStream os) throws IOException {
        StreamUtil.writeLong(this.m_tracking, os);
        StreamUtil.writeBoolean(this.m_needGuarAck, os);
        if (this.m_needGuarAck) {
            StreamUtil.writeLong(this.m_origSender, os);
            StreamUtil.writeLong(this.m_origTracking, os);
        }
        StreamUtil.writeBoolean(this.m_delivered, os);
        if (!this.m_delivered) {
            StreamUtil.writeLong(this.m_receiverId, os);
        }
        if (this.m_queueName != null) {
            byte[] utfqname = StringUtil.stringToUTF(this.m_queueName);
            StreamUtil.writeBoolean(true, os);
            os.write(utfqname, 0, utfqname.length);
        } else {
            StreamUtil.writeBoolean(false, os);
        }
    }

    private void writePostMgramToStream(OutputStream os) throws IOException {
        if (this.m_oldTracking != 0L) {
            StreamUtil.writeBoolean(true, os);
            StreamUtil.writeLong(this.m_oldTracking, os);
        } else {
            StreamUtil.writeBoolean(false, os);
        }
        StreamUtil.writeBoolean(this.m_parentExists, os);
        if (this.m_tid != 0) {
            StreamUtil.writeBoolean(true, os);
            StreamUtil.writeInt(this.m_tid, os);
        } else {
            StreamUtil.writeBoolean(false, os);
        }
        StreamUtil.writeBoolean(this.m_splitBatch, os);
        StreamUtil.writeBoolean(this.m_isTemp, os);
        StreamUtil.writeByte(this.m_priority, os);
        StreamUtil.writeLong(this.m_expiration, os);
        StreamUtil.writeLong(this.m_enqueuedSize, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writePreMgramToStream(os);
        if (this.m_msg != null && !this.m_parentExists) {
            StreamUtil.writeBoolean(true, os);
            MgramSerializer.getMgramSerializer().serialize(os, this.m_msg, tteTTLConvert);
        } else {
            StreamUtil.writeBoolean(false, os);
        }
        this.writePostMgramToStream(os);
    }

    @Override
    protected void readBodyFromLog(InputStream in) throws IOException, EInvalidLogEvent, EMgramFormatError {
        this.readPreMgram(in);
        boolean hasMsg = StreamUtil.readBoolean(in);
        if (hasMsg) {
            this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in);
            this.configLocalQueueNames();
        }
        this.readPostMgram(in);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException, EMgramFormatError {
        this.readPreMgram(in);
        boolean hasMsg = StreamUtil.readBoolean(in);
        if (hasMsg) {
            this.m_msg = MgramSerializer.getMgramSerializer().unserialize(in, tteTTLConvert);
            this.configLocalQueueNames();
        }
        this.readPostMgram(in);
    }

    private void configLocalQueueNames() {
        String queueName = this.m_queueName.intern();
        this.m_msg.getBrokerHandle().setLocalQueueName(queueName);
        if (this.m_msg.getType() == 27) {
            IBatchHandle batchHandle = this.m_msg.getBatchHandle();
            Iterator itr = batchHandle.getBatchIterator();
            while (itr.hasNext()) {
                IMgram subMgram = (IMgram)itr.next();
                subMgram.getBrokerHandle().setLocalQueueName(queueName);
            }
        }
    }

    private void readPostMgram(InputStream in) throws IOException {
        boolean hasOldTracking = StreamUtil.readBoolean(in);
        if (hasOldTracking) {
            this.m_oldTracking = StreamUtil.readLong(in);
        }
        if (this.m_eventType == 49 || this.m_eventType == 71 || this.m_eventType == 77) {
            this.m_parentExists = StreamUtil.readBoolean(in);
            boolean hasTid = StreamUtil.readBoolean(in);
            if (hasTid) {
                this.m_tid = StreamUtil.readInt(in);
            }
        }
        if (this.m_eventType == 71 || this.m_eventType == 77) {
            this.m_splitBatch = StreamUtil.readBoolean(in);
        }
        if (this.m_eventType == 77) {
            this.m_isTemp = StreamUtil.readBoolean(in);
            this.m_priority = StreamUtil.readByte(in);
            this.m_expiration = StreamUtil.readLong(in);
            this.m_enqueuedSize = StreamUtil.readLong(in);
        } else {
            this.m_isTemp = false;
            if (!this.m_splitBatch && this.m_msg != null) {
                this.m_priority = this.m_msg.getPriority();
                if (this.m_msg.isTTE()) {
                    this.m_expiration = this.m_msg.getTTE();
                }
                this.m_enqueuedSize = this.m_msg.getEnqueuedSize();
            }
        }
    }

    private void readPreMgram(InputStream in) throws IOException {
        boolean hasName;
        this.m_tracking = StreamUtil.readLong(in);
        this.m_needGuarAck = StreamUtil.readBoolean(in);
        if (this.m_needGuarAck) {
            this.m_origSender = StreamUtil.readLong(in);
            this.m_origTracking = StreamUtil.readLong(in);
        }
        this.m_delivered = StreamUtil.readBoolean(in);
        if (!this.m_delivered) {
            this.m_receiverId = StreamUtil.readLong(in);
        }
        if (hasName = StreamUtil.readBoolean(in)) {
            this.m_queueName = StreamUtil.readUTF(in);
        }
        if (this.m_queueName == null) {
            throw new EAssertFailure("null queue name");
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncQueueMsg(this);
    }

    @Override
    public String toString() {
        return super.toString() + "QueueSyncpoint: message " + this.m_tracking + " Queue=" + this.m_queueName + " MsgSize=" + this.m_enqueuedSize + (this.m_msg == null ? " (db)" : "") + (this.m_tid > 0 ? " Tid=" + this.m_tid : "");
    }
}

