/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.AddrUtil;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.broker.TxnAckPool;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

public class SyncTxnEvt
extends LogEvent {
    private int m_tid;
    private int m_previousTid;
    private String m_uid;
    private String m_appid;
    private short m_state;
    private String m_userXid;
    private String m_noDupCommitId = "";
    private long m_noDupTimestamp;
    private short m_eventType;
    private TxnAckPool m_txnAckPool;
    private byte m_persistenceType;
    private long m_requestId;
    private long m_lifespan;
    private boolean m_chained;
    private short m_replyStatus;

    SyncTxnEvt(int tid, int previousTid, String uid, String appid, short state, String userXid, String noDupCommitId, long noDupTimestamp, TxnAckPool txnAckPool, byte persistenceType, long requestId, long lifespan, boolean chained, short replyStatus) {
        this.m_tid = tid;
        this.m_previousTid = previousTid;
        this.m_uid = uid;
        this.m_appid = appid;
        this.m_state = state;
        this.m_userXid = userXid;
        this.m_noDupCommitId = noDupCommitId;
        this.m_noDupTimestamp = noDupTimestamp;
        this.m_txnAckPool = txnAckPool;
        this.m_persistenceType = persistenceType;
        this.m_requestId = requestId;
        this.m_lifespan = lifespan;
        this.m_chained = chained;
        this.m_replyStatus = replyStatus;
    }

    SyncTxnEvt(short type) {
        this.m_eventType = type;
    }

    int getTid() {
        return this.m_tid;
    }

    int getPreviousTid() {
        return this.m_previousTid;
    }

    long getOwner() {
        return AddrUtil.stringToClientId(this.m_uid, this.m_appid);
    }

    short getState() {
        return this.m_state;
    }

    String getUserXid() {
        return this.m_userXid;
    }

    String getUid() {
        return this.m_uid;
    }

    String getAppid() {
        return this.m_appid;
    }

    String getNoDupCommitId() {
        return this.m_noDupCommitId;
    }

    long getNoDupTimestamp() {
        return this.m_noDupTimestamp;
    }

    TxnAckPool getTxnAckPool() {
        return this.m_txnAckPool;
    }

    byte getPersistenceType() {
        return this.m_persistenceType;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    boolean getChained() {
        return this.m_chained;
    }

    long getLifespan() {
        return this.m_lifespan;
    }

    short getReplyStatus() {
        return this.m_replyStatus;
    }

    @Override
    public short type() {
        return 89;
    }

    @Override
    protected int memSizeBody() {
        int result = 39 + (this.m_uid.length() + this.m_appid.length() + this.m_userXid.length() + this.m_noDupCommitId.length() << 1) + 8 + 8 + 1 + 2;
        if (this.m_txnAckPool != null) {
            result = result + 4 + this.m_txnAckPool.getMemorySize();
        }
        return result;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        byte[] utfxid = StringUtil.stringToUTF(this.m_userXid);
        byte[] utfuid = StringUtil.stringToUTF(this.m_uid);
        byte[] utfappid = StringUtil.stringToUTF(this.m_appid);
        byte[] utfNoDupCommitId = StringUtil.stringToUTF(this.m_noDupCommitId);
        StreamUtil.writeInt(this.m_tid, os);
        StreamUtil.writeShort(this.m_state, os);
        os.write(utfxid, 0, utfxid.length);
        os.write(utfuid, 0, utfuid.length);
        os.write(utfappid, 0, utfappid.length);
        os.write(utfNoDupCommitId, 0, utfNoDupCommitId.length);
        StreamUtil.writeLong(this.m_noDupTimestamp, os);
        if (this.m_txnAckPool == null) {
            StreamUtil.writeInt(0, os);
        } else {
            this.m_txnAckPool.writebody(os);
        }
        StreamUtil.writeByte(this.m_persistenceType, os);
        StreamUtil.writeInt(this.m_previousTid, os);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeLong(this.m_lifespan, os);
        StreamUtil.writeBoolean(this.m_chained, os);
        StreamUtil.writeShort(this.m_replyStatus, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        this.m_state = StreamUtil.readShort(in);
        this.m_userXid = StreamUtil.readUTF(in);
        this.m_uid = StreamUtil.readUTF(in);
        this.m_appid = StreamUtil.readUTF(in);
        if (this.m_eventType == 17) {
            this.configPersistTypeFileAndResetFields();
            return;
        }
        this.m_noDupCommitId = StreamUtil.readUTF(in);
        this.m_noDupTimestamp = StreamUtil.readLong(in);
        if (this.m_eventType == 32 || this.m_eventType == 39 || this.m_eventType == 41) {
            this.configPersistTypeFileAndResetFields();
            return;
        }
        this.m_txnAckPool = new TxnAckPool(this.m_tid);
        this.m_txnAckPool.readBody(in);
        this.m_persistenceType = StreamUtil.readByte(in);
        if (this.m_eventType == 89 || this.m_eventType == 90 || this.m_eventType == 100) {
            this.m_previousTid = StreamUtil.readInt(in);
            this.m_requestId = StreamUtil.readLong(in);
            this.m_lifespan = StreamUtil.readLong(in);
            this.m_chained = StreamUtil.readBoolean(in);
            this.m_replyStatus = StreamUtil.readShort(in);
        } else {
            this.m_requestId = 0L;
            this.m_lifespan = 0L;
            this.m_chained = false;
            this.m_previousTid = -1;
            this.m_replyStatus = 0;
        }
    }

    private void configPersistTypeFileAndResetFields() {
        this.m_persistenceType = (byte)2;
        this.m_previousTid = -1;
        this.m_requestId = 0L;
        this.m_lifespan = 0L;
        this.m_chained = false;
        this.m_replyStatus = 0;
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoSyncTxn(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Syncpoint: transaction " + this.m_tid + " state: " + this.m_state + " owner: " + this.m_uid + ", " + this.m_appid;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        byte[] utfNoDupCommitId;
        byte[] utfappid;
        byte[] utfuid;
        byte[] utfxid;
        block2: {
            utfxid = null;
            utfuid = null;
            utfappid = null;
            utfNoDupCommitId = null;
            try {
                utfxid = StringUtil.stringToUTF(this.m_userXid);
                utfuid = StringUtil.stringToUTF(this.m_uid);
                utfappid = StringUtil.stringToUTF(this.m_appid);
                utfNoDupCommitId = StringUtil.stringToUTF(this.m_noDupCommitId);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        int size = 10 + utfxid.length + utfuid.length + utfappid.length + utfNoDupCommitId.length + 8 + 1;
        size = this.m_txnAckPool == null ? (size += 4) : (size += this.m_txnAckPool.getSerializedSize());
        return size += 19;
    }
}

