/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.durable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import progress.message.broker.durable.IDurableHeaderInfo;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.util.WrappedDataInputStream;
import progress.message.util.WrappedDataOutputStream;
import progress.message.zclient.Envelope;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.ISubject;
import progress.message.zclient.Subject;

final class DurableHeaderInfo
implements IDurableHeaderInfo {
    private boolean m_isJMSPersistent;
    private boolean m_isNonPersistentReplicated;
    private boolean m_isDiscardable;
    private ISubject m_subject;
    private long m_expiration;
    private String m_jmsMessageID;
    private int m_priority;
    private boolean m_redelivered;
    private String m_routing;
    private Vector m_allRouting;
    private long m_clientId;
    private ISidebandData m_data = MgramFactory.getMgramFactory().buildSidebandData();
    private String m_brokerName;

    public void setReplyInformation(IMgram mg, long clientId) {
        this.m_data = mg.getSidebandData();
        if (this.m_data == null) {
            this.m_data = MgramFactory.getMgramFactory().buildSidebandData();
        }
        this.m_routing = mg.getRoutingHandle().getRouting();
        this.m_allRouting = mg.getRoutingHandle().getAllRouting();
        this.m_isJMSPersistent = mg.isJMSPersistent();
        this.m_isNonPersistentReplicated = mg.isNonPersistentReplicated();
        this.m_isDiscardable = mg.isDiscardable();
        this.m_subject = mg.getSubject();
        this.m_expiration = mg.getTTE();
        this.m_jmsMessageID = Envelope.getMessageID(mg);
        this.m_priority = mg.getPriority();
        this.m_redelivered = mg.isSuccessor();
        this.m_clientId = clientId;
    }

    @Override
    public ISidebandData getSidebandData() {
        return this.m_data;
    }

    @Override
    public long getClientId() {
        return this.m_clientId;
    }

    @Override
    public Hashtable getUserProperties() {
        return this.m_data.getProperties();
    }

    @Override
    public boolean isJMSPersistent() {
        return this.m_isJMSPersistent;
    }

    @Override
    public boolean isNonPersistentReplicated() {
        return this.m_isNonPersistentReplicated;
    }

    @Override
    public boolean isDiscardable() {
        return this.m_isDiscardable;
    }

    @Override
    public ISubject getSubject() {
        return this.m_subject;
    }

    @Override
    public String getReplyToSubject() {
        return this.m_data.getReplyTo();
    }

    @Override
    public long getJMSExpiration() {
        return this.m_expiration;
    }

    @Override
    public String getJMSMessageID() {
        return this.m_jmsMessageID;
    }

    @Override
    public int getJMSPriority() {
        return this.m_priority;
    }

    @Override
    public boolean getJMSRedelivered() {
        return this.m_redelivered;
    }

    @Override
    public long getJMSTimeStamp() {
        return this.m_data.getTimestamp();
    }

    @Override
    public String getJMSType() {
        return this.m_data.getType();
    }

    @Override
    public String getCorrelationID() {
        return this.m_data.getCorrelationID();
    }

    @Override
    public String getOriginationBroker() {
        return this.m_brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.m_brokerName = brokerName;
    }

    @Override
    public String getRouting() {
        return this.m_routing;
    }

    @Override
    public Vector getAllRouting() {
        return this.m_allRouting;
    }

    protected final void unserialize(DataInput dinput) throws IOException {
        int length = dinput.readInt();
        byte[] buffer = new byte[length];
        dinput.readFully(buffer);
        this.m_data = MgramFactory.getMgramFactory().buildSidebandData();
        this.m_data.fromByteArray(buffer, 0);
        this.m_isJMSPersistent = dinput.readBoolean();
        this.m_isNonPersistentReplicated = dinput.readBoolean();
        this.m_isDiscardable = dinput.readBoolean();
        WrappedDataInputStream dos = new WrappedDataInputStream(dinput);
        this.m_subject = Subject.createFromStream(dos);
        this.m_expiration = dinput.readLong();
        this.m_jmsMessageID = dinput.readUTF();
        this.m_priority = dinput.readInt();
        this.m_redelivered = dinput.readBoolean();
        this.m_clientId = dinput.readLong();
    }

    protected final void serialize(DataOutput doutput) throws IOException {
        byte[] buffer = this.m_data.getNewByteArray();
        doutput.writeInt(buffer.length);
        doutput.write(buffer);
        doutput.writeBoolean(this.m_isJMSPersistent);
        doutput.writeBoolean(this.m_isNonPersistentReplicated);
        doutput.writeBoolean(this.m_isDiscardable);
        WrappedDataOutputStream dos = new WrappedDataOutputStream(doutput);
        this.m_subject.writeToStream(dos);
        doutput.writeLong(this.m_expiration);
        doutput.writeUTF(this.m_jmsMessageID);
        doutput.writeInt(this.m_priority);
        doutput.writeBoolean(this.m_redelivered);
        doutput.writeLong(this.m_clientId);
    }
}

