/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt;

import java.util.HashSet;
import java.util.Set;
import progress.message.broker.mqtt.proto.MqttException;

public class MqttMessageIdTracker {
    public static final int MIN_MSG_ID = 1;
    public static final int MAX_MSG_ID = 65535;
    private final Object m_msgIdsLock = new Object();
    private final Set<Integer> m_msgIds = new HashSet<Integer>();
    private int m_nextMsgId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextMessageId() {
        Object object = this.m_msgIdsLock;
        synchronized (object) {
            int startingMessageId = this.m_nextMsgId;
            do {
                ++this.m_nextMsgId;
                if (this.m_nextMsgId > 65535) {
                    this.m_nextMsgId = 1;
                }
                if (this.m_nextMsgId != startingMessageId) continue;
                throw new MqttException("Can't find a message ID available to use!");
            } while (this.m_msgIds.contains(this.m_nextMsgId));
            this.m_msgIds.add(this.m_nextMsgId);
            return this.m_nextMsgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackMessageId(Integer messageId) {
        if (messageId < 1 || messageId > 65535) {
            throw new MqttException("Invalid message ID range! messageId = " + messageId);
        }
        Object object = this.m_msgIdsLock;
        synchronized (object) {
            this.m_msgIds.add(messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMessageId(Integer messageId) {
        Object object = this.m_msgIdsLock;
        synchronized (object) {
            this.m_msgIds.remove(messageId);
        }
    }
}

