/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import progress.message.util.StringUtil;
import progress.message.zclient.ClientSecurityContext;

public class ClientContextDescriptor {
    public static final byte CURRENT_VERSION = 1;
    private String m_userId;
    private String m_appId;
    private long m_clientId;
    private boolean m_isInterbroker;
    private long m_lastConnectedTime;
    private ClientSecurityContext m_csc;

    public int length() {
        return StringUtil.lengthUTF(this.m_userId) + StringUtil.lengthUTF(this.m_appId) + 8 + 1 + 8 + 1 + (this.m_csc != null ? this.m_csc.length() : 0);
    }

    public void setUserId(String uid) {
        this.m_userId = uid;
    }

    public void setAppId(String appid) {
        this.m_appId = appid;
    }

    public void setClientId(long cid) {
        this.m_clientId = cid;
    }

    public void setCSC(ClientSecurityContext csc) {
        this.m_csc = csc;
    }

    public void setInterbroker(boolean isIB) {
        this.m_isInterbroker = isIB;
    }

    public void setLastConnectedTime(long lst) {
        this.m_lastConnectedTime = lst;
    }

    public String getUserId() {
        return this.m_userId;
    }

    public String getAppId() {
        return this.m_appId;
    }

    public long getClientId() {
        return this.m_clientId;
    }

    public ClientSecurityContext getCSC() {
        return this.m_csc;
    }

    public boolean getInterbroker() {
        return this.m_isInterbroker;
    }

    public long getLastConnectedTime() {
        return this.m_lastConnectedTime;
    }

    public void writeToStream(DataOutput stream, short version) throws IOException {
        stream.writeByte((byte)version);
        stream.writeUTF(this.m_userId);
        stream.writeUTF(this.m_appId);
        stream.writeLong(this.m_clientId);
        stream.writeBoolean(this.m_isInterbroker);
        stream.writeLong(this.m_lastConnectedTime);
        if (this.m_csc != null) {
            stream.writeBoolean(true);
            this.m_csc.serialize(stream);
        } else {
            stream.writeBoolean(false);
        }
    }

    public void readFromStream(DataInput stream, short version) throws IOException {
        stream.readByte();
        this.m_userId = stream.readUTF();
        this.m_appId = stream.readUTF();
        this.m_clientId = stream.readLong();
        this.m_isInterbroker = stream.readBoolean();
        this.m_lastConnectedTime = stream.readLong();
        if (stream.readBoolean()) {
            this.m_csc = ClientSecurityContext.unserialize(stream);
        }
    }

    public String toString() {
        return "ClientContextDescriptor [m_clientId:" + this.m_clientId + ", m_userId:" + this.m_userId + ", m_appId:" + this.m_appId + ", m_isInterbroker:" + this.m_isInterbroker + ", m_lastConnectedTime:" + this.m_lastConnectedTime + ", m_csc:" + this.m_csc + "]";
    }
}

