/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import java.util.HashMap;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.IPubSubDeleteTracker;
import progress.message.broker.MsgSaver;
import progress.message.broker.SubjectDeleteTracker;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;

public class PubSubDeleteTracker
extends DebugObject
implements IPubSubDeleteTracker {
    private HashMap m_deletes = new HashMap();
    private HashMap m_backupDeletes;
    private static final int MAX_DELETE_SIZE = 1000;
    private int m_deleteCount = 0;

    public PubSubDeleteTracker() {
        super(DebugState.GLOBAL_DEBUG_ON ? "PubSubDeleteTracker" : null);
    }

    @Override
    public synchronized void msgDelete(long clientId, long tracking, boolean subjectAck, short subjectTracking, boolean performDelete) {
        DeleteTracker tracker;
        Long lClientId = new Long(clientId);
        Long lTracking = new Long(tracking);
        HashMap<Long, DeleteTracker> messageIds = (HashMap<Long, DeleteTracker>)this.m_deletes.get(lClientId);
        if (messageIds == null) {
            messageIds = new HashMap<Long, DeleteTracker>();
            this.m_deletes.put(lClientId, messageIds);
        }
        if ((tracker = (DeleteTracker)messageIds.get(lTracking)) == null) {
            if (this.DEBUG) {
                this.debug("MessageDelete Tracking: cid =" + lClientId + " mid=" + lTracking);
            }
            if (subjectAck) {
                tracker = new DeleteTracker(tracking, clientId, performDelete);
                tracker.addDeletedSubject(subjectTracking);
                messageIds.put(lTracking, tracker);
            } else {
                messageIds.put(lTracking, new DeleteTracker(performDelete));
            }
            ++this.m_deleteCount;
        } else {
            if (this.DEBUG) {
                this.debug("MessageDelete Complete: cid =" + lClientId + " mid=" + lTracking);
            }
            if (subjectAck) {
                if (!tracker.isFullDelete()) {
                    if (tracker.getSubjectIds().remove(new Short(subjectTracking))) {
                        if (tracker.getSubjectIds().isEmpty()) {
                            messageIds.remove(lTracking);
                            --this.m_deleteCount;
                        }
                    } else {
                        if (performDelete && !tracker.shouldDoDelete()) {
                            tracker.m_doDelete = true;
                        }
                        tracker.addDeletedSubject(subjectTracking);
                    }
                }
            } else if (!tracker.m_fullDelete) {
                tracker.setFullDelete();
                if (performDelete && !tracker.shouldDoDelete()) {
                    tracker.m_doDelete = true;
                }
            } else {
                messageIds.remove(lTracking);
                --this.m_deleteCount;
            }
            if (messageIds.isEmpty()) {
                this.m_deletes.remove(lClientId);
            }
        }
        if (this.m_deleteCount > 1000) {
            if (this.DEBUG) {
                this.debug("Max delete size reached");
            }
            this.deleteOperationsForOutstandingDeletes();
        }
    }

    @Override
    public synchronized void syncBegin() {
        this.m_backupDeletes = this.m_deletes;
        this.m_deletes = new HashMap();
    }

    @Override
    public synchronized void syncEnd() {
        if (this.m_backupDeletes != null) {
            this.m_deleteCount -= this.m_backupDeletes.size();
            this.m_backupDeletes = null;
        }
    }

    @Override
    public synchronized void completeRecovery() {
        this.deleteOperationsForOutstandingDeletes();
    }

    private void deleteOperationsForOutstandingDeletes() {
        this.issueDeletes(this.m_backupDeletes);
        this.issueDeletes(this.m_deletes);
        this.reset();
    }

    private void issueDeletes(HashMap map) {
        if (map != null && !map.isEmpty()) {
            MsgSaver saver = AgentRegistrar.getAgentRegistrar().getMsgSaver();
            for (Long cid : map.keySet()) {
                HashMap messageIds = (HashMap)map.get(cid);
                if (messageIds == null) continue;
                for (Long mid : messageIds.keySet()) {
                    DeleteTracker tracker = (DeleteTracker)messageIds.get(mid);
                    if (!tracker.shouldDoDelete()) continue;
                    if (tracker.isFullDelete()) {
                        if (this.DEBUG) {
                            this.debug("Issuing complete Recovery delete: " + mid + " " + cid);
                        }
                        saver.deleteMsg(cid, mid, -1, false);
                        continue;
                    }
                    Iterator sids = tracker.getSubjectIds().iterator();
                    while (sids.hasNext()) {
                        saver.deleteMsg(tracker.getClientId(), tracker.getMessageId(), -1, false, true, (Short)sids.next());
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        this.m_deletes.clear();
        this.m_backupDeletes = null;
        this.m_deleteCount = 0;
    }

    private class DeleteTracker
    extends SubjectDeleteTracker {
        private boolean m_doDelete;
        private boolean m_fullDelete;

        DeleteTracker(boolean doDelete) {
            this.m_doDelete = false;
            this.m_fullDelete = false;
            this.m_doDelete = doDelete;
            this.m_fullDelete = true;
        }

        DeleteTracker(long messageId, long clientId, boolean doDelete) {
            super(messageId, clientId);
            this.m_doDelete = false;
            this.m_fullDelete = false;
            this.m_doDelete = doDelete;
            this.m_fullDelete = false;
        }

        final boolean shouldDoDelete() {
            return this.m_doDelete;
        }

        final boolean isFullDelete() {
            return this.m_fullDelete;
        }

        final void setFullDelete() {
            this.m_fullDelete = true;
            this.m_subjectIds = null;
        }
    }
}

