/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EBrokerAborted;
import progress.message.broker.LogInputStream;
import progress.message.broker.LogOutputStream;
import progress.message.broker.LogStreamFile;
import progress.message.broker.TxnContentMgrFile;
import progress.message.broker.prAccessor;
import progress.message.msg.IMgram;
import progress.message.msg.IOperationHandle;
import progress.message.util.IndexedList;
import progress.message.util.server.LongHolder;
import progress.message.zclient.DebugObject;

public class TxnFileReplicationMgr
extends DebugObject {
    private IndexedList m_txns = new IndexedList();
    public static final short SYNC_REPLICATION_FLAG = 1;
    public static final short FIRST_MESSAGE_FLAG = 2;

    TxnFileReplicationMgr() {
        super("TxnFileReplicationMgr");
    }

    public void deleteAllDiskResidentTxnFiles() {
        this.closeAllReplicatedFiles();
        File dir = new File(Config.TXN_FILE_PATH);
        File[] files = dir.listFiles();
        String txnFilenamePrefix = "Txn";
        if (files != null) {
            int i = 0;
            int size = files.length;
            File f = null;
            for (i = 0; i < size; ++i) {
                boolean rc;
                f = files[i];
                if (!f.getName().startsWith(txnFilenamePrefix)) continue;
                if (this.DEBUG) {
                    this.debug("deleting f.getName(): " + f.getName() + " f.length " + f.length());
                }
                if ((rc = f.delete()) || !this.DEBUG) continue;
                this.debug("delete " + f.getName() + " failed.");
            }
        }
    }

    public void closeReplicatedFile(int tid) {
        TxnFileHandle file = (TxnFileHandle)this.m_txns.get(tid);
        if (file != null) {
            file.closeMsgFile();
        }
        this.removeTxnFileHandle(tid);
    }

    public void closeAllReplicatedFiles() {
        Enumeration e = this.m_txns.elements();
        while (e.hasMoreElements()) {
            TxnFileHandle f = (TxnFileHandle)e.nextElement();
            f.closeMsgFile();
        }
        this.m_txns.clearList();
    }

    public void deleteTxnFile(int tid) {
        try {
            TxnFileHandle file = this.getTxnFileHandle(tid);
            file.closeMsgFile();
            file.delete();
        }
        finally {
            this.removeTxnFileHandle(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReplicatedMgram(int tid, short flags, IOperationHandle handle, long replicationGuarTrk) {
        TxnFileHandle file = null;
        if ((flags & 1) == 1 && (flags & 2) == 2) {
            this.deleteTxnFile(tid);
        }
        try {
            file = this.getTxnFileHandle(tid);
            file.onReplicatedMgram(handle);
        }
        catch (IOException ioe) {
            try {
                ioe.printStackTrace();
                BrokerComponent.getBrokerComponent().abort(prAccessor.getString("STR259"), ioe, 1);
            }
            catch (EBrokerAborted eba) {
                return;
            }
        }
        finally {
            if (replicationGuarTrk != -1L) {
                AgentRegistrar.getAgentRegistrar().getReplicationManager().acknowledge(replicationGuarTrk);
                if (this.DEBUG) {
                    this.debug("onReplicatedMgram acknowledged: " + replicationGuarTrk);
                }
            }
            if ((flags & 1) == 1 && file != null) {
                if (this.DEBUG) {
                    this.debug("onReplicatedMgram closing the file for tid : " + tid);
                }
                this.closeReplicatedFile(tid);
            }
        }
    }

    private TxnFileHandle getTxnFileHandle(int tid) {
        TxnFileHandle file = (TxnFileHandle)this.m_txns.get(tid);
        if (file == null) {
            file = new TxnFileHandle(tid);
            this.m_txns.appendNoDup(tid, file);
        }
        return file;
    }

    private void removeTxnFileHandle(int tid) {
        this.m_txns.remove(tid);
    }

    class TxnFileHandle {
        int m_tid = -1;
        private LogStreamFile m_msgFile = null;
        private File m_msgFileName = null;
        private OutputStream m_os = null;

        TxnFileHandle(int tid) {
            this.m_tid = tid;
        }

        void onReplicatedMgram(IOperationHandle handle) throws IOException {
            IMgram m = null;
            IMgram txwrapper = null;
            IOperationHandle txwrapperop = null;
            long origTracking = -1L;
            Iterator it = handle.getMgramList().iterator();
            this.openMsgFile(true);
            while (it.hasNext()) {
                txwrapper = (IMgram)it.next();
                txwrapperop = txwrapper.getOperationHandle();
                m = (IMgram)txwrapperop.getMgramList().getFirst();
                m = m.getReplicatedMgramHandle().getReplicatedMgram();
                ObjectInput oi = txwrapper.getPayloadInputStreamHandle();
                origTracking = oi.readLong();
                if (TxnFileReplicationMgr.this.DEBUG) {
                    TxnFileReplicationMgr.this.debug("onReplicatedMgram tid = " + this.m_tid + " type " + m.getType());
                }
                TxnContentMgrFile.serialize(this.m_os, origTracking, m);
            }
            try {
                this.m_os.flush();
                this.m_msgFile.sync();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete() {
            if (TxnFileReplicationMgr.this.DEBUG) {
                TxnFileReplicationMgr.this.debug("delete tid = " + this.m_tid);
            }
            TxnFileHandle txnFileHandle = this;
            synchronized (txnFileHandle) {
                if (this.m_msgFile != null) {
                    try {
                        this.m_msgFile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.m_msgFileName == null) {
                    this.m_msgFileName = new File(Config.TXN_FILE_FULLPATH_PREFIX + this.m_tid);
                }
                if (this.m_msgFileName.exists()) {
                    this.m_msgFileName.delete();
                }
                if (TxnFileReplicationMgr.this.DEBUG) {
                    TxnFileReplicationMgr.this.debug("Deleted ");
                }
            }
        }

        private void closeMsgFile() {
            if (TxnFileReplicationMgr.this.DEBUG) {
                TxnFileReplicationMgr.this.debug("closeMsgFile tid = " + this.m_tid);
            }
            if (this.m_msgFile == null) {
                return;
            }
            try {
                this.m_msgFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_msgFile = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openMsgFile(boolean append) throws IOException {
            LongHolder origTrackingHolder = new LongHolder(-1L);
            if (this.m_msgFile == null) {
                this.m_msgFileName = new File(Config.TXN_FILE_FULLPATH_PREFIX + this.m_tid);
                this.m_msgFile = new LogStreamFile(Config.TXN_FILE_FULLPATH_PREFIX + this.m_tid);
                this.m_os = this.m_msgFile.getOutputStream();
                if (append) {
                    long pos = 0L;
                    try {
                        IMgram m;
                        LogInputStream is = this.m_msgFile.getInputStream();
                        pos = is.getFilePointer();
                        while (!(m = TxnContentMgrFile.unserialize(is, origTrackingHolder)).getBrokerHandle().isTxnEOFMarker()) {
                            pos = is.getFilePointer();
                        }
                    }
                    catch (IOException is) {
                    }
                    catch (Throwable re) {
                        re.printStackTrace();
                    }
                    finally {
                        this.closeMsgFile();
                        this.openMsgFile(false);
                        ((LogOutputStream)this.m_os).seek(pos);
                    }
                }
            }
        }
    }
}

