/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.msg.IDefaultPayloadHandle;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.Payload;
import progress.message.msg.v24.SidebandData;
import progress.message.msg.v24.StreamUtilCounter;
import progress.message.resources.prMessageFormat;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;
import progress.message.zclient.CryptoInfo;
import progress.message.zclient.CryptoInfoLinkedList;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ISidebandData;
import progress.message.zclient.prAccessor;

final class DefaultPayload
extends Payload
implements IDefaultPayloadHandle {
    private static int PAYLOAD_CHUNK_SIZE = 65536;
    private static final int RRS_SEND = 0;
    private static final int RRS_REQUEST = 2;
    private static final int RRS_REPLY = 3;
    private static final byte SUBJECT_MASK = 1;
    private static final byte BODY_MASK = 2;
    private static final byte SIDEBAND_MASK = 4;
    private byte[] m_prebodyBuffer = null;
    private boolean m_preBodyDirty = true;
    private byte[] m_bodyBuffer = null;
    private int m_bodyBufferLength = 0;
    private boolean m_hasBody = false;
    private boolean m_hasID = false;
    private long m_idHigh = 0L;
    private long m_idLow = 0L;
    private boolean m_hasSideband = false;
    private byte[] m_destinationAddress = null;
    private byte[] m_sourceAddress = null;
    private byte[] m_replyAddress = null;
    private int m_replyPrio;
    private int m_raf;
    private byte m_requestProtection;
    private String m_replyString;
    private String m_subject;
    private byte[] m_subjectUTF;
    private boolean m_hasSubject = false;
    private byte m_subjectBodyBits;
    private int m_txnId;
    private long m_trackingNum;
    private StreamUtilCounter m_utilCounter = null;
    private ISidebandData m_sidebandData;
    private int m_preBodyLength = -1;
    private boolean m_preBodyProtected = false;
    private boolean m_sidebandProtected = false;
    private boolean m_bodyProtected = false;

    public DefaultPayload(Mgram m) {
        super(m);
    }

    @Override
    public Object clone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        if (!this.m_preBodyDirty) {
            dp.m_prebodyBuffer = new byte[this.m_prebodyBuffer.length];
            System.arraycopy(this.m_prebodyBuffer, 0, dp.m_prebodyBuffer, 0, this.m_prebodyBuffer.length);
        }
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (ISidebandData)this.m_sidebandData.clone();
        }
        if (this.m_bodyBuffer != null) {
            dp.m_bodyBuffer = new byte[this.m_bodyBufferLength];
            System.arraycopy(this.m_bodyBuffer, 0, dp.m_bodyBuffer, 0, this.m_bodyBufferLength);
        }
        dp.m_preBodyProtected = false;
        dp.m_sidebandProtected = false;
        dp.m_bodyProtected = false;
        return dp;
    }

    @Override
    public Object shallowClone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        if (this.m_sidebandData != null) {
            dp.m_sidebandData = (ISidebandData)this.m_sidebandData.shallowClone();
        }
        return dp;
    }

    @Override
    public Object protectedClone(Mgram m) throws CloneNotSupportedException {
        DefaultPayload dp = (DefaultPayload)super.clone(m);
        dp.m_preBodyProtected = true;
        dp.m_sidebandProtected = true;
        dp.m_bodyProtected = true;
        return dp;
    }

    @Override
    public void protectSideband() {
        this.m_sidebandProtected = true;
    }

    private void unprotectPreBody() {
        if (this.m_preBodyProtected) {
            if (this.m_prebodyBuffer != null && !this.m_preBodyDirty) {
                this.m_prebodyBuffer = this.copyByteArray(this.m_prebodyBuffer);
            }
            if (this.m_destinationAddress != null) {
                this.m_destinationAddress = this.copyByteArray(this.m_destinationAddress);
            }
            if (this.m_sourceAddress != null) {
                this.m_sourceAddress = this.copyByteArray(this.m_sourceAddress);
            }
            if (this.m_replyAddress != null) {
                this.m_replyAddress = this.copyByteArray(this.m_replyAddress);
            }
            if (this.m_subjectUTF != null) {
                this.m_subjectUTF = this.copyByteArray(this.m_subjectUTF);
            }
            this.m_preBodyProtected = false;
        }
    }

    private void unprotectSideBand() {
        if (this.m_sidebandProtected) {
            this.m_sidebandData = (ISidebandData)this.m_sidebandData.clone();
            this.m_sidebandProtected = false;
        }
    }

    private byte[] copyByteArray(byte[] src) {
        byte[] result = new byte[src.length];
        System.arraycopy(src, 0, result, 0, result.length);
        return result;
    }

    @Override
    void initPayloadFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_utilCounter = new StreamUtilCounter();
        this.readPreBodyFromStream(is);
        switch (this.m_mgram.getType()) {
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                byte m_subjectBodyBits = this.populateData(is);
                if ((m_subjectBodyBits & 2) == 0) break;
                this.m_hasBody = true;
                this.populateBuffer(is);
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                int lengthLeft = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
                if (lengthLeft > 0) {
                    this.populateBodyAndRead(is, lengthLeft);
                    break;
                }
                this.m_hasBody = false;
                break;
            }
            default: {
                throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR071"), new Object[]{Byte.toString(this.m_mgram.getType())}));
            }
        }
        this.updateStatus(is);
    }

    private void populateBuffer(InputStream is) throws IOException {
        int length = this.m_mgram.getMessageLength() - this.m_utilCounter.getCounter();
        this.m_bodyBuffer = new byte[length];
        this.m_bodyBufferLength = length;
        StreamUtil.readBytes(is, this.m_bodyBuffer, 0, length);
    }

    private byte populateData(InputStream is) throws IOException {
        byte m_subjectBodyBits = this.m_utilCounter.readByte(is);
        this.m_preBodyLength = this.m_utilCounter.getCounter();
        if ((m_subjectBodyBits & 1) != 0) {
            this.m_hasSubject = true;
            this.m_subjectUTF = this.m_utilCounter.readUTFString(is);
            try {
                this.m_subject = StringUtil.UTFToString(this.m_subjectUTF, 0);
            }
            catch (UTFDataFormatException e) {
                e.printStackTrace();
            }
            this.m_preBodyLength = this.m_utilCounter.getCounter();
        }
        boolean sidebandSize = false;
        if ((m_subjectBodyBits & 4) != 0) {
            this.m_hasSideband = true;
            this.m_sidebandData = new SidebandData();
            this.m_utilCounter.incrementCounter(this.m_sidebandData.readFromStream(is));
        }
        return m_subjectBodyBits;
    }

    private void updateStatus(InputStream is) throws IOException {
        if (this.m_mgram.isSecure()) {
            StreamUtil.skip(is, this.m_mgram.getMessagePad());
        }
        this.m_mgram.setStatus(3);
    }

    private void populateBodyAndRead(InputStream is, int lengthLeft) throws IOException {
        this.m_bodyBuffer = new byte[lengthLeft];
        this.m_bodyBufferLength = lengthLeft;
        this.m_utilCounter.readBytes(is, this.m_bodyBuffer, 0, lengthLeft);
        this.m_hasBody = true;
    }

    private void readPreBodyFromStream(InputStream is) throws IOException, EMgramFormatError {
        this.m_preBodyDirty = true;
        if (this.m_mgram.hasID()) {
            this.m_idHigh = this.m_utilCounter.readLong(is);
            this.m_idLow = this.m_utilCounter.readLong(is);
            this.m_hasID = true;
        }
        this.m_destinationAddress = this.readAddress(is, this.m_mgram.getDestinationAddressFormat());
        this.m_sourceAddress = this.readAddress(is, this.m_mgram.getSourceAddressFormat());
        this.readRequestReplyBytes(is);
        if (this.m_mgram.isGuarenteed()) {
            this.m_trackingNum = this.m_utilCounter.read6ByteLong(is);
        }
        if (this.m_mgram.hasTxn()) {
            this.m_txnId = this.m_utilCounter.readInt(is);
        }
        this.m_preBodyLength = this.m_utilCounter.getCounter();
    }

    private byte[] readAddress(InputStream is, int format) throws IOException, EMgramFormatError {
        byte[] address = null;
        switch (format) {
            case 3: {
                byte byte1 = this.m_utilCounter.readByte(is);
                byte byte2 = this.m_utilCounter.readByte(is);
                int len = (byte1 & 0xFF) << 10 | (byte2 & 0xFF) << 2;
                if (len > 0) {
                    address = new byte[len + 2];
                    this.m_utilCounter.readBytes(is, address, 2, len);
                    address[0] = byte1;
                    address[1] = byte2;
                }
                return address;
            }
            case 2: {
                address = new byte[4];
                this.m_utilCounter.readBytes(is, address, 0, 4);
                return address;
            }
            case 1: {
                address = this.m_utilCounter.readUTFString(is);
                return address;
            }
            case 0: {
                return null;
            }
        }
        throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR079"), new Object[]{Integer.toString(format)}));
    }

    private void writeAddress(OutputStream os, byte[] address, int format) throws IOException {
        switch (format) {
            case 3: {
                int len = (address[0] & 0xFF) << 8 | address[1] & 0xFF;
                os.write(address, 0, address.length);
                break;
            }
            case 1: 
            case 2: {
                os.write(address, 0, address.length);
                break;
            }
            case 0: {
                break;
            }
        }
    }

    private void readRequestReplyBytes(InputStream is) throws IOException, EMgramFormatError {
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = this.m_utilCounter.readByte(is);
                this.m_replyPrio = requestReplyBits & 0xF;
                this.m_raf = (requestReplyBits & 0xF0) >>> 4;
                this.m_replyAddress = this.readAddress(is, (requestReplyBits & 0xF0) >>> 4);
                byte type = this.m_mgram.getType();
                if (type != 0 && type != 7 && type != 4) {
                    byte[] replyString = this.m_utilCounter.readUTFString(is);
                    this.m_replyString = StringUtil.UTFToString(replyString, 0);
                }
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            case 3: {
                if (!this.m_mgram.isSecure()) break;
                this.m_requestProtection = this.m_mgram.getSecurity();
                break;
            }
            default: {
                throw new EMgramFormatError(prMessageFormat.format(prAccessor.getString("STR067"), new Object[]{Integer.toString(this.m_mgram.getRequestReplyFieldType())}));
            }
        }
    }

    private void writeRequestReplyBytes(OutputStream os) throws IOException {
        switch (this.m_mgram.getRequestReplyFieldType()) {
            case 0: {
                break;
            }
            case 2: {
                byte requestReplyBits = (byte)(this.m_replyPrio & 0xF);
                requestReplyBits = (byte)(requestReplyBits | (byte)(this.m_raf & 0xF) << 4);
                os.write(requestReplyBits);
                this.writeAddress(os, this.m_replyAddress, this.m_raf);
                byte type = this.m_mgram.getType();
                if (type == 0 || type == 7 || type == 4) break;
                os.write(StringUtil.stringToUTF(this.m_replyString));
                break;
            }
            case 3: {
                break;
            }
        }
    }

    @Override
    boolean hasID() {
        return this.m_hasID;
    }

    @Override
    byte[] getID() {
        byte[] result = new byte[16];
        ArrayUtil.writeLong(result, 0, this.m_idHigh);
        ArrayUtil.writeLong(result, 8, this.m_idLow);
        return result;
    }

    @Override
    void setID(byte[] id) {
        this.unprotectPreBody();
        this.m_idHigh = ArrayUtil.readLong(id, 0);
        this.m_idLow = ArrayUtil.readLong(id, 8);
        this.setPreBodyDirty();
    }

    @Override
    void setTxn(int tid) {
        this.m_txnId = this.updateBodySetTxnId(tid);
    }

    private void setPreBodyDirty() {
        this.m_preBodyDirty = true;
        this.m_preBodyLength = -1;
    }

    @Override
    void clearID() {
        if (this.m_idHigh != 0L || this.m_idLow != 0L || this.m_hasID) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_idHigh = 0L;
        this.m_idLow = 0L;
        this.m_hasID = false;
    }

    @Override
    void clearAddresses() {
        if (this.m_raf != 0 || this.m_destinationAddress != null || this.m_replyAddress != null) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_raf = 0;
        this.m_replyAddress = null;
        this.m_destinationAddress = null;
    }

    @Override
    byte[] getRawPreBody() {
        this.syncPreBodyBuffer();
        return this.m_prebodyBuffer;
    }

    @Override
    void setGuarenteed(long tracking) {
        this.m_trackingNum = this.updateBodySetTxnId(tracking);
    }

    @Override
    void setRequest(byte[] replyToAddress, String replySubject) {
        this.unprotectPreBody();
        this.m_replyAddress = replyToAddress;
        this.m_replyString = replySubject;
        this.m_raf = 3;
        this.setPreBodyDirty();
    }

    @Override
    void setReplyToString(String value) {
        if (value != null) {
            if (!value.equals(this.m_replyString)) {
                this.setPreBodyDirty();
                this.unprotectPreBody();
            }
        } else if (this.m_replyString != null) {
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
        this.m_replyString = value;
    }

    @Override
    byte[] getReplyToAddress() {
        return this.m_replyAddress;
    }

    @Override
    int getReplyToAddressFormat() {
        return this.m_raf;
    }

    @Override
    void setReplyToAddressFormat(int format) {
        if (this.m_raf != format) {
            this.m_raf = format;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
    }

    @Override
    String getReplyToAddressString() {
        return this.m_replyString;
    }

    @Override
    void setDestinationAddress(byte[] address) {
        this.m_destinationAddress = this.updateBodySetTxnId(address);
    }

    private <T0> T0 updateBodySetTxnId(T0 tid) {
        this.unprotectPreBody();
        T0 m_txnId = tid;
        this.setPreBodyDirty();
        return m_txnId;
    }

    @Override
    byte[] getDestinationAddress() {
        return this.m_destinationAddress;
    }

    @Override
    boolean canHaveReplyTracking() {
        return this.m_destinationAddress != null && this.m_destinationAddress.length >= 4;
    }

    @Override
    byte[] toByteArray() {
        byte[] bodyBuffer;
        int length = 0;
        this.syncPreBodyBuffer();
        if (this.m_prebodyBuffer != null) {
            length += this.m_prebodyBuffer.length;
        }
        if (this.m_hasSideband) {
            byte[] sidebandBuffer = this.getRawSidebandBuffer();
            length += sidebandBuffer.length;
        }
        if ((bodyBuffer = this.getRawBodyBuffer()) != null) {
            length += this.getBodyLength();
        }
        byte[] newByteArray = new byte[length];
        int pos = 0;
        if (this.m_prebodyBuffer != null) {
            System.arraycopy(this.m_prebodyBuffer, 0, newByteArray, pos, this.m_prebodyBuffer.length);
            pos += this.m_prebodyBuffer.length;
        }
        if (this.m_hasSideband) {
            byte[] sidebandBuffer = this.m_sidebandData.getRawSidebandBuffer();
            System.arraycopy(sidebandBuffer, 0, newByteArray, pos, sidebandBuffer.length);
            pos += sidebandBuffer.length;
        }
        if (this.m_hasBody) {
            System.arraycopy(this.m_bodyBuffer, 0, newByteArray, pos, this.m_bodyBufferLength);
            pos += this.m_bodyBufferLength;
        }
        return newByteArray;
    }

    void syncSidebandBuffer() {
        if (this.m_hasSideband) {
            this.unprotectSideBand();
            this.m_sidebandData.sync();
        }
    }

    @Override
    byte[] getRawSidebandBuffer() {
        if (this.m_sidebandData == null) {
            return null;
        }
        return this.m_sidebandData.getRawSidebandBuffer();
    }

    @Override
    byte[] getRawBodyBuffer() {
        return this.m_bodyBuffer;
    }

    private void syncPreBodyBuffer() {
        if (this.m_preBodyDirty) {
            this.unprotectPreBody();
            ByteArrayOutputStream bos = this.m_prebodyBuffer != null ? new ByteArrayOutputStream(this.m_prebodyBuffer.length) : new ByteArrayOutputStream();
            try {
                this.writePreBodyToStream(bos);
                bos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_prebodyBuffer = bos.toByteArray();
            this.m_preBodyDirty = false;
        }
    }

    private void writePreBodyToStream(OutputStream os) throws IOException {
        if (this.m_preBodyDirty) {
            this.writeData(os);
            this.handleType(os);
        } else {
            os.write(this.m_prebodyBuffer);
        }
    }

    private void handleType(OutputStream os) throws IOException {
        switch (this.m_mgram.getType()) {
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                this.m_subjectBodyBits = 0;
                if (this.hasSubject()) {
                    this.m_subjectBodyBits = (byte)(this.m_subjectBodyBits | 1);
                }
                if (this.m_hasSideband) {
                    this.m_subjectBodyBits = (byte)(this.m_subjectBodyBits | 4);
                }
                if (this.m_hasBody) {
                    this.m_subjectBodyBits = (byte)(this.m_subjectBodyBits | 2);
                }
                os.write(this.m_subjectBodyBits);
                if (!this.hasSubject()) break;
                os.write(this.m_subjectUTF);
            }
        }
    }

    private void writeData(OutputStream os) throws IOException {
        if (this.m_mgram.hasID()) {
            StreamUtil.writeLong(this.m_idHigh, os);
            StreamUtil.writeLong(this.m_idLow, os);
        }
        this.writeAddress(os, this.m_destinationAddress, this.m_mgram.getDestinationAddressFormat());
        this.writeAddress(os, this.m_sourceAddress, this.m_mgram.getSourceAddressFormat());
        this.writeRequestReplyBytes(os);
        if (this.m_mgram.isGuarenteed()) {
            StreamUtil.write6ByteLong(this.m_trackingNum, os);
        }
        if (this.m_mgram.hasTxn()) {
            StreamUtil.writeInt(this.m_txnId, os);
        }
    }

    @Override
    void writeToStream(OutputStream os) throws IOException {
        this.writePreBodyToStream(os);
        switch (this.m_mgram.getType()) {
            case 2: 
            case 11: 
            case 12: 
            case 13: {
                if (this.m_hasSideband) {
                    this.m_sidebandData.writeToStream(os);
                }
                if (!this.m_hasBody) break;
                this.chunkWrite(os, this.m_bodyBuffer, 0, this.m_bodyBufferLength, PAYLOAD_CHUNK_SIZE);
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (!this.m_hasBody) break;
                os.write(this.m_bodyBuffer, 0, this.m_bodyBufferLength);
                break;
            }
        }
        if (this.m_mgram.isSecure()) {
            int pad = this.m_mgram.getMessagePad();
            byte[] padArray = new byte[pad];
            os.write(padArray);
        }
    }

    private void chunkWrite(OutputStream os, byte[] data, int offset, int dataLength, int chunkSize) throws IOException {
        int remainder = dataLength % chunkSize;
        int numChunks = dataLength / chunkSize;
        if (numChunks != 0) {
            int currentPointer = offset;
            for (int count = 0; count < numChunks; ++count) {
                os.write(data, currentPointer, chunkSize);
                currentPointer += chunkSize;
                os.flush();
            }
            if (remainder != 0) {
                os.write(data, dataLength - remainder + offset, remainder);
            }
        } else {
            os.write(data, offset, dataLength);
        }
    }

    @Override
    int getReplyPriority() {
        return this.m_replyPrio;
    }

    @Override
    void setReplyPriority(int priority) {
        if (priority != this.m_replyPrio) {
            this.m_replyPrio = priority;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        }
    }

    @Override
    boolean hasSubject() {
        return this.m_hasSubject;
    }

    @Override
    ISidebandData getSidebandData() {
        this.unprotectSideBand();
        return this.m_sidebandData;
    }

    @Override
    void createSidebandDataIfNeeded() {
        if (this.m_sidebandData == null) {
            this.m_hasSideband = true;
            this.m_sidebandData = new SidebandData();
            this.m_sidebandProtected = false;
        }
    }

    @Override
    String getSubject() {
        return this.m_subject;
    }

    @Override
    void setSubject(String subject) {
        if (subject != null) {
            if (subject.equals(this.m_subject)) {
                this.m_hasSubject = true;
                return;
            }
            this.m_subject = subject;
            try {
                this.m_subjectUTF = StringUtil.stringToUTF(subject);
            }
            catch (UTFDataFormatException e) {
                throw new EAssertFailure("UTF Format Exception in given subject");
            }
            this.m_hasSubject = true;
            this.setPreBodyDirty();
            this.unprotectPreBody();
        } else {
            this.m_hasSubject = false;
        }
    }

    @Override
    long getGuarenteedTrackingNum() {
        return this.m_trackingNum;
    }

    @Override
    boolean hasBody() {
        return this.m_hasBody;
    }

    @Override
    void setBody(byte[] body, int length) {
        if (body != null) {
            this.m_bodyBuffer = body;
            this.m_bodyBufferLength = length;
            this.m_hasBody = true;
            this.m_bodyProtected = false;
        } else {
            this.m_hasBody = false;
            this.m_bodyBuffer = null;
            this.m_bodyBufferLength = 0;
            this.m_bodyProtected = false;
        }
    }

    @Override
    int getBodyLength() {
        return this.m_bodyBufferLength;
    }

    @Override
    void setSidebandData(ISidebandData sd) {
        if (sd != null) {
            this.m_sidebandData = sd;
            this.m_hasSideband = true;
            this.m_sidebandProtected = false;
        } else {
            this.m_hasSideband = false;
        }
    }

    @Override
    int length() {
        int length = 0;
        if (this.m_hasSideband) {
            length += this.m_sidebandData.getSerializedLength();
        }
        if (this.m_prebodyBuffer != null || this.m_preBodyDirty) {
            if (this.m_preBodyLength == -1) {
                this.syncPreBodyBuffer();
                length += this.m_prebodyBuffer.length;
            } else {
                length += this.m_preBodyLength;
            }
        }
        if (this.m_hasBody) {
            length += this.m_bodyBufferLength;
        }
        return length;
    }

    @Override
    void sync() {
        this.syncSidebandBuffer();
        this.syncPreBodyBuffer();
    }

    @Override
    CryptoInfoLinkedList createMacInfoLinkedList() {
        this.syncPreBodyBuffer();
        CryptoInfoLinkedList macLinkedList = new CryptoInfoLinkedList();
        macLinkedList.addLast(new CryptoInfo(this.m_prebodyBuffer, 0, this.m_prebodyBuffer.length));
        byte[] sideBandBuffer = this.getRawSidebandBuffer();
        if (sideBandBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(sideBandBuffer, 0, sideBandBuffer.length));
        }
        if (this.m_bodyBuffer != null) {
            macLinkedList.addLast(new CryptoInfo(this.m_bodyBuffer, 0, this.m_bodyBufferLength));
        }
        return macLinkedList;
    }
}

