/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.license;

import progress.message.util.license.Coder32Decode;
import progress.message.util.license.LicenseCommon;
import progress.message.util.license.Random16;

public final class LicenseDecoder {
    public static final boolean bTraceEvents = false;
    int product = 0;
    int serial = 0;
    int count = 0;

    public LicenseDecoder(String version, String cc) throws Exception {
        this.decrypt(version, cc);
    }

    public final int getProduct() {
        return this.product;
    }

    public final int getSerial() {
        return this.serial;
    }

    public final int getCount() {
        return this.count;
    }

    synchronized void decrypt(String version, String pass0) throws Exception {
        try {
            int seed = LicenseCommon.getSeed(version);
            Coder32Decode c = new Coder32Decode(5);
            byte[] b = c.decode(pass0.toLowerCase());
            if (b.length != 9) {
                throw new Exception("password length error" + b.length);
            }
            int pos = 0;
            byte[] prodBytes = new byte[2];
            LicenseCommon._arraycopy(b, prodBytes, pos);
            byte[] crcBytes = new byte[1];
            LicenseCommon._arraycopy(b, crcBytes, pos += prodBytes.length);
            byte[] countBytes = new byte[2];
            LicenseCommon._arraycopy(b, countBytes, pos += crcBytes.length);
            byte[] licenseBytes = new byte[4];
            LicenseCommon._arraycopy(b, licenseBytes, pos += countBytes.length);
            pos += licenseBytes.length;
            Random16 r = new Random16(seed);
            LicenseCommon._encrypt(prodBytes, r);
            LicenseCommon._encrypt(crcBytes, r);
            LicenseCommon._encrypt(countBytes, r);
            LicenseCommon._encrypt(licenseBytes, r);
            byte crc = LicenseCommon._getCRC(prodBytes, (byte)0);
            crc = LicenseCommon._getCRC(countBytes, crc);
            crc = LicenseCommon._getCRC(licenseBytes, crc);
            byte crcOld = (byte)LicenseCommon._fromBytes(crcBytes);
            if (crcOld != crc) {
                throw new Exception("CRC error");
            }
            this.count = (int)LicenseCommon._fromBytes(countBytes);
            this.product = (int)LicenseCommon._fromBytes(prodBytes);
            this.serial = (int)LicenseCommon._fromBytes(licenseBytes);
        }
        catch (Exception e) {
            throw new Exception("password is not valid for control code " + pass0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        String version = null;
        String cc = null;
        int i = 0;
        try {
            while (i < args.length) {
                try {
                    String arg = args[i++].toLowerCase();
                    if (arg.equals("-v")) {
                        version = args[i++];
                        continue;
                    }
                    if (arg.equals("-w")) {
                        cc = args[i++];
                        continue;
                    }
                    System.out.println("WARNING\tUnknown option: " + arg);
                }
                catch (ArrayIndexOutOfBoundsException a) {
                    // empty catch block
                    break;
                }
            }
            LicenseDecoder ld = null;
            ld = new LicenseDecoder(version, cc);
            System.out.println("LicenseDecoder Product: \"" + ld.getProduct() + "\"");
            System.out.println("LicenseDecoder Count: \"" + ld.getCount() + "\"");
            System.out.println("LicenseDecoder Serial: \"" + ld.getSerial() + "\"\n");
            return;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("\nUSAGE: java LicenseDecoder -w <cc> -v <version> \n");
        }
    }
}

