/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.common.runtime.impl;

import com.sonicsw.mf.common.IXMLFragment;
import com.sonicsw.mq.common.runtime.IMessageHeaderToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MessageHeaderToken
implements IMessageHeaderToken,
IXMLFragment {
    private static final short CURRENT_VERSION = 0;
    static final long serialVersionUID = -9032176428737541547L;
    private String m_messageID;
    private String m_originationBroker;
    private long m_clientId;
    private boolean m_hasOriginationBroker = false;

    public MessageHeaderToken(String messageID, long clientId, String originationBroker) {
        this.m_messageID = messageID;
        this.m_originationBroker = originationBroker;
        if (this.m_originationBroker != null) {
            this.m_hasOriginationBroker = true;
        }
        this.m_clientId = clientId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[messageID=").append(this.m_messageID).append(']');
        sb.append("originationBroker=").append(this.m_originationBroker);
        sb.append(",clientID=").append(this.m_clientId);
        return sb.toString();
    }

    public String toXMLFragment() {
        StringBuffer sb = new StringBuffer();
        sb.append("<messageHeaderToken>");
        sb.append("<messageID>").append(this.m_messageID).append("</messageID>");
        sb.append("<originationBroker>").append(this.m_originationBroker).append("</originationBroker>");
        sb.append("<clientID>").append(this.m_clientId).append("</clientID>");
        sb.append("</messageHeaderToken>");
        return sb.toString();
    }

    public String getJMSMessageID() {
        return this.m_messageID;
    }

    public long getClientId() {
        return this.m_clientId;
    }

    public String getOriginationBroker() {
        return this.m_originationBroker;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(0);
        stream.writeUTF(this.m_messageID);
        stream.writeBoolean(this.m_hasOriginationBroker);
        if (this.m_hasOriginationBroker) {
            stream.writeUTF(this.m_originationBroker);
        }
        stream.writeLong(this.m_clientId);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        switch (stream.readShort()) {
            case 0: {
                this.m_messageID = stream.readUTF();
                this.m_hasOriginationBroker = stream.readBoolean();
                if (this.m_hasOriginationBroker) {
                    this.m_originationBroker = stream.readUTF();
                }
                this.m_clientId = stream.readLong();
                break;
            }
        }
    }
}

