/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.security.cert.BrokerKeyStore;
import java.security.KeyStoreException;
import progress.message.broker.Config;

public class BrokerCredentialsChangeHandler
implements IAttributeChangeHandler {
    private BrokerKeyStore m_store = null;

    public BrokerCredentialsChangeHandler(BrokerKeyStore store) {
        this.m_store = store;
    }

    public void itemDeleted() {
        try {
            this.m_store.resetDefaultCertificate(null, null);
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public void itemModified(Object newValue) {
        int i;
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String[] newAttributes = delta.getNewAttributesNames();
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        String utUsername = null;
        String utPassword = null;
        String x509TokenAlias = null;
        String x509TokenPassword = null;
        for (i = 0; i < newAttributes.length; ++i) {
            if (newAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                try {
                    utUsername = (String)delta.getNewValue(newAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (newAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                try {
                    utPassword = (String)delta.getNewValue(newAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (newAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                try {
                    x509TokenAlias = (String)delta.getNewValue(newAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (!newAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            try {
                x509TokenPassword = (String)delta.getNewValue(newAttributes[i]);
                continue;
            }
            catch (NotModifiedAttException e) {
                BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
            }
        }
        for (i = 0; i < modifiedAttributes.length; ++i) {
            if (modifiedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                try {
                    utUsername = (String)delta.getNewValue(modifiedAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (modifiedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                try {
                    utPassword = (String)delta.getNewValue(modifiedAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                try {
                    x509TokenAlias = (String)delta.getNewValue(modifiedAttributes[i]);
                }
                catch (NotModifiedAttException e) {
                    BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
                }
            }
            if (!modifiedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            try {
                x509TokenPassword = (String)delta.getNewValue(modifiedAttributes[i]);
                continue;
            }
            catch (NotModifiedAttException e) {
                BrokerCredentialsChangeHandler.printStackTraceCheckingDebug(e);
            }
        }
        for (i = 0; i < deletedAttributes.length; ++i) {
            if (deletedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_USERNAME")) {
                utUsername = null;
            }
            if (deletedAttributes[i].equalsIgnoreCase("USERNAMETOKEN_PASSWORD")) {
                utPassword = null;
            }
            if (deletedAttributes[i].equalsIgnoreCase("X509TOKEN_ALIAS")) {
                x509TokenAlias = null;
            }
            if (!deletedAttributes[i].equalsIgnoreCase("X509TOKEN_PASSWORD")) continue;
            x509TokenPassword = null;
        }
        BrokerComponent.getComponentContext().logMessage("Reloading broker default certificate", 3);
        try {
            this.m_store.resetDefaultCertificate(x509TokenAlias, x509TokenPassword);
            Config.WS_SECURITY_UT_USER = utUsername;
            Config.WS_SECURITY_UT_PASSWORD = utPassword;
        }
        catch (Exception ex) {
            BrokerComponent.getComponentContext().logMessage(ex.getMessage(), 2);
        }
    }

    private static void printStackTraceCheckingDebug(NotModifiedAttException e) {
    }
}

